#!/bin/bash

###################################################
#Infience of the order nonlinear activation and GNC
###################################################

##################################
#A.1 GNC activation followed by sT
for SEED in 0 1 2
do
    BASE_DIR="../neurips_2022_results/influence/st-act_followed_by_gnc/"
    SAVE_DIR_NAME="${BASE_DIR}"
    #SAVE_DIR_NAME="${BASE_DIR}"+"${REPLAY_BATCH_SIZE}"+"_"+"${NORMALIZE_BINS}"+"/"
    python3  main_extention.py --cuda --expt_name gnc_act_after --log_dir 'logs/' --log_every 3125 \
                  --seed $SEED --data_path data/ --dataset cifar100 \
                  --loader class_incremental_loader --class_order 'random' --increment 5 \
                  --model gnc_er --arch 'pc_cnn_extention[linear-simple]' \
                  --update_type 'with-primary-loss' \
                  --n_epochs 1 --glances 1 \
                  --memories 200 --batch_size 10 \
                  --replay_batch_size 4 --cifar_batches 5 \
                  --sampling_type peace_by_peace_batch --selective_mem_push 'none' \
                  --sub_bin_size 10 --num_of_bins 32 \
                  --normilize_sub_bins "normilize_sub_bins[ON]" \
                  --gnc_lr .3 \
                  --clip_grad_norm "clip_grad_norm[yes]" \
                  --grad_clip_norm 2.0 \
                  --calc_test_accuracy --validation 0.1 \
                  --is_ER_active 'yes'
                  --save_dir $SAVE_DIR_NAME
done                  
#--learn_lr --opt_lr .3 --alpha_init .3 --opt_wt 0.3 \

##################################
#A.2 sT activation followed by GNC
for SEED in 0 1 2
do
    BASE_DIR="../neurips_2022_results/influence/gnc_followed_by_st-act/"
    SAVE_DIR_NAME="${BASE_DIR}"
    python3  main_extention.py --cuda --expt_name gnc_act_after --log_dir 'logs/' --log_every 3125 \
                  --seed $SEED --data_path data/ --dataset cifar100 \
                  --loader class_incremental_loader --class_order 'random' --increment 5 \
                  --model gnc_er --arch 'pc_cnn_extention[sparse]' \
                  --update_type 'with-primary-loss' \
                  --n_epochs 1 --glances 1 \
                  --memories 200 --batch_size 10 \
                  --replay_batch_size 4 --cifar_batches 5 \
                  --sampling_type peace_by_peace_batch --selective_mem_push 'none' \
                  --sub_bin_size 10 --num_of_bins 32 \
                  --normilize_sub_bins "normilize_sub_bins[ON]" \
                  --gnc_lr .3 \
                  --clip_grad_norm "clip_grad_norm[yes]" \
                  --grad_clip_norm 2.0 \
                  --calc_test_accuracy --validation 0.1 \
                  --is_ER_active 'yes'
                  --save_dir $SAVE_DIR_NAME                  
done     
