#!/bin/bash

###################################################
#Influence of the order nonlinear activation and GNC
###################################################


##################################
#A.2 soft sT activation followed by GNC
for SEED in 0 1 2
do
    BASE_DIR="../neurips_2022_results/influence/gnc_followed_by_st-act/"
    SAVE_DIR_NAME="${BASE_DIR}"
    python3  main_extention.py --cuda --expt_name gnc_with_soft_st --log_dir 'logs/' --log_every 3125 \
                  --seed $SEED --data_path data/ --dataset cifar100 \
                  --loader class_incremental_loader --class_order 'random' --increment 5 \
                  --model two_step_la_er_ablation_clip_grad_corr_v0 --arch 'pc_cnn_extention_nlt[soft]' \
                  --update_type 'with-primary-loss' \
                  --n_epochs 1 --glances 1 \
                  --memories 200 --batch_size 10 \
                  --replay_batch_size 4 --cifar_batches 5 \
                  --sampling_type peace_by_peace_batch --selective_mem_push 'none' \
                  --sub_bin_size 10 --num_of_bins 32 \
                  --normilize_sub_bins "normilize_sub_bins[ON]" \
                  --gnc_lr .3 \
                  --clip_grad_norm "clip_grad_norm[yes]" \
                  --grad_clip_norm 2.0 \
                  --calc_test_accuracy --validation 0.1 \
                  --is_ER_active 'yes' \
                  --save_dir $SAVE_DIR_NAME                  
done     


#A.2 soft sT activation without GNC
for SEED in 0 1 2
do
    BASE_DIR="../neurips_2022_results/influence/gnc_followed_by_st-act/"
    SAVE_DIR_NAME="${BASE_DIR}"
    python3  main_extention.py --cuda --expt_name gnc_with_soft_st --log_dir 'logs/' --log_every 3125 \
                  --seed $SEED --data_path data/ --dataset cifar100 \
                  --loader class_incremental_loader --class_order 'random' --increment 5 \
                  --model gnc_er --arch 'pc_cnn_extention_nlt[soft]' \
                  --update_type 'with-primary-loss' \
                  --n_epochs 1 --glances 1 \
                  --memories 200 --batch_size 10 \
                  --replay_batch_size 4 --cifar_batches 5 \
                  --sampling_type peace_by_peace_batch --selective_mem_push 'none' \
                  --sub_bin_size 10 --num_of_bins 32 \
                  --normilize_sub_bins "normilize_sub_bins[OFF]" \
                  --gnc_lr .3 \
                  --clip_grad_norm "clip_grad_norm[yes]" \
                  --grad_clip_norm 2.0 \
                  --calc_test_accuracy --validation 0.1 \
                  --is_ER_active 'yes' \
                  --save_dir $SAVE_DIR_NAME                  
done  
#--learn_lr --opt_lr .3 --alpha_init .3 --opt_wt 0.3 \