#!/bin/bash

CIFAR100='--data_path data/ --log_every 100 --dataset cifar100 --cuda --log_dir logs/'

##################################################################
#3. The comparason of the parametric block-wise normalizations
for SEED in 0 1 2
do
  for BATCH_NORM_TYPE in 'BN' 'GN' 'LN' 'CN' 'IN'
  do
      BASE_DIR="../neurips_2022_results/comparason/parameteric_normalization"
      SAVE_DIR_NAME="${BASE_DIR}/${BATCH_NORM_TYPE}/"  

      python3  main_extention.py --cuda --expt_name BN_act_after --log_dir 'logs/' --log_every 3125 \
                  --seed $SEED --data_path data/ --dataset cifar100 \
                  --loader class_incremental_loader --class_order 'random' --increment 5 \
                  --model gnc_er --arch 'pc_cnn_extention[linear-simple-n]' \
                  --parametric_normalization $BATCH_NORM_TYPE \
                  --update_type 'with-primary-loss' \
                  --n_epochs 1 --glances 1 \
                  --memories 200 --batch_size 10 \
                  --replay_batch_size 4 --cifar_batches 5 \
                  --sampling_type peace_by_peace_batch --selective_mem_push 'none' \
                  --sub_bin_size 10 --num_of_bins 32 \
                  --normilize_sub_bins "normilize_sub_bins[OFF]" \
                  --gnc_lr .3 \
                  --clip_grad_norm "clip_grad_norm[yes]" \
                  --grad_clip_norm 2.0 \
                  --calc_test_accuracy --validation 0.1 \
                  --is_ER_active 'yes' \
                  --save_dir $SAVE_DIR_NAME
  done
done       
