#!/bin/bash

CIFAR100='--data_path data/ --log_every 100 --dataset cifar100 --cuda --log_dir logs/'

##################################################################
#2.Ablation for the influence of the group-wise normalization type
for NORMALIZATION_TYPE in 'l-norm-2' 'l-norm-1' 'l-norm-inf'
do
  for NORMALIZE_BINS in 'normilize_sub_bins[OFF]' 'normilize_sub_bins[ON]'
  do
    for SEED in 0 1 2
    do
      BASE_DIR="../neurips_2022_results/comparason/parameter-free_normalization/"
      SAVE_DIR_NAME="${BASE_DIR}${NORMALIZATION_TYPE}_${NORMALIZE_BINS}/"

      python3 main_extention.py $CIFAR100 --seed $SEED   \
        --model gnc_er --expt_name neurips_2022[influence_group-wise_normalization]  \
        --loader class_incremental_loader --class_order random --increment 5 --cifar_batches 5     \
        --memories 200 --batch_size 10 --replay_batch_size 10      \
        --sampling_type 'peace_by_peace_batch' --selective_mem_push 'none'     \
        --arch 'pc_cnn_extention[sparse]'       \
        --normilize_sub_bins $NORMALIZE_BINS    \
        --sub_bin_size 10 --num_of_bins 32     \
        --update_type 'with-primary-loss'      \
        --clip_grad_norm 'clip_grad_norm[yes]' --grad_clip_norm 2.0     \
        --lambda_strength 1     \
        --n_epochs 1 --glances 1     \
        --gnc_lr .3 \
        --log_every 3125 --calc_test_accuracy --validation 0.1     \
        --const_normalization 'no'     \
        --is_ER_active 'yes'  \
        --nonlinearity_at_penultimate 'sT[hard]' \
        --save_dir $SAVE_DIR_NAME
    done
  done
done
