#!/bin/bash

CIFAR_100='--data_path data/ --log_every 100 --dataset cifar100 --cuda --log_dir logs/'

######################################
# 1.Results for the cifar100 data set
#prediction_head='prediction_head[multi]'
#### A. Single-pass
for GLANCES in 1 2 3
do
  for  REPLAY_BATCH_SIZE in 2 5 10
  do
    for SEED in 0 1 2
    do
      BASE_DIR="../neurips_2022_results/cifar100/single_pass/"
      SAVE_DIR_NAME="${BASE_DIR}glances[${GLANCES}]_rep_batch[${REPLAY_BATCH_SIZE}]/"
      echo ""
      echo "SINGLE-PASS RESULTS (glances=${GLANCES} and rep_batch=${REPLAY_BATCH_SIZE})"
      echo ""
      python3 main_extention.py $CIFAR_100 --seed $SEED   \
        --model gnc_er --expt_name neurips_2022  \
        --loader class_incremental_loader --class_order random \
        --increment 5 --cifar_batches 5     \
        --memories 200 --batch_size 10 --replay_batch_size $REPLAY_BATCH_SIZE      \
        --sampling_type 'peace_by_peace_batch' --selective_mem_push 'none'     \
        --arch 'pc_cnn_extention[sparse]'       \
        --normilize_sub_bins 'normilize_sub_bins[ON]'    \
        --sub_bin_size 10 --num_of_bins 32     \
        --update_type 'with-primary-loss'      \
        --clip_grad_norm 'clip_grad_norm[yes]' --grad_clip_norm 2.0     \
        --lambda_strength 1     \
        --n_epochs 1 --glances $GLANCES     \
        --gnc_lr .3 \
        --log_every 3125 --calc_test_accuracy --validation 0.1     \
        --const_normalization 'no'     \
        --nonlinearity_at_penultimate 'sT[hard]' \
        --normalization_type 'l-norm-2' \
        --is_ER_active 'yes'  \
        --save_dir $SAVE_DIR_NAME
    done
  done
done

# 1.Results for the cifar100 data set
#### B. Multi-pass
for REPLAY_BATCH_SIZE in 2 5 10
do
  for SEED in 0 1 2
  do
    BASE_DIR="../neurips_2022_results/cifar100/multi_pass/"
    SAVE_DIR_NAME="${BASE_DIR}rep_batch[${REPLAY_BATCH_SIZE}]/"
    echo ""
    echo "MULTI-PASS RESULTS (rep_batch=${REPLAY_BATCH_SIZE})"
    echo ""

    python3 main_extention.py $CIFAR_100 --seed $SEED   \
      --model gnc_er --expt_name neurips_2022  \
      --loader class_incremental_loader --class_order random \
      --increment 5 --cifar_batches 5     \
      --memories 200 --batch_size 10 --replay_batch_size $REPLAY_BATCH_SIZE      \
      --sampling_type 'peace_by_peace_batch' --selective_mem_push 'none'     \
      --arch 'pc_cnn_extention[sparse]'       \
      --normilize_sub_bins 'normilize_sub_bins[ON]'    \
      --sub_bin_size 10 --num_of_bins 32     \
      --update_type 'with-primary-loss'      \
      --clip_grad_norm 'clip_grad_norm[yes]' --grad_clip_norm 2.0     \
      --lambda_strength 1     \
      --n_epochs 10 --glances 1     \
      --learn_lr --opt_lr .3 --opt_lr_e .3 --alpha_init .3     \
      --log_every 3125 --calc_test_accuracy --validation 0.1     \
      --const_normalization 'no'     \
      --nonlinearity_at_penultimate 'sT[hard]' \
      --normalization_type 'l-norm-2' \
      --is_ER_active 'yes'  \
      --save_dir $SAVE_DIR_NAME
  done
done

