#!/bin/bash
PERM="--n_layers 2 --n_hiddens 100 --data_path data/ --log_every 100 --samples_per_task 1000 --dataset mnist_permutations --cuda --log_dir logs/"

# Declare an array of string with type
declare -a DATA_SET_PARAM=($PERM)
declare -a DATA_SET_NAMES_ALL=('mnist_permutations')
######################################
# Results for the mnist permutations data set
#prediction_head='prediction_head[single]'

index_data_set=0
for DATA_SET in ${DATA_SET_PARAM[@]}
do
  DATA_SET_NAME=DATA_SET_NAMES_ALL[index_data_set]
  index_data_set=$index_data_set + 1
    for SEED in 0 1 2
    do

      SAVE_DIR_NAME="../neurips_2022_results/mnist/${DATA_SET_NAME}/prop/"
      echo ""
      echo "PROPOSED"
      echo "${DATA_SET_NAME} RESULTS"
      echo ""
      python3   main_extention.py $DATA_SET --seed $SEED                 \
                --model gnc_er         \
                --arch 'ff[sparse-at-pu]'                       \
                --memories 1000 --batch_size 10 --replay_batch_size 10          \
                --sampling_type 'peace_by_peace_batch' --selective_mem_push 'none'               \
                --normilize_sub_bins 'normilize_sub_bins[ON]'                    \
                --sub_bin_size 10 --num_of_bins 10                     \
                --update_type 'with-primary-loss'                      \
                --clip_grad_norm 'clip_grad_norm[yes]' --grad_clip_norm 6.0                     \
                --lambda_strength 1                     \
                --n_epochs 1 --glances 4          \
                --gnc_lr 1 \
                --const_normalization 'no'                     \
                --nonlinearity_at_penultimate 'sT[hard]'                 \
                --normalization_type 'l-norm-2'                 \
                --is_ER_active 'yes'                  \
                --use_old_task_memor         \
                --save_dir $SAVE_DIR_NAME

      SAVE_DIR_NAME="../neurips_2022_results/mnist/${DATA_SET_NAME}/LWTA/"
      echo ""
      echo "LWTA"
      echo "${DATA_SET_NAME} RESULTS"
      echo ""
      python3   main_extention.py $DATA_SET --seed $SEED                 \
                --model gnc_er         \
                --arch 'ff[sparse-at-pu]'                       \
                --memories 1000 --batch_size 10 --replay_batch_size 10          \
                --sampling_type 'peace_by_peace_batch' --selective_mem_push 'none'               \
                --normilize_sub_bins 'normilize_sub_bins[OFF]'                    \
                --sub_bin_size 10 --num_of_bins 10                     \
                --update_type 'with-primary-loss'                      \
                --clip_grad_norm 'clip_grad_norm[yes]' --grad_clip_norm 6.0                     \
                --lambda_strength 1                     \
                --n_epochs 1 --glances 4          \
                --gnc_lr 1 \
                --const_normalization 'no'                     \
                --nonlinearity_at_penultimate 'LWTA' \
                --normalization_type 'l-norm-2'                 \
                --is_ER_active 'yes'                  \
                --use_old_task_memor         \
                --save_dir $SAVE_DIR_NAME                
    done
  done
done

index_data_set=0
for DATA_SET in ${DATA_SET_PARAM[@]}
do
  DATA_SET_NAME=DATA_SET_NAMES_ALL[index_data_set]
  index_data_set=$index_data_set + 1
    for SEED in 0 1 2
    do

      SAVE_DIR_NAME="../neurips_2022_results/mnist/${DATA_SET_NAME}/ONLINE/"
      echo ""
      echo "ONLINE"
      echo "${DATA_SET_NAME} RESULTS"
      echo ""
      python3   main_extention.py $DATA_SET --seed $SEED                 \
                --model gnc_er         \
                --arch 'ff[sparse-at-pu]'                       \
                --memories 1000 --batch_size 10 --replay_batch_size 10          \
                --sampling_type 'peace_by_peace_batch' --selective_mem_push 'none'               \
                --sub_bin_size 100 --num_of_bins 1                     \
                --update_type 'with-primary-loss'                      \
                --clip_grad_norm 'clip_grad_norm[yes]' --grad_clip_norm 6.0                     \
                --lambda_strength 1                     \
                --n_epochs 1 --glances 4          \
                --learn_lr --opt_lr .3 --opt_lr_e .3 --alpha_init .3                       \
                --const_normalization 'no'                     \
                --nonlinearity_at_penultimate 'relu' \
                --normilize_sub_bins 'normilize_sub_bins[OFF]'       \
                --normalization_type 'l-norm-2'                 \
                --is_ER_active 'no'                  \
                --save_dir $SAVE_DIR_NAME

      SAVE_DIR_NAME="../neurips_2022_results/mnist/${DATA_SET_NAME}/ER/"
      echo ""
      echo "ER"
      echo "${DATA_SET_NAME} RESULTS"
      echo ""
      python3 main_extention.py $DATA_SET --seed $SEED \
              --model eralg4 --expt_name eralg4 \
              --memories 1000 --batch_size 10 --replay_batch_size 10 \
              --n_epochs 1 --glances 5 \
              --lr 0.03 \
              --log_every 3125  \
              --save_dir $SAVE_DIR_NAME

      SAVE_DIR_NAME="../neurips_2022_results/mnist/${DATA_SET_NAME}/AGEM/"
      echo ""
      echo "AGEM"
      echo "${DATA_SET_NAME} RESULTS"
      echo ""
      python3 main_extention.py $DATA_SET --seed $SEED \
          --model agem --expt_name agem \
          --n_memories 10 --batch_size 10 \
          --n_epochs 1 --glances 5 \
          --lr 0.03  \
          --memory_strength 0.5 \
          --log_every 3125  \
          --save_dir $SAVE_DIR_NAME

      SAVE_DIR_NAME="../neurips_2022_results/mnist/${DATA_SET_NAME}/MER/"
      echo ""
      echo "MER"
      echo "${DATA_SET_NAME} RESULTS"
      echo ""
      python3 main_extention.py $DATA_SET --seed $SEED \
          --model meralg1 --expt_name meralg1 \
          --memories 1000 --replay_batch_size 25 --batches_per_example 1 \
          --lr 0.1 --beta 0.1 --gamma 1.0 \
          --grad_clip_norm 10.0  \
          --log_every 3125 \
          --save_dir $SAVE_DIR_NAME

      SAVE_DIR_NAME="../neurips_2022_results/mnist/${DATA_SET_NAME}/LA-MAML/"
      echo ""
      echo "LA-MAML"
      echo "${DATA_SET_NAME} RESULTS"
      echo ""
      python3 main_extention.py $DATA_SET --seed $SEED \
              --model lamaml \
              --memories 200 --batch_size 10 --replay_batch_size 10 \
              --n_epochs 1 --glances 5 \
              --opt_lr 0.3 --alpha_init 0.15 \
              --learn_lr --use_old_task_memory \
              --save_dir $SAVE_DIR_NAME
    done
  done
done
