#!/bin/bash

CIFAR='--data_path data/ --log_every 100 --dataset cifar100 --cuda --log_dir logs/'

###########################################################################
#6.The ablation for the influence of the batch size using the memory buffer
for REPLAY_BATCH_SIZE in 2 4 6 8 10
do
  for NORMALIZE_BINS in 'normilize_sub_bins[OFF]' 'normilize_sub_bins[ON]'
  do
    for SEED in 0 1 2
    do
      BASE_DIR="../neurips_2022_results/influence/replay_batch_size/"
      SAVE_DIR_NAME="${BASE_DIR}"+"${REPLAY_BATCH_SIZE}"+"_"+"${NORMALIZE_BINS}"+"/"

      python3 main_extention.py $CIFAR --seed $SEED   \
        --model gnc_er --expt_name neurips_2022[influence_replay_batch_size]  \
        --loader class_incremental_loader --class_order random --increment 5 --cifar_batches 5     \
        --memories 200 --batch_size 10 \
        --replay_batch_size $REPLAY_BATCH_SIZE \
        --sampling_type 'peace_by_peace_batch' --selective_mem_push 'none'     \
        --arch 'pc_cnn_extention[sparse]'       \
        --normilize_sub_bins $NORMALIZE_BINS    \
        --sub_bin_size 10 --num_of_bins 32     \
        --update_type 'with-primary-loss'      \
        --clip_grad_norm 'clip_grad_norm[yes]' --grad_clip_norm 2.0     \
        --lambda_strength 1     \
        --n_epochs 1 --glances 1  \
        --gnc_lr .3 \
        --log_every 3125 --calc_test_accuracy --validation 0.1     \
        --const_normalization 'no'     \
        --nonlinearity_at_penultimate 'sT[hard]' \
        --normalization_type 'l-norm-2' \
        --is_ER_active 'yes' \
        --save_dir $SAVE_DIR_NAME
    done
  done
done