# Group-wise Neuron Competition (GNC)


This repository contains the pythorch code implementation for our approach presented in the manuscript **Continual Learning with Group-wise Neuron Competition** that we submited at [Neurips 2022](https://nips.cc/). While this respository is not in the final version (nor complete), we have put together running code, which contains the backbone of code for our experiments. In the future, we plan finalize the build of this respository and to open source it in hope that will be useful for the scientific/reserach coumunity and the general public.


|This readme file is organized into 3 sections, i.e.,|
|-|
|Dependencies (how to setup your enviorment)|
|Datasets (how to get the used data sets)|
|GNC Experiements Run (how to run the experiments)|



## Dependencies

Please install the [Anaconda/Miniconda](https://docs.conda.io/projects/conda/en/latest/user-guide/install/index.html) package manager _(or even better: use it in combination with [mamba](https://github.com/mamba-org/mamba) for fast evouriment creation and update)_. 
Afterwards, create the project environment using the following:

```
conda env create -f environment.yml
```

_If you are using `mamba` then replace `conda` with `mamba`:_

```
mamba env create -f environment.yml
```

To activate your environment use:

```
conda activate gnc
```



## Datasets

The data sets [CIFAR100]() and [CIFAR10]() are automatically downloaded when we run a script for the CIFAR experiments. To download the  [MINST Rotations](), and  [MINST Permutations]() datasets run the following:
```
python get_data.py rotations permutations
```

To download the TinyImageNet, first give execution permissions using ```chmod +x download_tinyimgnet.sh```. Then, run the following command:
```
./download_tinyimgnet.sh
```

## GNC Experiements Run

### Jupyter Notebook Example Run

The environment also includes the requred patchages for using a [jupyter notebook](https://realpython.com/jupyter-notebook-introduction/). To use it run:

```
jupyter notebook
```

To run one example in the jupyter notebook, start the kernel
```
gnc-based_continual_learning.ipynb
```
there we give one example of continual learning using group-wise neuron competition.


### Script-based Run

To run differnt experiments and variants of our approach with GNC, please see the files given in the ```./experiments``` folder. To enable running an experiment file, please give the requred premitions, i.e., 

```
chmod +x ./experiments/gnc_ablation[main_components].sh
```

then run the file using the following command:

```
./experiments/gnc_ablation[main_components].sh
```

| Experiment | Description |
|--|--|
./experiments/gnc_ablation[main_components].sh | Script for running the ablations of the main components in our approach. |
./experiments/gnc_impact[nonlinearity_at_penultimate_layer].sh <br> ./experiments/gnc_impact[group_size_at_penultimate_layer].sh | Scripts for running the experiments about the impact that the nonlinear activation and the group size has on preformance. |
./experiments/gnc_influence[reservoir_batch_size].sh <br> ./experiments/gnc_influence[group-wise_spliting_type].sh <br> ./experiments/gnc_influence[normalization_and_nonlinearity_per_single-multple_layers].sh | Scripts for running the experiments about the influence that the reservoir batch size, the grouping type and the group-wise normalization have on preformance. |
./experiments/gnc_comparison[parameter-free_normalization_type].sh <br> ./experiments/gnc_comparision[parameter-based_normalization_type].sh  | Scripts for running the experiments regarding the comparative results with normalization tehniques, including parameter-free and parameter-based normalization. | 
./experiments/gnc_comparison_cifar10.sh <br> ./experiments/gnc_comparison_cifar100.sh <br> ./experiments/gnc_comparison_tiny_imagenet.sh <br> ./experiments/gnc_comparison_mnist[rotations].sh <br> ./experiments/gnc_comparison_mnist[permutations].sh | Scripts for running the experiments regarding the comparative results with existing continual learning algorithms on [MNIST](https://papers.nips.cc/paper/2017/hash/f87522788a2be2d171666752f97ddebb-Abstract.html), [CIFAR10](https://www.cs.toronto.edu/~kriz/cifar.html), [CIFAR100](https://www.cs.toronto.edu/~kriz/cifar.html) and [TINYIMAGENET](http://vision.stanford.edu/teaching/cs231n/reports/2015/pdfs/yle_project.pdf). |
./experiments/extra/* | Scripts for running the experiments using some of the comparing methods on [MNIST](https://papers.nips.cc/paper/2017/hash/f87522788a2be2d171666752f97ddebb-Abstract.html), [CIFAR10](https://www.cs.toronto.edu/~kriz/cifar.html), [CIFAR100](https://www.cs.toronto.edu/~kriz/cifar.html) and [TINYIMAGENET](http://vision.stanford.edu/teaching/cs231n/reports/2015/pdfs/yle_project.pdf). |

To run one algorithm configuraton, please see the files in the ```./experiments``` folder, the arguments and hyperparams required. The code above contains our apprach, and the comparing baselines based on (i) local winer takes all [LWTA](https://papers.nips.cc/paper/2013/hash/8f1d43620bc6bb580df6e80b0dc05c48-Abstract.html), (ii) parameter-free normalization  [L_1-norm]() and [L_inf-norm](), (iii) parametric normalizations [BN](https://arxiv.org/abs/1502.03167), [LN](https://arxiv.org/abs/1607.06450), [GN](https://arxiv.org/abs/1803.08494) and [CN](https://openreview.net/forum?id=vwLLQ-HwqhZ), (iv) as well as the following  algorithms [ER](https://www.routledge.com/Learning-and-Categorization-in-Modular-Neural-Networks/Murre/p/book/9780805813388), [iCARL](https://arxiv.org/abs/1611.07725), [MER](https://arxiv.org/abs/1810.11910), [GEM](https://papers.nips.cc/paper/2017/hash/f87522788a2be2d171666752f97ddebb-Abstract.html), [AGEM](https://arxiv.org/abs/1812.00420), [La-MAML](https://github.com/montrealrobotics/La-MAML), [META-BGD](https://arxiv.org/abs/1803.10123). 

The code was tested to run on NVIDIA DGX2 server with 16 GPU's (we used 2-3), with  Ubuntu 18.04.6 LTS (Bionic Beaver) and a workstation with one GPU with Kubuntu 20.04 (Fat-client).

#### @ Copyright Notice. In building this repository, we used the La-MAML [respository](https://github.com/montrealrobotics/La-MAML) that accompanies the La-MAML [paper](https://arxiv.org/abs/2007.13904).