#!/bin/bash
CIFAR100_PARAMS='--data_path data/ --log_every 3125 --dataset cifar100 --cuda --log_dir logs/'
LOADER_PARAMS='--loader class_incremental_loader --class_order random --increment 5 --cifar_batches 5'
VALIDATION_PARAMS='--calc_test_accuracy --validation 0.1'
######################################
#1.The ablation of the main components
for IS_ER_ACTIVE in 'no' 'yes'
do
  for NORMALIZE_GROUPS in 'OFF' 'ON'
  do
    for SEED in 0 1 2
    do
      BASE_DIR="../neurips_2022_results/ablation/main/"
      SAVE_DIR_NAME="${BASE_DIR}ER_ACTIVE[${IS_ER_ACTIVE}]_NORMALIZE_GROUPS[${NORMALIZE_GROUPS}]/"

      python3 main_extention.py --expt_name neurips_2022[ablations_main_comp] \
        $CIFAR100_PARAMS $LOADER_PARAMS $VALIDATION_PARAMS \
        --seed $SEED \
        --model gnc_er  --arch 'pc_cnn_extention[sparse]' \
        --update_type 'with-primary-loss' \
        --n_epochs 1 --glances 1     \
        --memories 200 --batch_size 10 \
        --is_ER_active $IS_ER_ACTIVE  --replay_batch_size 10  \
        --sampling_type 'peace_by_peace_batch' --selective_mem_push 'none'     \
        --gnc_lr .3 \
        --clip_grad_norm 'clip_grad_norm[yes]' --grad_clip_norm 2.0     \
        --const_normalization 'no' \
        --normilize_sub_bins "normilize_sub_bins[${NORMALIZE_GROUPS}]"  \
        --normalization_type 'l-norm-2'\
        --sub_bin_size 10 --num_of_bins 32 \
        --save_dir $SAVE_DIR_NAME
    done
  done
done
