#!/bin/bash
CIFAR_10='--data_path data/ --log_every 100 --dataset cifar10 --cuda --log_dir logs/'

######################################
# 1.Results for the cifar100 data set
#### A. Single-pass
GLANCES=1
for  REPLAY_BATCH_SIZE in 2 5 10
do
  for SEED in 0 1 2
  do
  BASE_DIR="../neurips_2022_results/cifar10/single_pass/GNC/"
  SAVE_DIR_NAME="${BASE_DIR}glances[${GLANCES}]_rep_mem_batch[${REPLAY_BATCH_SIZE}]/"


  python3 main_extention.py $CIFAR_10 --seed $SEED   \
      --model gnc_er --expt_name neurips_2022[cifar10_single_pass]  \
      --loader class_incremental_loader --class_order random \
      --increment 5 --cifar_batches 5     \
      --memories 200 --batch_size 10 \
      --replay_batch_size $REPLAY_BATCH_SIZE      \
      --sampling_type 'peace_by_peace_batch' \
      --selective_mem_push 'none'     \
      --arch 'pc_cnn_extention[sparse]'       \
      --normilize_sub_bins 'normilize_sub_bins[ON]'    \
      --sub_bin_size 10 --num_of_bins 32     \
      --update_type 'with-primary-loss'      \
      --clip_grad_norm 'clip_grad_norm[yes]' --grad_clip_norm 2.0     \
      --lambda_strength 1     \
      --n_epochs 1 --glances 1    \
      --gnc_lr .3 \
      --log_every 3125 --calc_test_accuracy --validation 0.1     \
      --const_normalization 'no'     \
      --nonlinearity_at_penultimate 'sT[hard]' \
      --normalization_type 'l-norm-2' \
      --is_ER_active 'yes'  \
      --save_dir $SAVE_DIR_NAME

  #LWTA
  BASE_DIR="../neurips_2022_results/cifar10/single_pass/LWTA/"
  SAVE_DIR_NAME="${BASE_DIR}glances[${GLANCES}]_rep_mem_batch[${REPLAY_BATCH_SIZE}]/"
  echo ""
  echo "SINGLE-PASS RESULTS (glances=1 and rep_mem_batch=${REPLAY_BATCH_SIZE})"
  echo ""
  python3 main_extention.py $CIFAR_10 --seed $SEED   \
      --model gnc_er --expt_name neurips_2022[cifar10_single_pass_lwta]  \
      --loader class_incremental_loader --class_order random \
      --increment 5 --cifar_batches 5     \
      --memories 200 --batch_size 10 \
      --replay_batch_size $REPLAY_BATCH_SIZE      \
      --sampling_type 'peace_by_peace_batch' \
      --selective_mem_push 'none'     \
      --arch 'pc_cnn_extention[sparse]'       \
      --normilize_sub_bins 'normilize_sub_bins[OFF]'    \
      --sub_bin_size 10 --num_of_bins 32     \
      --update_type 'with-primary-loss'      \
      --clip_grad_norm 'clip_grad_norm[yes]' --grad_clip_norm 2.0     \
      --lambda_strength 1     \
      --n_epochs 1 --glances 1     \
      --learn_lr --opt_lr .3 --opt_lr_e .3 --alpha_init .3     \
      --log_every 3125 --calc_test_accuracy --validation 0.1     \
      --nonlinearity_at_penultimate 'LWTA' \
      --const_normalization 'no'     \
      --normalization_type 'l-norm-2' \
      --is_ER_active 'yes'  \
      --save_dir $SAVE_DIR_NAME
  done
done

for SEED in 0 1 2
  do
  #LA-MAML
  BASE_DIR="../neurips_2022_results/cifar10/single_pass/La-MAML/"
  SAVE_DIR_NAME="${BASE_DIR}glances[${GLANCES}]_rep_mem_batch[${REPLAY_BATCH_SIZE}]/"
  python3 main_extention.py $CIFAR_10 --seed $SEED \
      --model lamaml_cifar --expt_name neurips_2022 \
      --arch "pc_cnn" \
      --loader class_incremental_loader --class_order random \
      --increment 5 --cifar_batches 5 \
      --memories 200 --batch_size 10 --replay_batch_size 10 \
      --n_epochs 1 --glances 10 \
      --opt_lr 0.25 --alpha_init 0.1 --opt_wt 0.1  \
      --learn_lr  --second_order \
      --grad_clip_norm 1.0 \
      --log_every 3125 \
      --calc_test_accuracy --validation 0.1 \
      --save_dir $SAVE_DIR_NAME

  #BASE_DIR="neurips_2022_results/cifar10/single_pass/iCarl/"
  #SAVE_DIR_NAME="${BASE_DIR}glances[${GLANCES}]_rep_mem_batch[${REPLAY_BATCH_SIZE}]/"
  #python3 main_extention.py $CIFAR_10  --seed $SEED \
  #    --model icarl --expt_name icarl \
  #    --arch "pc_cnn" \
  #    --loader class_incremental_loader --class_order random --increment 2 \
  #    --n_memories 200 --batch_size 10 \
  #    --memory_strength 1.0 \
  #    --n_epochs 1 --glances 2 \
  #    --lr 0.03 \
  #    --grad_clip_norm 5.0 \
  #    --log_every 3125  --samples_per_task 2500 \
  #    --calc_test_accuracy --validation 0.1 \
  #    --save_dir $SAVE_DIR_NAME

  BASE_DIR="../neurips_2022_results/cifar10/single_pass/ER/"
  SAVE_DIR_NAME="${BASE_DIR}glances[${GLANCES}]_rep_mem_batch[${REPLAY_BATCH_SIZE}]/"
  python3 main_extention.py $CIFAR_10 --seed $SEED \
      --model eralg4 --expt_name eralg4 \
      --arch "pc_cnn" \
      --class_order random --loader class_incremental_loader  --increment 5 \
      --memories 200 --batch_size 10 --replay_batch_size 1 \
      --n_epochs 1 --glances 10 \
      --lr 0.03 \
      --log_every 3125  \
      --calc_test_accuracy --validation 0.1
      --save_dir $SAVE_DIR_NAME

  BASE_DIR="../neurips_2022_results/cifar10/single_pass/AGEM/"
  SAVE_DIR_NAME="${BASE_DIR}glances[${GLANCES}]_rep_mem_batch[${REPLAY_BATCH_SIZE}]/"
  python3 main_extention.py $CIFAR_10 --seed $SEED \
      --model agem --expt_name agem \
      --arch "pc_cnn" \
      --loader class_incremental_loader --class_order random --increment 5 \
      --n_memories 10 --batch_size 10 \
      --n_epochs 1 --glances 2 \
      --lr 0.03  \
      --memory_strength 0.5 \
      --log_every 3125  \
      --calc_test_accuracy --validation 0.1 \
      --save_dir $SAVE_DIR_NAME

  ##### MER #####
  BASE_DIR="../neurips_2022_results/cifar10/single_pass/MER/"
  SAVE_DIR_NAME="${BASE_DIR}glances[${GLANCES}]_rep_mem_batch[${REPLAY_BATCH_SIZE}]/"
  python3 main_extention.py $CIFAR_10 --seed $SEED \
      --model meralg1 --expt_name meralg1 \
      --arch 'pc_cnn' \
      --loader class_incremental_loader --class_order random --increment 5 \
      --memories 200 --replay_batch_size 25 --batches_per_example 10 \
      --lr 0.1 --beta 0.1 --gamma 1.0 \
      --grad_clip_norm 10.0  \
      --log_every 3125 \
      --calc_test_accuracy --validation 0.1 \
      --save_dir $SAVE_DIR_NAME
done
