# Hybrid Risk-Mitigating Architectural Search (HRMAS)

This repository is the official implementation of "Composing Recurrent Spiking Neural Networks using Locally-Recurrent Motifs and Risk-Mitigating Architectural Optimization". 

## Requirements
### Dependencies and Libraries
* python 3.7
* pytorch
* torchvision

### Installation
To install requirements:

```setup
pip install -r requirements.txt
```

### Datasets
TI46-Alpha: [dataset](https://catalog.ldc.upenn.edu/LDC93S9), [preprocessing](https://github.com/stonezwr/HRMAS/tree/master/preprocessing/TI46)

N-TIDIGITS: [dataset](http://sensors.ini.uzh.ch/databases.html), [preprocessing](https://github.com/stonezwr/HRMAS/tree/master/preprocessing/N-TIDIGITS)

DVS-Gesture: [dataset](https://www.research.ibm.com/dvsgesture/), [preprocessing](https://github.com/stonezwr/TSSL-BP/tree/master/preprocessing/DvsGesture)

NMNIST: [dataset](https://www.garrickorchard.com/datasets/n-mnist), [preprocessing](https://github.com/stonezwr/TSSL-BP/tree/master/preprocessing/NMNIST)

## Training
### Before running
Modify the data path and network settings in the [config files](https://github.com/stonezwr/HRMAS/tree/master/Configs). 

### Run the code
```sh
$ python main.py -config Configs/config_file.yaml
```
Check main.py for more options.
