from datasets import loadTIAlpha, loadNTidigits, loadDVSGesture, loadNMNIST
import os


def loader(network_config):
    data_path = os.path.expanduser(network_config['data_path'])
    if network_config['dataset'] == "TIALPHA":
        train_set, arch_train_set, arch_val_set, test_set = loadTIAlpha.get_tialpha(data_path, network_config)
    elif network_config['dataset'] == "NTIDIGITS":
        train_set, arch_train_set, arch_val_set, test_set = loadNTidigits.get_n_tidigits(data_path, network_config)
    elif network_config['dataset'] == "DVS_Gesture":
        train_set, arch_train_set, arch_val_set, test_set = loadDVSGesture.get_dvs_gesture(data_path, network_config)
    elif network_config['dataset'] == "NMNIST":
        train_set, arch_train_set, arch_val_set, test_set = loadNMNIST.get_nmnist(data_path, network_config)
    else:
        raise Exception('Unrecognized dataset name.')
    return train_set, arch_train_set, arch_val_set, test_set
