import h5py
import numpy as np
import shutil
import os

def getlabel(c):
    l = 0
    if '1' <= c <= '9':
        l=int(c)
    elif c == 'z':
        l=0
    elif c == 'o':
        l=10
    else:
        assert()
    return l

filename = 'n-tidigits.hdf5'
f = h5py.File(filename, 'r')


path = 'n_tidigits/Train/'
if os.path.exists(path):
    shutil.rmtree(path)           #removes all the subdirectories!
for i in range(11):
    dir_path = path + str(i)
    os.makedirs(dir_path)
path = 'n_tidigits/Test/'
if os.path.exists(path):
    shutil.rmtree(path)           #removes all the subdirectories!
for i in range(11):
    dir_path = path + str(i)
    os.makedirs(dir_path)

train_address = f['train_addresses']
train_label = list(f['train_labels'])
train_timestamps = f['train_timestamps']
train_size = len(train_label)

test_address = f['test_addresses']
test_label = list(f['test_labels'])
test_timestamps = f['test_timestamps']
test_size = len(test_label)

time_window = 0.008

# load training sample
for i in range(train_size):
    sample = train_label[i]
    if chr(sample[-3]) != '-':
        continue
    sp_times = []
    for k in range(64):
        tmp = []
        sp_times.append(tmp)
    label = getlabel(chr(sample[-2]))
    addresses = list(train_address[sample])
    timestamps = list(train_timestamps[sample])
    record = -1
    for j in range(len(timestamps)):
        index = addresses[j]
        time = timestamps[j]
        tmp = int(time/time_window)
        if record != tmp:
            record = tmp
            sp_times[index].append(record)
    with open('n_tidigits/Train/'+str(label)+'/'+sample.decode("utf-8") +'.dat', 'w') as file:
        for item_0 in sp_times:
            for item_1 in item_0:
                file.write("%d\t" % item_1)
            file.write("\n")

# load testing sample
for i in range(test_size):
    sample = test_label[i]
    if chr(sample[-2]) != '-':
        continue
    sp_times = []
    for k in range(64):
        tmp = []
        sp_times.append(tmp)
    label = getlabel(chr(sample[-1]))
    addresses = list(test_address[sample])
    timestamps = list(test_timestamps[sample])
    record = -1
    for j in range(len(timestamps)):
        index = addresses[j]
        time = timestamps[j]
        tmp = int(time/time_window)
        if record != tmp:
            record = tmp
            sp_times[index].append(record)
    with open('n_tidigits/Test/'+str(label)+'/'+sample.decode("utf-8") +'.dat', 'w') as file:
        for item_1 in sp_times:
            for item_2 in item_1:
                file.write("%d\t" % item_2)
            file.write("\n")
