# Copyright 2024 NVIDIA CORPORATION & AFFILIATES
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
# This file is modified from https://github.com/haotian-liu/LLaVA/


from unittest import mock

from llava.train.slurm_utils import set_timer
from llava.train.train import train
from llava.train.transformer_normalize_monkey_patch import (
    _save_checkpoint,
    compute_loss,
    patched_normalize,
    training_step,
)


def __len__(self):
    return len(self.batch_sampler)


def __iter__(self):
    return self.batch_sampler.__iter__()


if __name__ == "__main__":
    with (
        mock.patch("transformers.image_processing_utils.normalize", new=patched_normalize),
        mock.patch("accelerate.data_loader.BatchSamplerShard.__len__", new=__len__),
        mock.patch("accelerate.data_loader.BatchSamplerShard.__iter__", new=__iter__),
        mock.patch("transformers.trainer.Trainer._save_checkpoint", new=_save_checkpoint),
        mock.patch("transformers.trainer.Trainer.compute_loss", new=compute_loss),
        mock.patch("transformers.trainer.Trainer.training_step", new=training_step),
    ):
        set_timer()
        train()


