/*
 * post processing, e.g., calculating solution quality
 */
#pragma once
#include "dist_table.hpp"
#include "lacam_instance.hpp"
#include "utils.hpp"

bool is_feasible_solution(const LACAMInstance& ins, const Solution& solution,
                          const int verbose = 0);
int get_makespan(const Solution& solution);
int get_path_cost(const Solution& solution, uint i);  // single-agent path cost
int get_sum_of_costs(const Solution& solution);
int get_sum_of_loss(const Solution& solution);
int get_makespan_lower_bound(const LACAMInstance& ins, DistTable& D);
int get_sum_of_costs_lower_bound(const LACAMInstance& ins, DistTable& D);
void print_stats(const int verbose, const LACAMInstance& ins,
                 const Solution& solution, const double comp_time_ms);
void make_log(const LACAMInstance& ins, const Solution& solution,
              const std::string& output_name, const double comp_time_ms,
              const std::string& map_name, const int seed,
              const std::string& additional_info,
              const bool log_short = false  // true -> paths not appear
);
