from collections import namedtuple

Genotype = namedtuple('Genotype', 'normal normal_concat reduce reduce_concat')

"""For nasbench"""
NASBENCH_PRIMITIVES = ['maxpool3x3', 'conv3x3-bn-relu', 'conv1x1-bn-relu']

"""For darts related"""
PRIMITIVES = ['max_pool_3x3', 'avg_pool_3x3', 'skip_connect',
              'sep_conv_3x3', 'sep_conv_5x5', 'dil_conv_3x3', 'dil_conv_5x5']

NASI_FIX = Genotype(
    normal=[('dil_conv_3x3', 0), ('sep_conv_3x3', 1), ('sep_conv_3x3', 1), ('dil_conv_3x3', 0),
            ('sep_conv_5x5', 1), ('dil_conv_5x5', 3), ('sep_conv_3x3', 0), ('dil_conv_5x5', 3)],
    normal_concat=[2, 3, 4, 5],
    reduce=[('max_pool_3x3', 1), ('max_pool_3x3', 0), ('sep_conv_3x3', 1), ('sep_conv_3x3', 2),
            ('sep_conv_3x3', 1), ('sep_conv_5x5', 0), ('sep_conv_3x3', 4), ('sep_conv_3x3', 1)],
    reduce_concat=[2, 3, 4, 5]
)

NASI_ADA = Genotype(
    normal=[('dil_conv_3x3', 1), ('sep_conv_5x5', 0), ('sep_conv_3x3', 1), ('dil_conv_5x5', 0),
            ('sep_conv_5x5', 1), ('avg_pool_3x3', 3), ('sep_conv_3x3', 0), ('dil_conv_3x3', 3)],
    normal_concat=[2, 3, 4, 5],
    reduce=[('max_pool_3x3', 1), ('max_pool_3x3', 0), ('sep_conv_5x5', 1), ('skip_connect', 2),
            ('sep_conv_3x3', 1), ('sep_conv_5x5', 0), ('sep_conv_3x3', 1), ('sep_conv_3x3', 4)],
    reduce_concat=[2, 3, 4, 5]
)
