# NASI: Label- and Data-agnostic Neural Architecture Search at Initialization

This repository is the official implementation of [NASI: Label- and Data-agnostic Neural Architecture Search at Initialization](). 

## Requirements

To install requirements:

```setup
pip install -r requirements.txt
```

And then please follow [NASBench](https://github.com/google-research/nasbench) to install this NAS benchmark and follow [PyTorch](https://pytorch.org) to install pytorch along with its torchvision library.


## Search

To conduct the architecture search on NAS-Bench-1Shot1, run this command:

```bash
PYTHONPATH=$PWD python search_nasbench.py --nasbench_data path/to/your/nasbench/data --search_space 1 --gumbel --adaptive # for NAS-Bench-1Shot with adaptove constraint
```

To conduct the architecture search in the DARTS search space, run this command:

```bash
PYTHONPATH=$PWD python search_darts.py --gumbel --constraint 100 # for the search with fixed constraint
PYTHONPATH=$PWD python search_darts.py --gumbel --constraint 500 --adaptive # for the search with adaptive constraint with a relatively large initialization
```

## Training
To train the model on CIFAR-10/100/ImageNet in the paper, run these commands, respectively:

```bash
# Train on CIFAR-10
python train_cifar10.py --auxiliary --cutout --arch arch_name --save log_name --data path/to/cifar10/data/ --gpu 0 --seed 0
# Train on CIFAR-100
python train_cifar100.py --auxiliary --cutout --arch arch_name --save log_name --data path/to/cifar100/data/ --gpu 0 --seed 0
# Train on ImageNet
CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7 python -m torch.distributed.launch --nproc_per_node=8 --master_port 30408 train_imagenet.py --arch arch_name --save log_name --auxiliary --data_dir path/to/imagenet/data/
```

## Results

Our NASI algorithm achieves the following search effectiveness and efficiency on NAS-Bench-1Shot1:

<div style="text-align:center"><img src="figures/efficiency_nasbench.png" alt="search-nasbench" width="820"/></div>

Meanwhile, our NASI algorithm can also achieve the top search efficiency in the DARTS search space with comparable generalization performance:

<div style="text-align:center"><img src="figures/efficiency_darts.png" alt="search-darts" width="400"/></div>


The architectures selected by our NASI algorithm achieve the following compelling generalization performance on ImageNet with its amazing search efficiency derived from its provable transferability (Note that the search cost is measured via GPU Hours on Nvidia 1080Ti):

<center>

| Model name         | Top 1 Error     | Top 5 Error    | Search Cost  |
| :----------------- |:--------------: | :------------: | :----------: |
| [DARTS](https://arxiv.org/abs/1806.09055)              |     26.7%       |      8.7%      | 24.0   |
| [ProxylessNAS](https://arxiv.org/abs/1812.00332)       |     24.9%       |      7.5%      | 200.  |             
| [TE-NAS](https://arxiv.org/abs/2102.11535)             |     26.2%       |      8.3%      | 0.48 |
| [NASI-FIX]()           |   **24.3%**     |    **7.3%**    | 0.24 |
| [NASI-ADA]()           |   **25.0%**     |    **7.8%**    | 0.24 |

</center>


<!-- ## Contributing -->