# Environment
* Linux
    * We ran the experiments on Ubuntu 20.04.6 LTS (GNU/Linux 5.15.0-125-generic x86_64).
* Python 3.11.13
* All packages are in requirements.txt

# Instruction

* Methods
    * method_names
        * EIMS
        * EI
        * EI_wang (denoted as EI-$\mu^{\rm max}$ in the paper)
        * PIMS
        * IRGPUCB
        * GPUCB
        * TS
        * MES
        * JES
        * EEEI

*  For experiments:
    * For synthetic function experiments:
      * To run 16 experiments (random_seed $\in \{0, 1, ..., 15\}$) in parallel to reproduce the paper, you can use the following command:
        * python exp_bayesopt.py method_name GP -1 --ell=0.1 --kernel_name=SE --noise_std=0.01
      * To run a experiment with a specific random seed:
        * python exp_bayesopt.py method_name GP random_seed --ell=0.1 --kernel_name=SE --noise_std=0.01
      * change ell $\in \{0.1, 0.2\}$ and noise_std $\in \{0.01, 0.1, 1.\}$ to the desired values
      * kernel_name can be SE, Matern52, or Matern32
    * For benchmark function experiments (func_name $\in$ {Ackley, Hartmann3, Hartmann4, Hartmann6, Shekel, Styblinski_tang}):
      * To run 16 experiments (random_seed $\in \{0, 1, ..., 15\}$) in parallel to reproduce the paper, you can use the following command:
        * python exp_bayesopt.py method_name func_name -1 --kernel_name=SE --noise_std=0
      * To run a experiment with a specific random seed:
        * python exp_bayesopt.py method_name func_name random_seed --kernel_name=SE --noise_std=0
    * For the plots of the experimental results:
        * python plot_results.py
