/*
 * Decompiled with CFR 0.152.
 */
package islab.bayesian;

import cern.colt.list.DoubleArrayList;
import cern.colt.list.IntArrayList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataSet {
    public static final int NO_KNOCKOUT = -1;
    private static final Pattern knockoutPattern = Pattern.compile("\\$(\\d+)");
    private String[] header = null;
    private double[][] data;
    private String filename;
    private int nObservations;
    private int[] nObservationsPerVariable;
    private int nVariables;
    private int[] foldBelongsTo;
    private Vector folds;
    private int[] allDatapoints;
    private int[] knockout;
    private double[] knockoutValue;
    public String[] experimentIds;

    public static void main(String[] args) throws IOException {
        DataSet dataSet = new DataSet(args[0]);
        System.out.println("number of observations: " + dataSet.getNObservations());
        System.out.println("number of variables: " + dataSet.getNVariables());
        System.out.println("Folds (max size 10): ");
        dataSet.prepareFolds(10);
        int nFolds = dataSet.getNFolds();
        int i = 0;
        while (i < nFolds) {
            int[] obsInFold = dataSet.getFoldN(i);
            System.out.print("fold " + i + " contains: ");
            int j = 0;
            while (j < obsInFold.length) {
                if (dataSet.getKnockout(obsInFold[j]) == -1) {
                    System.out.print(" " + obsInFold[j]);
                } else {
                    System.out.print(" " + obsInFold[j] + "(" + dataSet.getKnockoutValue(obsInFold[j]) + ")");
                }
                System.out.println();
                ++j;
            }
            ++i;
        }
    }

    public DataSet(int nVariables, int nObservations) {
        this.filename = null;
        this.nObservations = nObservations;
        this.nVariables = nVariables;
        this.nObservationsPerVariable = new int[nVariables];
        this.data = new double[nObservations][nVariables];
        this.knockout = new int[nObservations];
        Arrays.fill(this.knockout, -1);
        this.knockoutValue = new double[nObservations];
        this.experimentIds = new String[nObservations];
        int i = 0;
        while (i < nObservations) {
            this.experimentIds[i] = "exp_" + i;
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DataSet(String filename) throws IOException {
        IntArrayList knockoutAtVariableIAL = new IntArrayList();
        DoubleArrayList knockoutValueIAL = new DoubleArrayList();
        ArrayList<double[]> observations = new ArrayList<double[]>();
        this.filename = filename;
        BufferedReader in = new BufferedReader(new FileReader(filename));
        this.nVariables = -1;
        this.nObservations = 0;
        String s = in.readLine();
        while (s != null) {
            if (this.nVariables == -1) {
                StringTokenizer st = new StringTokenizer(s, "\t ");
                this.nVariables = st.countTokens();
                Matcher m = knockoutPattern.matcher(s);
                if (m.find()) {
                    this.nVariables -= 2;
                }
                System.out.println("nVariables: " + this.nVariables);
                this.nObservationsPerVariable = new int[this.nVariables];
            }
            double[] observation = new double[this.nVariables];
            StringTokenizer st = new StringTokenizer(s, "\t ");
            int j = 0;
            while (j < this.nVariables) {
                observation[j] = Double.parseDouble(st.nextToken());
                int n = j++;
                this.nObservationsPerVariable[n] = this.nObservationsPerVariable[n] + 1;
            }
            observations.add(observation);
            if (st.hasMoreTokens()) {
                Matcher m = knockoutPattern.matcher(st.nextToken());
                if (!m.matches()) throw new RuntimeException("bad knockout pattern");
                int var = Integer.parseInt(m.group(1));
                knockoutAtVariableIAL.add(var);
                int n = var;
                this.nObservationsPerVariable[n] = this.nObservationsPerVariable[n] - 1;
                if (!st.hasMoreTokens()) {
                    throw new RuntimeException("bad knockout pattern");
                }
                knockoutValueIAL.add(Double.parseDouble(st.nextToken()));
            } else {
                knockoutAtVariableIAL.add(-1);
                knockoutValueIAL.add(Double.NaN);
            }
            ++this.nObservations;
            s = in.readLine();
        }
        in.close();
        System.out.println("nObservations: " + this.nObservations);
        knockoutAtVariableIAL.trimToSize();
        knockoutValueIAL.trimToSize();
        this.knockout = knockoutAtVariableIAL.elements();
        this.knockoutValue = knockoutValueIAL.elements();
        this.data = new double[this.nObservations][];
        int i = 0;
        while (i < this.nObservations) {
            this.data[i] = (double[])observations.get(i);
            ++i;
        }
        this.allDatapoints = new int[this.nObservations];
        i = 0;
        while (i < this.nObservations) {
            this.allDatapoints[i] = i;
            ++i;
        }
        this.experimentIds = new String[this.nObservations];
        i = 0;
        while (i < this.nObservations) {
            this.experimentIds[i] = "exp_" + i;
            ++i;
        }
    }

    public int[] getAllDatapoints() {
        return this.allDatapoints;
    }

    public double[][] dataset() {
        return this.data;
    }

    public int foldBelongsToKnockout(int n) {
        if (n >= this.foldBelongsTo.length) {
            return -1;
        }
        return this.foldBelongsTo[n];
    }

    public String getFilename() {
        return this.filename;
    }

    public String getHeader(int i) {
        return this.header[i];
    }

    public void setHeader(int i, String name) {
        if (this.header == null) {
            this.header = new String[this.getNVariables()];
        }
        this.header[i] = name;
    }

    public int[] getFoldN(int n) {
        return (int[])this.folds.get(n);
    }

    public int getKnockout(int observation) {
        return this.knockout[observation];
    }

    public int[] getKnockouts() {
        return this.knockout;
    }

    public double getKnockoutValue(int i) {
        return this.knockoutValue[i];
    }

    public double[] getKnockoutValues() {
        return this.knockoutValue;
    }

    public int getNFolds() {
        return this.folds.size();
    }

    public int getNObservations() {
        return this.nObservations;
    }

    public int getNObservationsPerVariable(int variable) {
        return this.nObservationsPerVariable[variable];
    }

    public int getNVariables() {
        return this.nVariables;
    }

    public double[] getObservation(int i) {
        return this.data[i];
    }

    public boolean hasKnockout(int variable) {
        return this.nObservationsPerVariable[variable] != this.nObservations;
    }

    public void prepareFolds(int fds) {
        int maxsize = this.nObservations / fds;
        if (maxsize < 1) {
            maxsize = 1;
        }
        this.folds = new Vector();
        int[] whichKnockoutWhere = new int[this.nVariables];
        Arrays.fill(whichKnockoutWhere, -1);
        int i = 0;
        while (i < this.nVariables) {
            int nKnockouts = this.nObservations - this.nObservationsPerVariable[i];
            if (nKnockouts > 0) {
                int[] bag = new int[nKnockouts];
                Arrays.fill(bag, -1);
                whichKnockoutWhere[i] = this.folds.size();
                this.folds.add(bag);
            }
            ++i;
        }
        this.foldBelongsTo = new int[this.folds.size()];
        int[] bag = new int[maxsize];
        int bagcnt = 0;
        int i2 = 0;
        while (i2 < this.nObservations) {
            if (this.knockout[i2] == -1) {
                if (bagcnt < maxsize) {
                    bag[bagcnt++] = i2;
                } else {
                    this.folds.add(bag);
                    bag = new int[maxsize];
                    bag[0] = i2;
                    bagcnt = 1;
                }
            } else {
                this.foldBelongsTo[whichKnockoutWhere[this.knockout[i2]]] = this.knockout[i2];
                int cnt = 0;
                int[] thebag = (int[])this.folds.get(whichKnockoutWhere[this.knockout[i2]]);
                while (thebag[cnt] != -1) {
                    ++cnt;
                }
                thebag[cnt] = i2;
            }
            ++i2;
        }
        int[] lastbag = new int[bagcnt];
        int i3 = 0;
        while (i3 < bagcnt) {
            lastbag[i3] = bag[i3];
            ++i3;
        }
        this.folds.add(lastbag);
        boolean[] check = new boolean[this.nObservations];
        int i4 = 0;
        while (i4 < this.folds.size()) {
            int[] b = (int[])this.folds.get(i4);
            int j = 0;
            while (j < b.length) {
                if (check[b[j]]) {
                    throw new RuntimeException("!");
                }
                check[b[j]] = true;
                ++j;
            }
            ++i4;
        }
        i4 = 0;
        while (i4 < this.nObservations) {
            if (!check[i4]) {
                throw new RuntimeException("!");
            }
            ++i4;
        }
    }

    public void set(int obs, int index, double value) {
        this.data[obs][index] = value;
    }

    public DoubleArrayList toDoubleArrayList(int variableNr) {
        DoubleArrayList da = new DoubleArrayList();
        int i = 0;
        while (i < this.getNObservations()) {
            da.add(this.data[i][variableNr]);
            ++i;
        }
        return da;
    }

    public double value(int observation, int variable) {
        return this.data[observation][variable];
    }

    public void saveToFile(String fileName) throws IOException {
        this.saveToFile(fileName, false);
    }

    public void saveToFile(String fileName, boolean transposed) throws IOException {
        FileWriter fw = new FileWriter(fileName);
        fw.write(this.toTDLString(transposed));
        fw.close();
    }

    public void saveToFileAppend(String fileName) throws IOException {
        this.saveToFileAppend(fileName, true);
    }

    public void saveToFileAppend(String fileName, boolean skipHeader) throws IOException {
        String line;
        FileWriter fw = new FileWriter(new File(fileName), true);
        BufferedReader br = new BufferedReader(new StringReader(this.toTDLString(false)));
        if (skipHeader) {
            br.readLine();
        }
        while ((line = br.readLine()) != null) {
            fw.write(String.valueOf(line) + "\n");
        }
        fw.close();
    }

    public String toTDLString() {
        return this.toTDLString(false);
    }

    public String toTDLString(boolean transposed) {
        StringBuffer sb = new StringBuffer();
        if (transposed) {
            sb.append("GENE\t");
            int i = 0;
            while (i < this.getNObservations()) {
                sb.append(this.experimentIds[i]);
                sb.append(i < this.getNObservations() - 1 ? "\t" : "\n");
                ++i;
            }
            int j = 0;
            while (j < this.getNVariables()) {
                sb.append(String.valueOf(this.getHeader(j)) + "\t");
                int i2 = 0;
                while (i2 < this.getNObservations()) {
                    double[] obs = this.getObservation(i2);
                    sb.append("" + obs[j]);
                    sb.append(i2 < this.getNObservations() - 1 ? "\t" : "\n");
                    ++i2;
                }
                ++j;
            }
        } else {
            int i = 0;
            while (i < this.getNVariables()) {
                sb.append(this.getHeader(i));
                sb.append(i < this.getNVariables() - 1 ? "\t" : "\n");
                ++i;
            }
            i = 0;
            while (i < this.getNObservations()) {
                double[] obs = this.getObservation(i);
                int j = 0;
                while (j < this.getNVariables()) {
                    sb.append("" + obs[j]);
                    sb.append(j < this.getNVariables() - 1 ? "\t" : "\n");
                    ++j;
                }
                ++i;
            }
        }
        return sb.toString();
    }

    public void append(DataSet data) throws RuntimeException {
        if (this.getNVariables() != data.getNVariables()) {
            throw new RuntimeException("error: cannot append dataset, nr of variables is different: " + this.getNVariables() + " != " + data.getNVariables());
        }
        double[][] newData = new double[this.getNObservations() + data.getNObservations()][this.getNVariables()];
        int i = 0;
        while (i < this.getNObservations()) {
            System.arraycopy(this.data[i], 0, newData[i], 0, this.data[i].length);
            ++i;
        }
        i = 0;
        while (i < data.getNObservations()) {
            double[] src = data.data[i];
            System.arraycopy(src, 0, newData[this.getNObservations() + i], 0, src.length);
            ++i;
        }
        this.data = newData;
        int oldNObservations = this.nObservations;
        this.nObservations += data.getNObservations();
        int[] newKnockout = new int[this.getNObservations()];
        System.arraycopy(this.knockout, 0, newKnockout, 0, this.knockout.length);
        System.arraycopy(data.getKnockouts(), 0, newKnockout, this.knockout.length, data.knockout.length);
        this.knockout = newKnockout;
        double[] newKnockoutValue = new double[this.getNObservations()];
        System.arraycopy(this.knockoutValue, 0, newKnockoutValue, 0, this.knockoutValue.length);
        System.arraycopy(data.getKnockoutValues(), 0, newKnockoutValue, this.knockoutValue.length, data.knockoutValue.length);
        this.knockoutValue = newKnockoutValue;
        String[] oldIds = this.experimentIds;
        this.experimentIds = new String[this.nObservations];
        int i2 = 0;
        while (i2 < oldNObservations) {
            this.experimentIds[i2] = oldIds[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < data.getNObservations()) {
            this.experimentIds[oldNObservations + i2] = data.experimentIds[i2];
            ++i2;
        }
    }

    public void addElementwise(DataSet data2) throws RuntimeException {
        if (this.getNVariables() != data2.getNVariables()) {
            throw new RuntimeException("error: cannot add dataset, nr of variables is different: " + this.getNVariables() + " != " + data2.getNVariables());
        }
        if (this.getNObservations() != data2.getNObservations()) {
            throw new RuntimeException("error: cannot add dataset, nr of observations is different: " + this.getNObservations() + " != " + data2.getNObservations());
        }
        int i = 0;
        while (i < this.getNObservations()) {
            int j = 0;
            while (j < this.getNVariables()) {
                this.set(i, j, this.value(i, j) + data2.value(i, j));
                ++j;
            }
            ++i;
        }
    }

    public void divide(double denominator) throws RuntimeException {
        int i = 0;
        while (i < this.getNObservations()) {
            int j = 0;
            while (j < this.getNVariables()) {
                this.set(i, j, this.value(i, j) / denominator);
                ++j;
            }
            ++i;
        }
    }
}

