/*
 * Decompiled with CFR 0.152.
 */
package islab.bayesian;

import cern.jet.random.engine.MersenneTwister;
import islab.bayesian.IncidenceMatrix;
import islab.lib.RandomElement;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Arrays;

public class GenerateSubsets {
    public static void main(String[] args) {
        if (args.length != 5) {
            System.err.println("expect siffile, size, num, dir, seed");
            System.exit(1);
        }
        try {
            String sifFile = args[0];
            int size = Integer.parseInt(args[1]);
            int num = Integer.parseInt(args[2]);
            String dir = args[3];
            int seed = Integer.parseInt(args[4]);
            GenerateSubsets.createSubsets(sifFile, size, num, dir, seed);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public static void createSubsets(String sifFile, int size, int num, String dir, int seed) {
        try {
            int i;
            IncidenceMatrix im = IncidenceMatrix.fromSIF(sifFile);
            MersenneTwister mt = new MersenneTwister(seed);
            IncidenceMatrix[] sub = new IncidenceMatrix[num];
            int i2 = 0;
            while (i2 < num) {
                System.out.println("do " + i2);
                sub[i2] = im.randomSubgraph(new RandomElement(mt), size);
                ++i2;
            }
            int[] histo = new int[num];
            Arrays.fill(histo, 1);
            double[][] target = new double[size][size];
            int s = 0;
            while (s < num - 1) {
                if (histo[s] != -1) {
                    i = 0;
                    while (i < target.length) {
                        int j = 0;
                        while (j < target.length) {
                            if (i == j) {
                                target[i][i] = 0.0;
                            }
                            target[i][j] = sub[s].get(i, j) == 0 ? -1 : 1;
                            ++j;
                        }
                        ++i;
                    }
                    int t = s + 1;
                    while (t < num) {
                        double score = sub[t].incrementalBestEquivalency(target);
                        if (score == (double)(size * (size - 1))) {
                            int n = s;
                            histo[n] = histo[n] + 1;
                            histo[t] = -1;
                        }
                        ++t;
                    }
                }
                ++s;
            }
            int cnt = 0;
            i = 0;
            while (i < num) {
                if (histo[i] == -1) {
                    ++cnt;
                }
                ++i;
            }
            System.out.println(String.valueOf(cnt) + " copies");
            PrintWriter out = new PrintWriter(new FileOutputStream(String.valueOf(dir) + "/histogram.txt"));
            out.println("Count");
            int i3 = 0;
            while (i3 < num) {
                if (histo[i3] != -1) {
                    out.println(histo[i3]);
                }
                ++i3;
            }
            out.close();
            int index = 0;
            int i4 = 0;
            while (i4 < num) {
                if (histo[i4] != -1) {
                    out = new PrintWriter(new FileOutputStream(String.valueOf(dir) + "/" + index + ".im"));
                    sub[i4].toIncidenceFile(out);
                    out.close();
                    out = new PrintWriter(new FileOutputStream(String.valueOf(dir) + "/" + index + ".sif"));
                    sub[i4].toSIF(out);
                    out.close();
                    ++index;
                }
                ++i4;
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public static class CreateExampleNetworks {
        public static void examples_2004_09_01() {
            String[] args = new String[]{"./data/ecoli/DAG1_clean.sif", "10", "3", "./data/experiments/2004-09-01 ecoli_subsets", "0"};
            GenerateSubsets.main(args);
        }

        public static void main(String[] args) {
            CreateExampleNetworks.examples_2004_09_01();
        }
    }
}

