/*
 * Decompiled with CFR 0.152.
 */
package islab.bayesian;

import cern.jet.random.EmpiricalWalker;
import cern.jet.random.Gamma;
import cern.jet.random.Poisson;
import islab.bayesian.ConstantModel;
import islab.bayesian.IProvideMean;
import islab.bayesian.LinearModel;
import islab.bayesian.WhiteNoiseModel;
import islab.bayesian.genenetwork.EdgeType;
import islab.bayesian.genenetwork.GeneNetwork;
import islab.bayesian.genenetwork.NActivatorsMM;
import islab.bayesian.genenetwork.NRegulatorsCoop;
import islab.bayesian.genenetwork.NRegulatorsMM;
import islab.bayesian.genenetwork.NRepressorsMM;
import islab.bayesian.genenetwork.Node;
import islab.bayesian.genenetwork.OneActivatorCoop;
import islab.bayesian.genenetwork.OneActivatorOneRepressorComp;
import islab.bayesian.genenetwork.OneActivatorOneRepressorNoComp;
import islab.bayesian.genenetwork.OneRepressorCoop;
import islab.bayesian.genenetwork.TwoActivatorsSynergism;
import islab.lib.RandomElement;
import islab.lib.XmlXomReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import org.xml.sax.SAXParseException;

public class IProvideMeanFactory {
    public static IProvideMean createOneActivatorCoop(String name, RandomElement random) {
        Gamma gammaDist = new Gamma(8.0, 12.5, random.getRandomEngine());
        double Kh = gammaDist.nextDouble();
        Poisson poissonDist = new Poisson(1.0, random.getRandomEngine());
        double n = poissonDist.nextDouble() + 1.0;
        double V0max = 0.0;
        double Vmax = 0.5;
        return new OneActivatorCoop(V0max, Vmax, n, Kh);
    }

    public static IProvideMean createOneActivatorNoCoop(String name, RandomElement random) {
        Gamma gammaDist = new Gamma(8.0, 12.5, random.getRandomEngine());
        double Kh = gammaDist.nextDouble();
        double n = 1.0;
        double V0max = 0.0;
        double Vmax = 0.5;
        return new OneActivatorCoop(V0max, Vmax, n, Kh);
    }

    public static IProvideMean createOneRepressorCoop(String name, RandomElement random) {
        Gamma gammaDist = new Gamma(8.0, 12.5, random.getRandomEngine());
        double Kh = gammaDist.nextDouble();
        Poisson poissonDist = new Poisson(1.0, random.getRandomEngine());
        double n = poissonDist.nextDouble() + 1.0;
        double Vmax = 0.5;
        return new OneRepressorCoop(Vmax, n, Kh);
    }

    public static IProvideMean createOneRepressorNoCoop(String name, RandomElement random) {
        Gamma gammaDist = new Gamma(8.0, 12.5, random.getRandomEngine());
        double Kh = gammaDist.nextDouble();
        double n = 1.0;
        double Vmax = 0.5;
        return new OneRepressorCoop(Vmax, n, Kh);
    }

    public static IProvideMean createTwoActivatorsSynergism(String name, RandomElement random) {
        Gamma gammaDist = new Gamma(8.0, 12.5, random.getRandomEngine());
        double K1a = gammaDist.nextDouble();
        double K2a = gammaDist.nextDouble();
        Poisson poissonDist = new Poisson(1.0, random.getRandomEngine());
        double beta = poissonDist.nextDouble() + 1.0;
        double V0max = 0.1;
        double V1max = 1.0;
        double V2max = 1.0;
        return new TwoActivatorsSynergism(V0max, V1max, V2max, K1a, K2a, beta);
    }

    public static IProvideMean createTwoActivatorsNoSynergism(String name, RandomElement random) {
        Gamma gammaDist = new Gamma(8.0, 12.5, random.getRandomEngine());
        double K1a = gammaDist.nextDouble();
        double K2a = gammaDist.nextDouble();
        double beta = 1.0;
        double V0max = 0.0;
        double V1max = 1.0;
        double V2max = 1.0;
        return new TwoActivatorsSynergism(V0max, V1max, V2max, K1a, K2a, beta);
    }

    public static IProvideMean createOneActivatorOneRepressor(String name, RandomElement random, boolean firstIsActivator) {
        EmpiricalWalker empDist = new EmpiricalWalker(new double[]{0.5, 0.5}, 1, random.getRandomEngine());
        if (empDist.nextInt() == 1) {
            return IProvideMeanFactory.createOneActivatorOneRepressorComp(name, random, firstIsActivator);
        }
        return IProvideMeanFactory.createOneActivatorOneRepressorNoComp(name, random, firstIsActivator);
    }

    private static IProvideMean createOneActivatorOneRepressorComp(String name, RandomElement random, boolean firstIsActivator) {
        Gamma gammaDist = new Gamma(8.0, 12.5, random.getRandomEngine());
        double Ka = gammaDist.nextDouble();
        double Ki = gammaDist.nextDouble();
        double V0max = 0.1;
        double Vmax = 5.0;
        return new OneActivatorOneRepressorComp(V0max, Vmax, Ka, Ki, firstIsActivator);
    }

    private static IProvideMean createOneActivatorOneRepressorNoComp(String name, RandomElement random, boolean firstIsActivator) {
        Gamma gammaDist = new Gamma(8.0, 12.5, random.getRandomEngine());
        double Ka = gammaDist.nextDouble();
        double Ki = gammaDist.nextDouble();
        double V0max = 0.1;
        double Vmax = 5.0;
        return new OneActivatorOneRepressorNoComp(V0max, Vmax, Ka, Ki, firstIsActivator);
    }

    public static IProvideMean createNActivatorsMM(String name, int numReg, RandomElement random) {
        Gamma gammaDist = new Gamma(8.0, 12.5, random.getRandomEngine());
        double[] Ka = new double[numReg];
        int i = 0;
        while (i < numReg) {
            Ka[i] = gammaDist.nextDouble();
            ++i;
        }
        double[] Vmax = new double[numReg];
        Arrays.fill(Vmax, 2.0);
        double V0max = 0.0;
        return new NActivatorsMM(V0max, Vmax, Ka, numReg);
    }

    public static IProvideMean createNRepressorsMM(String name, int numReg, RandomElement random) {
        Gamma gammaDist = new Gamma(8.0, 12.5, random.getRandomEngine());
        double[] Ki = new double[numReg];
        int i = 0;
        while (i < numReg) {
            Ki[i] = gammaDist.nextDouble();
            ++i;
        }
        double V0max = 4.0;
        return new NRepressorsMM(V0max, Ki, numReg);
    }

    public static IProvideMean createNRegulatorsMM(String name, int numReg, int[] type, RandomElement random) {
        Gamma gammaDist = new Gamma(8.0, 12.5, random.getRandomEngine());
        double[] Keq = new double[numReg];
        int i = 0;
        while (i < numReg) {
            Keq[i] = gammaDist.nextDouble();
            ++i;
        }
        double[] FoldActivation = new double[numReg];
        int i2 = 0;
        while (i2 < numReg) {
            if (type[i2] == 1) {
                FoldActivation[i2] = 20.0;
            }
            if (type[i2] == 0) {
                FoldActivation[i2] = 0.0;
            }
            ++i2;
        }
        double V0max = 0.2;
        return new NRegulatorsMM(V0max, FoldActivation, Keq, type, numReg);
    }

    public static IProvideMean createNRegulatorsCoop(String name, int numReg, int[] type, RandomElement random) {
        Gamma gammaDist = new Gamma(8.0, 12.5, random.getRandomEngine());
        double[] Keq = new double[numReg];
        int i = 0;
        while (i < numReg) {
            Keq[i] = gammaDist.nextDouble();
            ++i;
        }
        double[] FoldActivation = new double[numReg];
        int i2 = 0;
        while (i2 < numReg) {
            if (type[i2] == 1) {
                FoldActivation[i2] = 20.0;
            }
            if (type[i2] == 0) {
                FoldActivation[i2] = 0.0;
            }
            ++i2;
        }
        double[] Hill = new double[numReg];
        Poisson poissonDist = new Poisson(1.0, random.getRandomEngine());
        int i3 = 0;
        while (i3 < numReg) {
            Hill[i3] = poissonDist.nextDouble() + 1.0;
            ++i3;
        }
        double V0max = 0.2;
        return new NRegulatorsCoop(V0max, FoldActivation, Keq, Hill, type, numReg);
    }

    public static IProvideMean createRandomIPM(Node node, String name, double higherOrderProbability, RandomElement random) {
        GeneNetwork gn = node.getGeneNetwork();
        ArrayList parents = node.getParents();
        if (parents.size() == 0 || parents.size() == 1 && parents.get(0).equals(node)) {
            double value = random.uniform(0.0, 1.0);
            return new ConstantModel(value);
        }
        if (parents.size() == 1) {
            Node parent = (Node)parents.get(0);
            EdgeType type = gn.getEdgeInfo(parent, node);
            if (type == EdgeType.ACTIVATOR) {
                if (random.uniform(0.0, 1.0) > higherOrderProbability) {
                    return IProvideMeanFactory.createOneActivatorNoCoop(name, random);
                }
                return IProvideMeanFactory.createOneActivatorCoop(name, random);
            }
            if (type == EdgeType.REPRESSOR) {
                if (random.uniform(0.0, 1.0) > higherOrderProbability) {
                    return IProvideMeanFactory.createOneRepressorNoCoop(name, random);
                }
                return IProvideMeanFactory.createOneRepressorCoop(name, random);
            }
            if (random.uniform(0.0, 1.0) > higherOrderProbability) {
                return IProvideMeanFactory.createOneActivatorNoCoop(name, random);
            }
            return IProvideMeanFactory.createOneActivatorCoop(name, random);
        }
        if (parents.size() == 2) {
            Node parent1 = (Node)parents.get(0);
            EdgeType type1 = gn.getEdgeInfo(parent1, node);
            Node parent2 = (Node)parents.get(1);
            EdgeType type2 = gn.getEdgeInfo(parent2, node);
            if (type1 == EdgeType.ACTIVATOR && type2 == EdgeType.ACTIVATOR) {
                if (random.uniform(0.0, 1.0) > higherOrderProbability) {
                    return IProvideMeanFactory.createTwoActivatorsNoSynergism(name, random);
                }
                return IProvideMeanFactory.createTwoActivatorsSynergism(name, random);
            }
            if (type1 == EdgeType.ACTIVATOR && type2 == EdgeType.REPRESSOR) {
                return IProvideMeanFactory.createOneActivatorOneRepressor(name, random, true);
            }
            if (type1 == EdgeType.REPRESSOR && type2 == EdgeType.ACTIVATOR) {
                return IProvideMeanFactory.createOneActivatorOneRepressor(name, random, false);
            }
            if (type1 == EdgeType.REPRESSOR && type2 == EdgeType.REPRESSOR) {
                return IProvideMeanFactory.createNRepressorsMM(name, 2, random);
            }
            if (type1 == EdgeType.ACTIVATOR && type2 == EdgeType.UNKNOWN) {
                if (random.uniform(0.0, 1.0) > 0.5) {
                    return IProvideMeanFactory.createOneActivatorOneRepressor(name, random, true);
                }
                if (random.uniform(0.0, 1.0) > higherOrderProbability) {
                    return IProvideMeanFactory.createTwoActivatorsNoSynergism(name, random);
                }
                return IProvideMeanFactory.createTwoActivatorsSynergism(name, random);
            }
            if (type1 == EdgeType.REPRESSOR && type2 == EdgeType.UNKNOWN) {
                if (random.uniform(0.0, 1.0) > 0.5) {
                    return IProvideMeanFactory.createOneActivatorOneRepressor(name, random, false);
                }
                return IProvideMeanFactory.createNRepressorsMM(name, 2, random);
            }
            return IProvideMeanFactory.createOneActivatorOneRepressor(name, random, random.uniform(0.0, 1.0) > 0.5);
        }
        int cntActivators = 0;
        int cntRepressors = 0;
        int cntUnknown = 0;
        int i = 0;
        while (i < parents.size()) {
            Node parent = (Node)parents.get(i);
            if (gn.getEdgeInfo(parent, node) == EdgeType.ACTIVATOR) {
                ++cntActivators;
            } else if (gn.getEdgeInfo(parent, node) == EdgeType.REPRESSOR) {
                ++cntRepressors;
            } else {
                ++cntUnknown;
            }
            ++i;
        }
        if (parents.size() == cntActivators) {
            return IProvideMeanFactory.createNActivatorsMM(name, cntActivators, random);
        }
        if (parents.size() == cntRepressors) {
            return IProvideMeanFactory.createNRepressorsMM(name, cntRepressors, random);
        }
        int[] type = new int[parents.size()];
        int i2 = 0;
        while (i2 < parents.size()) {
            Node parent = (Node)parents.get(i2);
            EdgeType edgeType = gn.getEdgeInfo(parent, node);
            type[i2] = edgeType == EdgeType.ACTIVATOR ? 1 : (edgeType == EdgeType.REPRESSOR ? 0 : 2);
            ++i2;
        }
        return IProvideMeanFactory.createNRegulatorsMM(name, parents.size(), type, random);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IProvideMean fromXML(String xml) throws SAXParseException {
        void var1_6;
        Object var1_1 = null;
        Document dom = XmlXomReader.getDocument(xml);
        Element xmlNode = dom.getRootElement();
        if (!xmlNode.getLocalName().equals("IProvideMean")) {
            throw new SAXParseException("Error parsing xml: expected tag <IProvideMean>, but received <" + xmlNode.getLocalName() + ">", null);
        }
        String type = null;
        Attribute att = xmlNode.getAttribute("type");
        if (att != null) {
            type = att.getValue();
        }
        if (type != null) {
            if (type.equals("LinearModel")) {
                LinearModel linearModel = LinearModel.fromXML(xml);
                return var1_6;
            } else if (type.equals("WhiteNoiseModel")) {
                WhiteNoiseModel whiteNoiseModel = WhiteNoiseModel.fromXML(xml);
                return var1_6;
            } else {
                if (!type.equals("ConstantModel")) throw new SAXParseException("Error parsing xml string: unknown <IProvideMean> type : " + type, null);
                ConstantModel constantModel = ConstantModel.fromXML(xml);
            }
            return var1_6;
        }
        Elements fncs = xmlNode.getChildElements("function");
        if (fncs.size() != 1) {
            throw new SAXParseException("Error parsing xml string: <IProvideMean> without type should have exactly 1 function", null);
        }
        Element function = fncs.get(0);
        String fncName = function.getAttribute("name").getValue();
        String fullClassName = "islab.bayesian.genenetwork." + fncName;
        try {
            Class<?> cl = Class.forName(fullClassName);
            Method fromXML = cl.getMethod("fromXML", String.class);
            IProvideMean iProvideMean = (IProvideMean)fromXML.invoke(null, xmlNode.toXML());
            return var1_6;
        }
        catch (ClassNotFoundException ex) {
            System.out.println(ex.getMessage());
            throw new SAXParseException("Error parsing xml string: could not find class " + fullClassName + " (assuming it is in genenetwork package)", null);
        }
        catch (NoSuchMethodException ex) {
            System.out.println(ex.getMessage());
            throw new SAXParseException("Error parsing xml string: could not find method toXML(String) in " + fullClassName, null);
        }
        catch (IllegalAccessException ex) {
            System.out.println(ex.getMessage());
            throw new SAXParseException(ex.getMessage(), null);
        }
        catch (InvocationTargetException ex) {
            System.out.println(ex.getMessage());
            throw new SAXParseException(ex.getTargetException().getMessage(), null);
        }
    }
}

