/*
 * Decompiled with CFR 0.152.
 */
package islab.bayesian;

import cern.jet.random.engine.MersenneTwister;
import islab.lib.RandomElement;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;

public class IncidenceMatrix {
    private int[][] matrix;
    private HashMap nodes;
    private String[] names;

    public int get(int i, int j) {
        return this.matrix[i][j];
    }

    public void set(int i, int j, int type) {
        this.matrix[i][j] = type;
    }

    public int getNrNodes() {
        return this.matrix.length;
    }

    public int size() {
        return this.matrix.length;
    }

    public IncidenceMatrix(int nNodes, HashMap nodes) {
        this.matrix = new int[nNodes][nNodes];
        this.nodes = nodes;
        this.names = null;
    }

    public IncidenceMatrix(int nNodes) {
        this(nNodes, null);
    }

    private void setName(int i, String name) {
        if (this.names == null) {
            this.names = new String[this.matrix.length];
        }
        this.names[i] = name;
    }

    public String getName(int i) {
        if (this.names == null) {
            return "" + i;
        }
        return this.names[i];
    }

    public int getNameIndex(String name) {
        int index = 0;
        while (index != this.names.length && !this.names[index].equals(name)) {
            ++index;
        }
        if (index == this.names.length) {
            return -1;
        }
        return index;
    }

    private void setNodeIndex(int i, String name) {
        if (this.nodes == null) {
            this.nodes = new HashMap();
        }
        this.nodes.put(name, new Integer(i));
    }

    public void set(int i, String name) {
        this.setNodeIndex(i, name);
        this.setName(i, name);
    }

    public int getNodeIndex(String name) {
        if (this.nodes == null) {
            return -1;
        }
        Object o = this.nodes.get(name);
        if (o == null) {
            return -1;
        }
        return Integer.parseInt((String)o);
    }

    public static IncidenceMatrix fromSIF(String SIFFile) {
        try {
            LineNumberReader reader = new LineNumberReader(new FileReader(SIFFile));
            String line = reader.readLine();
            int id = 0;
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            while (line != null) {
                String name1;
                StringTokenizer tokenizer = new StringTokenizer(line);
                if (tokenizer.countTokens() == 3) {
                    name1 = tokenizer.nextToken();
                    String type = tokenizer.nextToken();
                    String name2 = tokenizer.nextToken();
                    if (name1 == null || name2 == null || type == null) {
                        throw new RuntimeException("bad sif format at line '" + line + "'");
                    }
                    if (!map.containsKey(name1)) {
                        map.put(name1, new Integer(id++));
                    }
                    if (!map.containsKey(name2)) {
                        map.put(name2, new Integer(id++));
                    }
                } else if (tokenizer.countTokens() == 1) {
                    name1 = tokenizer.nextToken();
                    if (!map.containsKey(name1)) {
                        map.put(name1, new Integer(id++));
                    }
                } else {
                    throw new RuntimeException("bad sif format at line '" + line + "'");
                }
                line = reader.readLine();
            }
            reader.close();
            IncidenceMatrix im = new IncidenceMatrix(id, map);
            reader = new LineNumberReader(new FileReader(SIFFile));
            line = reader.readLine();
            while (line != null) {
                StringTokenizer tokenizer = new StringTokenizer(line);
                if (tokenizer.countTokens() == 3) {
                    int code;
                    String name1 = tokenizer.nextToken();
                    String type = tokenizer.nextToken();
                    String name2 = tokenizer.nextToken();
                    int from = (Integer)map.get(name1);
                    int to = (Integer)map.get(name2);
                    im.matrix[from][to] = code = type.equals("ac") ? 1 : (type.equals("re") ? 2 : 3);
                }
                line = reader.readLine();
            }
            reader.close();
            for (String name : map.keySet()) {
                int index = (Integer)map.get(name);
                im.setName(index, name);
            }
            return im;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void set(int from, int to, String type) {
        int code;
        this.matrix[from][to] = code = type.equals("ac") ? 1 : (type.equals("re") ? 2 : 3);
    }

    public static IncidenceMatrix fromIM(String IncidenceFile) {
        try {
            LineNumberReader reader = new LineNumberReader(new FileReader(IncidenceFile));
            String line = reader.readLine();
            int nLines = 0;
            int nNodes = 0;
            IncidenceMatrix im = null;
            while (line != null) {
                StringTokenizer tokenizer = new StringTokenizer(line);
                if (nLines == 0) {
                    nNodes = tokenizer.countTokens();
                    im = new IncidenceMatrix(nNodes);
                } else if (nNodes != tokenizer.countTokens()) {
                    throw new RuntimeException("Number of arguments differs between lines");
                }
                int i = 0;
                while (i < nNodes) {
                    im.matrix[nLines][i] = Integer.parseInt(tokenizer.nextToken());
                    ++i;
                }
                line = reader.readLine();
                ++nLines;
            }
            if (nLines != nNodes) {
                throw new RuntimeException("Wrong number of lines in argument file");
            }
            return im;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void toIncidenceFile(PrintWriter out) {
        int i = 0;
        while (i < this.matrix.length) {
            int j = 0;
            while (j < this.matrix.length) {
                if (j != 0) {
                    out.print(" ");
                }
                out.print(this.matrix[i][j]);
                ++j;
            }
            out.println();
            ++i;
        }
        out.flush();
    }

    public String toPajekNet() {
        StringBuffer sb = new StringBuffer();
        sb.append("*Vertices " + this.getNrNodes() + "\r\n");
        int i = 0;
        while (i < this.getNrNodes()) {
            sb.append(" " + (i + 1) + " \"" + this.getName(i) + "\"\r\n");
            ++i;
        }
        int nrArcs = 0;
        int i2 = 0;
        while (i2 < this.getNrNodes()) {
            int j = 0;
            while (j < this.getNrNodes()) {
                if (this.matrix[i2][j] > 0) {
                    ++nrArcs;
                }
                ++j;
            }
            ++i2;
        }
        String[] color = new String[]{"       1 c Red", "       1 c Blue", "       1 c Purple"};
        sb.append("*Arcs " + nrArcs + "\n");
        int i3 = 0;
        while (i3 < this.getNrNodes()) {
            int j = 0;
            while (j < this.getNrNodes()) {
                if (this.matrix[i3][j] > 0) {
                    sb.append(" " + (i3 + 1) + " " + (j + 1) + color[this.matrix[i3][j] - 1] + "\r\n");
                }
                ++j;
            }
            ++i3;
        }
        return sb.toString();
    }

    public String toSIF() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.matrix.length) {
            int j = 0;
            while (j < this.matrix.length) {
                int code = this.matrix[i][j];
                if (code != 0) {
                    String inter = null;
                    switch (code) {
                        case 1: {
                            inter = "ac";
                            break;
                        }
                        case 2: {
                            inter = "re";
                            break;
                        }
                        case 3: {
                            inter = "du";
                            break;
                        }
                        default: {
                            inter = "X";
                        }
                    }
                    sb.append(String.valueOf(this.names[i]) + " " + inter + " " + this.names[j] + "\n");
                }
                ++j;
            }
            ++i;
        }
        return sb.toString();
    }

    public void toSIF(PrintWriter out) {
        out.print(this.toSIF());
        out.flush();
    }

    public static boolean haveCommonNode(IncidenceMatrix im1, IncidenceMatrix im2) {
        HashSet<String> names1 = new HashSet<String>();
        int i = 0;
        while (i < im1.size()) {
            names1.add(im1.getName(i));
            ++i;
        }
        i = 0;
        while (i < im2.size()) {
            if (names1.contains(im2.getName(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static IncidenceMatrix merge(IncidenceMatrix im1, IncidenceMatrix im2) {
        int j;
        IncidenceMatrix im = new IncidenceMatrix(im1.size() + im2.size());
        int i = 0;
        while (i < im1.size()) {
            im.set(i, im1.getName(i));
            j = 0;
            while (j < im1.size()) {
                im.set(i, j, im1.get(i, j));
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < im2.size()) {
            im.set(im1.size() + i, im2.getName(i));
            j = 0;
            while (j < im2.size()) {
                im.set(im1.size() + i, im1.size() + j, im2.get(i, j));
                ++j;
            }
            ++i;
        }
        return im;
    }

    public static IncidenceMatrix mergeAndDisconnect(IncidenceMatrix im1, IncidenceMatrix im2) {
        int j;
        IncidenceMatrix im = new IncidenceMatrix(im1.size() + im2.size());
        HashSet<String> names1 = new HashSet<String>();
        int i = 0;
        while (i < im1.size()) {
            names1.add(im1.getName(i));
            im.set(i, im1.getName(i));
            j = 0;
            while (j < im1.size()) {
                im.set(i, j, im1.get(i, j));
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < im2.size()) {
            if (names1.contains(im2.getName(i))) {
                im.set(im1.size() + i, "duplicate_" + im2.getName(i));
            } else {
                im.set(im1.size() + i, im2.getName(i));
            }
            j = 0;
            while (j < im2.size()) {
                im.set(im1.size() + i, im1.size() + j, im2.get(i, j));
                ++j;
            }
            ++i;
        }
        return im;
    }

    private int[] getChildIndices(int v) {
        ArrayList<Integer> v_children = new ArrayList<Integer>();
        int i = 0;
        while (i < this.getNrNodes()) {
            if (this.matrix[v][i] != 0) {
                v_children.add(new Integer(i));
            }
            ++i;
        }
        int[] children = new int[v_children.size()];
        int i2 = 0;
        for (Integer idx : v_children) {
            children[i2++] = idx;
        }
        return children;
    }

    public IncidenceMatrix randomSubgraph(RandomElement random, int nNodes) {
        return this.randomSubgraph(random, nNodes, -1);
    }

    public IncidenceMatrix randomSubgraph(RandomElement random, int nNodes, int requestedstart) {
        if (nNodes == 0) {
            return new IncidenceMatrix(0);
        }
        int MAX_ATTEMPTS = 1000;
        int cntr = 0;
        IncidenceMatrix target = null;
        do {
            ++cntr;
            int[] taken = new int[this.matrix.length];
            Arrays.fill(taken, -1);
            int[] map = new int[nNodes];
            ArrayList<Integer> neighbors = new ArrayList<Integer>(this.matrix.length);
            int start = requestedstart != -1 ? requestedstart : random.choose(0, this.matrix.length - 1);
            taken[start] = 0;
            map[0] = start;
            boolean failed = false;
            int n = 1;
            while (n < nNodes) {
                int src = 0;
                while (src < n) {
                    int source = map[src];
                    int i = 0;
                    while (i < this.matrix.length) {
                        if ((this.matrix[source][i] != 0 || this.matrix[i][source] != 0) && taken[i] == -1) {
                            neighbors.add(new Integer(i));
                        }
                        ++i;
                    }
                    ++src;
                }
                if (neighbors.size() == 0) {
                    failed = true;
                    break;
                }
                int destination = (Integer)neighbors.get(random.choose(0, neighbors.size() - 1));
                neighbors.clear();
                taken[destination] = n;
                map[n] = destination;
                ++n;
            }
            if (failed) continue;
            target = new IncidenceMatrix(nNodes);
            int i = 0;
            while (i < nNodes) {
                int j = 0;
                while (j < nNodes) {
                    target.matrix[i][j] = this.matrix[map[i]][map[j]];
                    target.set(i, this.names[map[i]]);
                    ++j;
                }
                ++i;
            }
            break;
        } while (cntr < 1000);
        return target;
    }

    public IncidenceMatrix randomSubgraphWithChildren(RandomElement random, int nNodes) {
        return this.randomSubgraphWithChildren(random, nNodes, -1);
    }

    public IncidenceMatrix randomSubgraphWithChildren(RandomElement random, int nNodes, int requestedstart) {
        if (nNodes == 0) {
            return new IncidenceMatrix(0);
        }
        int MAX_ATTEMPTS = 1000;
        int cntr = 0;
        IncidenceMatrix target = null;
        do {
            if (++cntr > 1) {
                System.out.println("  randomSubgraphWithChildren() attempt " + cntr);
            }
            int[] taken = new int[this.matrix.length];
            Arrays.fill(taken, -1);
            int[] map = new int[nNodes];
            int[] neighbors = new int[this.matrix.length];
            int nrNodesAdded = 0;
            int start = requestedstart != -1 ? requestedstart : random.choose(0, this.matrix.length - 1);
            taken[start] = 0;
            map[nrNodesAdded++] = start;
            int[] startChildren = this.getChildIndices(start);
            int i = 0;
            while (i < startChildren.length) {
                if (nrNodesAdded >= nNodes) break;
                if (taken[startChildren[i]] == -1) {
                    taken[startChildren[i]] = nrNodesAdded;
                    map[nrNodesAdded++] = startChildren[i];
                }
                ++i;
            }
            boolean failed = false;
            block2: while (nrNodesAdded < nNodes) {
                int destination = -1;
                int neighborcnt = 0;
                int src = 0;
                while (src < nrNodesAdded) {
                    int source = map[src];
                    int i2 = 0;
                    while (i2 < this.matrix.length) {
                        if ((this.matrix[source][i2] != 0 || this.matrix[i2][source] != 0) && taken[i2] == -1) {
                            neighbors[neighborcnt++] = i2;
                        }
                        ++i2;
                    }
                    ++src;
                }
                if (neighborcnt == 0) {
                    failed = true;
                    break;
                }
                destination = neighbors[random.choose(0, neighborcnt - 1)];
                if (taken[destination] == -1) {
                    taken[destination] = nrNodesAdded;
                    map[nrNodesAdded++] = destination;
                }
                int[] destChildren = this.getChildIndices(destination);
                int i3 = 0;
                while (i3 < destChildren.length) {
                    if (nrNodesAdded >= nNodes) continue block2;
                    if (taken[destChildren[i3]] == -1) {
                        taken[destChildren[i3]] = nrNodesAdded;
                        map[nrNodesAdded++] = destChildren[i3];
                    }
                    ++i3;
                }
            }
            if (failed) continue;
            target = new IncidenceMatrix(nNodes);
            int i4 = 0;
            while (i4 < nNodes) {
                target.set(i4, this.names[map[i4]]);
                int j = 0;
                while (j < nNodes) {
                    target.matrix[i4][j] = this.matrix[map[i4]][map[j]];
                    ++j;
                }
                ++i4;
            }
            break;
        } while (cntr < 1000);
        return target;
    }

    public double incrementalEquivalency(double[][] target, int[] permutation, int newPos, int[] sourcePermutation) {
        double sum = 0.0;
        int i = 0;
        while (i < newPos) {
            sum += (double)(this.matrix[sourcePermutation[newPos]][sourcePermutation[i]] == 0 ? -1 : 1) * target[permutation[newPos]][permutation[i]];
            sum += (double)(this.matrix[sourcePermutation[i]][sourcePermutation[newPos]] == 0 ? -1 : 1) * target[permutation[i]][permutation[newPos]];
            ++i;
        }
        return sum;
    }

    public double equivalency(double[][] target, int[] permutation) {
        double score = 0.0;
        int i = 0;
        while (i < permutation.length) {
            int j = 0;
            while (j < permutation.length) {
                if (i != j) {
                    score += (double)(this.matrix[i][j] == 0 ? -1 : 1) * target[permutation[i]][permutation[j]];
                }
                ++j;
            }
            ++i;
        }
        return score;
    }

    /*
     * Unable to fully structure code
     */
    private double recursive(double[][] target, int[] permutation, int at, boolean[] done, double best) {
        if (at == this.matrix.length) {
            score = this.equivalency(target, permutation);
            return score > best ? score : best;
        }
        next = 0;
        i = 0;
        ** GOTO lbl16
        {
            ++next;
            do {
                if (done[next]) continue block0;
                done[next] = true;
                permutation[at] = next;
                best = this.recursive(target, permutation, at + 1, done, best);
                done[next] = false;
                ++next;
                ++i;
lbl16:
                // 2 sources

            } while (i < this.matrix.length - at);
        }
        return best;
    }

    /*
     * Unable to fully structure code
     */
    private double incrementalRecursive(double[][] target, int[] permutation, int at, boolean[] done, double best, double score, int[] sourcePermutation) {
        if (at == this.matrix.length) {
            return score > best ? score : best;
        }
        next = 0;
        bound = this.matrix.length * (this.matrix.length - 1) - at * (at + 1);
        i = 0;
        ** GOTO lbl18
        {
            ++next;
            do {
                if (done[next]) continue block0;
                done[next] = true;
                permutation[at] = next;
                sum = this.incrementalEquivalency(target, permutation, at, sourcePermutation);
                if (score + sum + (double)bound >= best) {
                    best = this.incrementalRecursive(target, permutation, at + 1, done, best, score + sum, sourcePermutation);
                }
                done[next] = false;
                ++next;
                ++i;
lbl18:
                // 2 sources

            } while (i < this.matrix.length - at);
        }
        return best;
    }

    public double bestEquivalency(double[][] target) {
        int[] permutation = new int[this.matrix.length];
        Arrays.fill(permutation, -1);
        boolean[] done = new boolean[this.matrix.length];
        Arrays.fill(done, false);
        return this.recursive(target, permutation, 0, done, 0.0);
    }

    public double incrementalBestEquivalency(double[][] target) {
        int[] permutation = new int[this.matrix.length];
        Arrays.fill(permutation, -1);
        boolean[] done = new boolean[this.matrix.length];
        Arrays.fill(done, false);
        int[] sourcePermutation = new int[this.matrix.length];
        int i = 0;
        while (i < this.matrix.length) {
            sourcePermutation[i] = i;
            ++i;
        }
        return this.incrementalRecursive(target, permutation, 0, done, 0.0, 0.0, sourcePermutation);
    }

    public static void main(String[] args) {
        IncidenceMatrix im = IncidenceMatrix.fromSIF(args[0]);
        int size = Integer.parseInt(args[1]);
        int seed = Integer.parseInt(args[2]);
        MersenneTwister mt = new MersenneTwister(seed);
        PrintWriter out = new PrintWriter(System.out);
        IncidenceMatrix sub = im.randomSubgraph(new RandomElement(mt), size);
        sub.toIncidenceFile(out);
        System.out.println("---");
        double[][] target = new double[sub.matrix.length][sub.matrix.length];
        int i = 0;
        while (i < target.length) {
            int j = 0;
            while (j < target.length) {
                if (i == j) {
                    target[i][i] = 0.0;
                }
                target[i][j] = sub.matrix[i][j] == 0 ? -1 : 1;
                ++j;
            }
            ++i;
        }
        System.out.println("best eq " + sub.incrementalBestEquivalency(target));
    }

    public boolean isTopNode(int index) {
        int i = 0;
        while (i < this.getNrNodes()) {
            if (i != index && this.matrix[i][index] != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int getNrTopNodes() {
        int cntr = 0;
        int j = 0;
        while (j < this.getNrNodes()) {
            if (this.isTopNode(j)) {
                ++cntr;
            }
            ++j;
        }
        return cntr;
    }
}

