/*
 * Decompiled with CFR 0.152.
 */
package islab.bayesian;

import cern.jet.random.Normal;
import islab.bayesian.DataSet;
import islab.bayesian.IProvideMean;
import islab.bayesian.IProvideMeanFactory;
import islab.bayesian.ProbabilityModel;
import islab.bayesian.genenetwork.Node;
import islab.lib.RandomElement;
import islab.lib.XmlXomReader;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import org.apache.commons.math.ConvergenceException;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.analysis.BrentSolver;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.xml.sax.SAXParseException;

public class LognormalNoise
extends ProbabilityModel {
    private TransformationFunction tfFunction;
    public static final double RESOLUTION = 0.01;
    private RandomElement random;
    private Normal normal;
    private IProvideMean provideMean;
    private double stddev;
    private Node node;

    public LognormalNoise(RandomElement random, IProvideMean provideMean, double stddev, Node node) {
        this.provideMean = provideMean;
        this.random = random;
        this.stddev = stddev;
        this.normal = new Normal(0.0, this.stddev, this.random.getRandomEngine());
        this.node = node;
        this.tfFunction = new TransformationFunction(node);
    }

    public double probability(double value, double[] configuration, int[] indexIncoming) {
        double mean = this.provideMean.computeMean(configuration, indexIncoming);
        double x = Math.log(value) - Math.log(mean);
        return this.normal.cdf(x + 0.01) - this.normal.cdf(x - 0.01);
    }

    public double sample(RandomElement random, double[] configuration, int[] indexIncoming) {
        double mean = this.provideMean.computeMean(configuration, indexIncoming);
        double lnorm = Math.exp(this.normal.nextDouble());
        double x = mean;
        double y = this.transformationFunction(x);
        double y2 = y * lnorm;
        double x2 = this.inverseTransformationFunction(y2);
        double newValue = x2;
        if (newValue > 1.0 || newValue < 0.0) {
            System.err.println("WARNING: expression value out of normalized bounds [0..1]: " + newValue);
        }
        return newValue;
    }

    private double inverseTransformationFunction(double y) {
        return this.tfFunction.inverseValue(y);
    }

    private double transformationFunction(double x) {
        return this.tfFunction.value(x);
    }

    public boolean train(DataSet dataset, int[] indices, int index, int[] indexIncoming) {
        return this.provideMean.train(dataset, indices, index, indexIncoming);
    }

    public double getStddev() {
        return this.stddev;
    }

    public void setStddev(double stddev) {
        this.stddev = stddev;
        this.normal = new Normal(0.0, this.stddev, this.random.getRandomEngine());
    }

    public String toString() {
        return " stddev: " + this.stddev + " function: " + this.provideMean;
    }

    public String toXML(String indentString) {
        return this.toXML(1, indentString);
    }

    public String toXML(int indentLevel, String indentString) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < indentLevel) {
            sb.append(indentString);
            ++i;
        }
        String indent = sb.toString();
        sb = new StringBuffer();
        sb.append(String.valueOf(indent) + "<ProbabilityModel type=\"LognormalNoise\">\n");
        sb.append(String.valueOf(indent) + "<parameter name=\"stddev\">" + this.stddev + "</parameter>\n");
        sb.append(this.provideMean.toXML(indent));
        sb.append(String.valueOf(indent) + "</ProbabilityModel>\n");
        return sb.toString();
    }

    public static LognormalNoise fromXML(RandomElement randomGen, String xml) throws SAXParseException {
        try {
            Document dom = XmlXomReader.getDocument(xml);
            Element xmlNode = dom.getRootElement();
            if (!xmlNode.getLocalName().equals("ProbabilityModel") || !xmlNode.getAttribute("type").getValue().toString().equals("LognormalNoise")) {
                throw new SAXParseException("Error parsing xml: expected <ProbabilityModel type=\"LognormalNoise\">, but received <" + xmlNode.getLocalName() + " type=\"" + xmlNode.getAttribute("type").getValue() + "\"", null);
            }
            double stddev = -1.0;
            boolean flgOk = false;
            Elements params = xmlNode.getChildElements("parameter");
            int i = 0;
            while (i < params.size()) {
                Element p = params.get(i);
                if (p.getAttribute("name").getValue().equals("stddev")) {
                    stddev = Double.parseDouble(p.getValue());
                    flgOk = true;
                    break;
                }
                ++i;
            }
            if (!flgOk) {
                throw new SAXParseException("stddev parameter not found during parsing in LognormalNoise.fromXML()", null);
            }
            Elements ipMeanXml = xmlNode.getChildElements("IProvideMean");
            IProvideMean ipMean = IProvideMeanFactory.fromXML(ipMeanXml.get(0).toXML());
            LognormalNoise lnn = new LognormalNoise(randomGen, ipMean, stddev, null);
            return lnn;
        }
        catch (Exception ex) {
            throw new SAXParseException(ex.getMessage(), null);
        }
    }

    public class TransformationFunction
    implements UnivariateRealFunction {
        private static final double KAPPA = 0.01;
        double offsetValue = 0.0;
        private Node node;

        public TransformationFunction(Node node) {
            this.node = node;
        }

        public double value(double x) {
            double N = 1.0;
            if (this.node != null) {
                N = this.node.getMaxExpression();
            }
            if (x < 0.65) {
                return N * x - this.offsetValue;
            }
            return N * x * Math.exp(-0.01 * (1.0 - x / (1.0 - x))) - this.offsetValue;
        }

        public void setOffsetValue(double x) {
            this.offsetValue = x;
        }

        public double inverseValue(double y) {
            double yOverN;
            double N = 1.0;
            if (this.node != null) {
                N = this.node.getMaxExpression();
            }
            if ((yOverN = y / N) < 0.65) {
                return yOverN;
            }
            LognormalNoise.this.tfFunction.setOffsetValue(y);
            BrentSolver solver = new BrentSolver((UnivariateRealFunction)LognormalNoise.this.tfFunction);
            try {
                try {
                    solver.solve(0.0, 1.0, 0.5);
                }
                catch (ConvergenceException e) {
                    e.printStackTrace();
                }
                catch (FunctionEvaluationException e) {
                    e.printStackTrace();
                }
            }
            finally {
                LognormalNoise.this.tfFunction.setOffsetValue(0.0);
            }
            return solver.getResult();
        }
    }
}

