/*
 * Decompiled with CFR 0.152.
 */
package islab.bayesian;

import cern.colt.list.DoubleArrayList;
import cern.jet.stat.Descriptive;
import islab.bayesian.AddInfo;
import islab.bayesian.DataSet;
import islab.bayesian.DelInfo;
import islab.bayesian.Variable;
import islab.lib.RandomElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class Network {
    private AddInfo addinfo;
    private boolean[][] incidenceMatrix;
    private int nEdges;
    private int nEdgesToBeAdded;
    private int nVariables;
    private int[] order;
    private int[] outdegree;
    private int[] reverseOrder;
    private boolean isDirtyTransitiveClosure = true;
    private boolean[][] transitive;
    private Variable[] variables;

    public Network(Variable[] variables) {
        this.nVariables = variables.length;
        this.variables = variables;
        this.incidenceMatrix = new boolean[this.nVariables][this.nVariables];
        this.transitive = new boolean[this.nVariables][this.nVariables];
        this.order = new int[this.nVariables];
        this.reverseOrder = new int[this.nVariables];
        int i = 0;
        while (i < this.nVariables) {
            this.order[i] = i;
            this.reverseOrder[i] = i;
            ++i;
        }
        this.nEdges = 0;
        this.nEdgesToBeAdded = this.nVariables * (this.nVariables - 1);
        this.outdegree = new int[this.nVariables];
        this.addinfo = new AddInfo();
    }

    public void addEdge(int from, int to) {
        this.addEdge(from, to, this.addinfo);
    }

    public void addEdge(int from, int to, AddInfo add) {
        if (this.isEdge(from, to)) {
            System.out.println("shouldnt add an existing edge " + from + "," + to);
            throw new RuntimeException("shouldnt add an existing edge " + from + "," + to);
        }
        this.isDirtyTransitiveClosure = true;
        this.incidenceMatrix[from][to] = true;
        ++this.nEdges;
        add.to = to;
        add.from = from;
        Variable vFrom = this.variables[from];
        Variable vTo = this.variables[to];
        add.pm = vTo.getProbabilityModel();
        add.ll = vTo.isLogLikelihoodValid() ? vTo.getLogLikelihood() : 1.0;
        vTo.validateLoglikelihood(false);
        vFrom.incNOutgoing();
        add.incoming = vTo.getIncoming();
        add.nValuesIncoming = vTo.getNValuesIncoming();
        add.idIncoming = vTo.getIDIncoming();
        vTo.setNIncoming(vTo.getNIncoming() + 1);
        if (add.incoming != null) {
            int i = 0;
            while (i < add.incoming.length && add.incoming[i].getID() < from) {
                vTo.setIncoming(i, add.incoming[i]);
                ++i;
            }
            vTo.setIncoming(i++, vFrom);
            while (i - 1 < add.incoming.length) {
                vTo.setIncoming(i, add.incoming[i - 1]);
                ++i;
            }
        } else {
            vTo.setIncoming(0, vFrom);
        }
    }

    public void adjustPrior(double[][] edgePriorIN, double[] addOUT, double[] removeOUT) {
        int i = 0;
        while (i < this.nVariables) {
            int j = 0;
            while (j < this.nVariables) {
                int index = this.nVariables * i + j;
                addOUT[index] = this.isEdge(i, j) || this.isEdge(j, i) ? 0.0 : edgePriorIN[i][j];
                removeOUT[index] = !this.isEdge(i, j) ? 0.0 : 1.0 - edgePriorIN[i][j];
                ++j;
            }
            ++i;
        }
    }

    public boolean areConnected(int i, int j) {
        return this.isEdge(i, j) || this.isEdge(j, i);
    }

    public void check() {
        int cnt = 0;
        int i = 0;
        while (i < this.nVariables) {
            int j = 0;
            while (j < this.nVariables) {
                if (i != j && !this.isEdge(i, j) && !this.violateDAG(i, j)) {
                    ++cnt;
                }
                ++j;
            }
            ++i;
        }
        if (cnt != this.nEdgesToBeAdded) {
            throw new RuntimeException("cnt != this.nEdgesToBeAdded");
        }
        boolean[] seen = new boolean[this.nVariables];
        int i2 = 0;
        while (i2 < this.nVariables) {
            if (seen[i2]) {
                throw new RuntimeException("duplicating " + i2);
            }
            seen[this.variables[i2].getID()] = true;
            ++i2;
        }
        i2 = 0;
        while (i2 < this.nVariables) {
            if (!seen[i2]) {
                throw new RuntimeException("missing " + i2);
            }
            ++i2;
        }
        cnt = 0;
        boolean[][] seenEdge = new boolean[this.nVariables][this.nVariables];
        int i3 = 0;
        while (i3 < this.nVariables) {
            int j = 0;
            while (j < this.nVariables) {
                if (this.isEdge(i3, j)) {
                    seenEdge[i3][j] = true;
                    ++cnt;
                }
                ++j;
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < this.nVariables) {
            int[] inc = this.variables[i3].getIDIncoming();
            if (inc != null) {
                int j = 0;
                while (j < inc.length) {
                    if (seenEdge[inc[j]][i3]) {
                        seenEdge[inc[j]][i3] = false;
                        --cnt;
                    } else {
                        throw new RuntimeException("problem with " + inc[j] + "," + i3);
                    }
                    ++j;
                }
            }
            ++i3;
        }
        if (cnt != 0) {
            throw new RuntimeException("spurious edges");
        }
    }

    public void chooseForAdding(RandomElement random, int[] iandj) {
        int index = random.choose(0, this.nEdgesToBeAdded - 1);
        int cnt = 0;
        int i = 0;
        while (i < this.nVariables) {
            int j = 0;
            while (j < this.nVariables) {
                if (!(i == j || this.isEdge(i, j) || this.isEdge(j, i) || this.violateDAG(i, j))) {
                    if (cnt == index) {
                        iandj[0] = i;
                        iandj[1] = j;
                        return;
                    }
                    ++cnt;
                }
                ++j;
            }
            ++i;
        }
        throw new RuntimeException("oops in choose for adding, network");
    }

    public void chooseForRemoval(RandomElement random, int[] iandj) {
        int index = random.choose(0, this.nEdges - 1);
        int cnt = 0;
        int i = 0;
        while (i < this.nVariables) {
            int j = 0;
            while (j < this.nVariables) {
                if (i != j && this.incidenceMatrix[i][j]) {
                    if (cnt == index) {
                        iandj[0] = i;
                        iandj[1] = j;
                        return;
                    }
                    ++cnt;
                }
                ++j;
            }
            ++i;
        }
        throw new RuntimeException("oops in choose for removal, network, cnt = " + cnt + " nedges " + this.nEdges + " index " + index);
    }

    public void commit(AddInfo add) {
        this.computeTransitiveClosure();
    }

    public void commit(DelInfo del) {
        this.computeTransitiveClosure();
    }

    public void computeTransitiveClosure() {
        int x;
        int m = 0;
        while (m < this.nVariables) {
            this.transitive[m][m] = true;
            x = 0;
            while (x < this.nVariables) {
                this.transitive[m][x] = this.incidenceMatrix[m][x];
                ++x;
            }
            ++m;
        }
        this.nEdgesToBeAdded = this.nVariables * (this.nVariables - 1) - this.nEdges * 2;
        m = 0;
        while (m < this.nVariables) {
            x = 0;
            while (x < this.nVariables) {
                if (this.transitive[x][m]) {
                    int y = 0;
                    while (y < this.nVariables) {
                        if (this.transitive[m][y]) {
                            if (!this.transitive[x][y]) {
                                --this.nEdgesToBeAdded;
                            }
                            this.transitive[x][y] = true;
                        }
                        ++y;
                    }
                }
                ++x;
            }
            ++m;
        }
        this.isDirtyTransitiveClosure = false;
    }

    public boolean[][] copyOfIncidenceMatrix(boolean[][] in) {
        boolean[][] res = in;
        if (res == null) {
            res = new boolean[this.nVariables][this.nVariables];
        }
        int i = 0;
        while (i < this.nVariables) {
            int j = 0;
            while (j < this.nVariables) {
                res[i][j] = this.incidenceMatrix[i][j];
                ++j;
            }
            ++i;
        }
        return res;
    }

    public Network cloneStructure() {
        this.nVariables = this.getNVariables();
        Variable[] variables = new Variable[this.nVariables];
        int i = 0;
        while (i < this.getNVariables()) {
            Variable v1 = this.getVariable(i);
            variables[i] = new Variable(v1.getID(), v1.getName(), v1.getNValues());
            variables[i].setType(v1.getType());
            variables[i].setProbabilityModel(v1.getProbabilityModel());
            variables[i].setLogLikelihood(v1.getLogLikelihood());
            ++i;
        }
        i = 0;
        while (i < this.nVariables) {
            if (variables[i] == null) {
                variables[i] = new Variable(i, "I" + i, this.nVariables);
                variables[i].setType(0);
            }
            ++i;
        }
        Network bn = new Network(variables);
        int i2 = 0;
        while (i2 < this.getNVariables()) {
            Variable v = this.getVariable(i2);
            Variable[] par = v.getIncoming();
            if (par != null) {
                int j = 0;
                while (j < par.length) {
                    bn.addEdge(par[j].getID(), v.getID());
                    ++j;
                }
            }
            ++i2;
        }
        return bn;
    }

    public void fillRandomDAG(int numEdges, RandomElement random) {
        AddInfo add = new AddInfo();
        int i = 0;
        while (i < numEdges) {
            int j = -1;
            int k = -1;
            do {
                j = random.choose(0, this.nVariables - 1);
                k = random.choose(0, this.nVariables - 2);
                if (k < j) continue;
                ++k;
            } while (this.isEdge(j, k) || this.isEdge(k, j) || this.violateDAG(j, k));
            this.addEdge(j, k, add);
            this.commit(add);
            ++i;
        }
    }

    public int getDirectOrder(int i) {
        return this.order[i];
    }

    public int[] getIDOutputs(int index) {
        int[] res = new int[this.variables[index].getNOutgoing()];
        int cnt = 0;
        int i = 0;
        while (i < this.nVariables) {
            if (this.incidenceMatrix[index][i]) {
                res[cnt++] = i;
            }
            ++i;
        }
        return res;
    }

    public int getNEdges() {
        return this.nEdges;
    }

    public int getNVariables() {
        return this.nVariables;
    }

    public int getOrder(int i) {
        return this.reverseOrder[i];
    }

    public int[] getValuesPerVariable() {
        int[] res = new int[this.nVariables];
        int i = 0;
        while (i < this.nVariables) {
            res[i] = this.variables[i].getNValues();
            ++i;
        }
        return res;
    }

    public Variable getVariable(int index) {
        return this.variables[index];
    }

    public Variable[] getVariables() {
        return this.variables;
    }

    public int hammingDistance(boolean[][] reference) {
        int hd = 0;
        int i = 0;
        while (i < this.nVariables) {
            int j = 0;
            while (j < this.nVariables) {
                if (reference[i][j] != this.incidenceMatrix[i][j]) {
                    ++hd;
                }
                ++j;
            }
            ++i;
        }
        return hd;
    }

    public void ignore(AddInfo add) {
        this.incidenceMatrix[add.from][add.to] = false;
        --this.nEdges;
        this.variables[add.from].decNOutgoing();
        this.variables[add.to].setIncoming(add.incoming, add.nValuesIncoming, add.idIncoming);
        this.variables[add.to].setProbabilityModel(add.pm);
        if (add.ll <= 0.0) {
            this.variables[add.to].setLogLikelihood(add.ll);
        }
    }

    public void ignore(DelInfo del) {
        this.incidenceMatrix[del.from][del.to] = true;
        ++this.nEdges;
        this.variables[del.from].incNOutgoing();
        this.variables[del.to].setIncoming(del.incoming, del.nValuesIncoming, del.idIncoming);
        this.variables[del.to].setProbabilityModel(del.pm);
        if (del.ll <= 0.0) {
            this.variables[del.to].setLogLikelihood(del.ll);
        }
    }

    public boolean inClosure(int from, int to) {
        if (this.isDirtyTransitiveClosure) {
            this.computeTransitiveClosure();
        }
        return this.transitive[from][to];
    }

    public double incrementalLogLikelihood(DataSet dataset, boolean firstTime) {
        return this.incrementalLogLikelihood(dataset, 0, dataset.getNObservations(), firstTime);
    }

    public double incrementalLogLikelihood(DataSet dataset, int from, int to, boolean firstTime) {
        double ll = 0.0;
        double[][] ddata = dataset.dataset();
        int[] intervention = dataset.getKnockouts();
        int i = 0;
        while (i < this.nVariables) {
            int index = this.order[i];
            int[] indexIncoming = this.variables[index].getIDIncoming();
            double likeli = 0.0;
            if (firstTime || !this.variables[index].isLogLikelihoodValid()) {
                int d = from;
                while (d < to) {
                    if (intervention[d] != index) {
                        likeli += Math.log(this.variables[index].getProbabilityModel().probability(ddata[d][index], ddata[d], indexIncoming));
                    }
                    ++d;
                }
                this.variables[index].setLogLikelihood(likeli);
            } else {
                likeli = this.variables[index].getLogLikelihood();
            }
            ll += likeli;
            ++i;
        }
        return ll;
    }

    public boolean topologicalSort() {
        if (this.isDAG()) {
            this.isDAG(true);
            return true;
        }
        return false;
    }

    public boolean isDAG() {
        return this.isDAG(false);
    }

    public boolean isDAG(boolean changeTopologicalOrder) {
        int i = 0;
        while (i < this.nVariables) {
            this.outdegree[i] = this.variables[i].getNOutgoing();
            ++i;
        }
        int todo = this.nVariables;
        while (todo > 0) {
            int i2 = 0;
            while (i2 < this.nVariables) {
                if (this.outdegree[i2] == 0) break;
                ++i2;
            }
            if (i2 == this.nVariables) {
                return false;
            }
            Variable[] incoming = this.variables[i2].getIncoming();
            if (incoming != null) {
                int j = 0;
                while (j < incoming.length) {
                    int n = incoming[j].getID();
                    this.outdegree[n] = this.outdegree[n] - 1;
                    ++j;
                }
            }
            this.outdegree[i2] = -1;
            if (changeTopologicalOrder) {
                this.order[--todo] = i2;
                this.reverseOrder[i2] = todo;
                continue;
            }
            --todo;
        }
        return true;
    }

    public ArrayList convertToDAG() {
        ArrayList<int[]> backEdges = new ArrayList<int[]>();
        int[] backEdge = this.getOneBackEdge();
        while (backEdge[0] != -1 && backEdge[1] != -1) {
            backEdges.add(backEdge);
            DelInfo info = new DelInfo();
            this.removeEdge(backEdge[0], backEdge[1], info);
            this.commit(info);
            backEdge = this.getOneBackEdge();
        }
        return backEdges;
    }

    public int[] getOneBackEdge() {
        ArrayList<String> color = new ArrayList<String>();
        ArrayList<Object> pred = new ArrayList<Object>();
        int u = 0;
        while (u < this.getNVariables()) {
            color.add("white");
            pred.add(null);
            ++u;
        }
        u = 0;
        while (u < this.getNVariables()) {
            int[] backEdge;
            if (color.get(u).equals("white") && ((backEdge = this.visit(u, color, pred))[0] != -1 || backEdge[1] != -1)) {
                return backEdge;
            }
            ++u;
        }
        return new int[]{-1, -1};
    }

    public int nrSelfEdges() {
        int nrSelf = 0;
        int i = 0;
        while (i < this.incidenceMatrix.length) {
            if (this.incidenceMatrix[i][i]) {
                ++nrSelf;
            }
            ++i;
        }
        return nrSelf;
    }

    public boolean hasSelfEdges() {
        int i = 0;
        while (i < this.incidenceMatrix.length) {
            if (this.incidenceMatrix[i][i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private int[] visit(int u, ArrayList color, ArrayList pred) {
        color.set(u, "gray");
        ArrayList<Variable> adj = new ArrayList<Variable>();
        int i = 0;
        while (i < this.getNVariables()) {
            if (this.isEdge(u, i)) {
                adj.add(this.getVariable(i));
            }
            ++i;
        }
        int t = 0;
        while (t < adj.size()) {
            int v = ((Variable)adj.get(t)).getID();
            if (color.get(v).equals("white")) {
                pred.set(v, new Integer(u));
                int[] tmp = this.visit(v, color, pred);
                if (tmp[0] != -1 || tmp[1] != -1) {
                    return tmp;
                }
            } else if (pred.get(u) != null && v != (Integer)pred.get(u)) {
                return new int[]{u, v};
            }
            ++t;
        }
        return new int[]{-1, -1};
    }

    public boolean isEdge(int i, int j) {
        return this.incidenceMatrix[i][j];
    }

    public double logLikelihood(double[][] dataset, int from, int to) {
        double sum = 0.0;
        int i = from;
        while (i < to) {
            sum += this.logLikelihoodConfiguration(dataset[i]);
            ++i;
        }
        return sum;
    }

    public double logLikelihoodConfiguration(double[] configuration) {
        double ll = 0.0;
        int i = 0;
        while (i < this.nVariables) {
            int index = this.order[i];
            int[] indexIncoming = this.variables[index].getIDIncoming();
            double prob = this.variables[index].getProbabilityModel().probability(configuration[index], configuration, indexIncoming);
            ll += Math.log(prob);
            if (prob < 0.0 || prob > 1.0) {
                System.out.println("getting a probability " + prob);
                System.exit(1);
            }
            ++i;
        }
        return ll;
    }

    public void removeEdge(int from, int to, DelInfo del) {
        if (!this.incidenceMatrix[from][to]) {
            throw new RuntimeException("can't delete an edge that isn't there " + from + "," + to);
        }
        this.incidenceMatrix[from][to] = false;
        --this.nEdges;
        del.from = from;
        del.to = to;
        Variable vFrom = this.variables[from];
        Variable vTo = this.variables[to];
        del.pm = vTo.getProbabilityModel();
        del.ll = vTo.isLogLikelihoodValid() ? vTo.getLogLikelihood() : 1.0;
        vTo.validateLoglikelihood(false);
        vFrom.decNOutgoing();
        del.incoming = vTo.getIncoming();
        del.nValuesIncoming = vTo.getNValuesIncoming();
        del.idIncoming = vTo.getIDIncoming();
        vTo.setNIncoming(vTo.getNIncoming() - 1);
        int cnt = 0;
        int i = 0;
        while (i < del.incoming.length) {
            if (del.incoming[i] != vFrom) {
                vTo.setIncoming(cnt++, del.incoming[i]);
            }
            ++i;
        }
    }

    public double[] sample(RandomElement random) {
        this.topologicalSort();
        double[] s = new double[this.nVariables];
        int i = 0;
        while (i < this.nVariables) {
            int index = this.order[i];
            int[] indexIncoming = this.variables[index].getIDIncoming();
            s[index] = this.variables[index].getProbabilityModel().sample(random, s, indexIncoming);
            ++i;
        }
        return s;
    }

    public void sample(RandomElement random, double[] config, boolean[] fixed) {
        this.topologicalSort();
        int i = 0;
        while (i < this.nVariables) {
            int index = this.order[i];
            Variable var = this.variables[index];
            if (!fixed[index]) {
                double tmp;
                int[] indexIncoming = var.getIDIncoming();
                config[index] = tmp = var.getProbabilityModel().sample(random, config, indexIncoming);
            }
            ++i;
        }
    }

    public boolean testPrediction(double[] configuration) {
        int last = this.nVariables - 1;
        double known = configuration[last];
        double best = 0.0;
        double max = 0.0;
        int[] indexIncoming = this.variables[last].getIDIncoming();
        int i = 0;
        while (i < this.variables[last].getNValues()) {
            double prob = this.variables[last].getProbabilityModel().probability(i, configuration, indexIncoming);
            if (prob > max) {
                max = prob;
                best = i;
            }
            ++i;
        }
        return best == known;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Class network representing a network with " + this.nVariables + " variables and " + this.nEdges + " edges\n");
        int i = 0;
        while (i < this.variables.length) {
            sb.append(String.valueOf(i) + ": " + this.variables[this.order[i]]);
            ++i;
        }
        return sb.toString();
    }

    public String toMFinderFormat() {
        StringBuffer sb = new StringBuffer();
        int counter = 0;
        int[] hash = new int[this.getNVariables()];
        Arrays.fill(hash, -1);
        int i = 0;
        while (i < this.getNVariables()) {
            Variable[] parents;
            Variable v = this.getVariable(i);
            int vID = v.getID();
            if (hash[vID] == -1) {
                hash[vID] = counter++;
            }
            if ((parents = v.getIncoming()) != null) {
                int j = 0;
                while (j < parents.length) {
                    int parentID = parents[j].getID();
                    if (parentID != vID) {
                        if (hash[parentID] == -1) {
                            hash[parentID] = counter++;
                        }
                        sb.append(String.valueOf(hash[parentID]) + "\t" + hash[vID] + "\t1\n");
                    }
                    ++j;
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public boolean train(DataSet dataset) {
        return this.train(dataset, dataset.getAllDatapoints());
    }

    public boolean train(DataSet dataset, int[] datapoints) {
        int i = 0;
        while (i < this.nVariables) {
            int index = this.order[i];
            if (!this.variables[index].getProbabilityModel().train(dataset, datapoints, index, this.variables[index].getIDIncoming())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean violateDAG(int from, int to) {
        if (this.isDirtyTransitiveClosure) {
            this.computeTransitiveClosure();
        }
        return this.transitive[to][from];
    }

    private int[] getChildIndices(int v) {
        ArrayList<Integer> v_children = new ArrayList<Integer>();
        int i = 0;
        while (i < this.nVariables) {
            if (this.incidenceMatrix[v][i]) {
                v_children.add(new Integer(i));
            }
            ++i;
        }
        int[] children = new int[v_children.size()];
        int i2 = 0;
        for (Integer idx : v_children) {
            children[i2++] = idx;
        }
        return children;
    }

    private int[] getParentIndices(int v) {
        ArrayList<Integer> v_parents = new ArrayList<Integer>();
        int i = 0;
        while (i < this.nVariables) {
            if (this.incidenceMatrix[i][v]) {
                v_parents.add(new Integer(i));
            }
            ++i;
        }
        int[] parentes = new int[v_parents.size()];
        int i2 = 0;
        for (Integer idx : v_parents) {
            parentes[i2++] = idx;
        }
        return parentes;
    }

    public int[] getNeighbourIndices(int v) {
        Integer i;
        int[] children = this.getChildIndices(v);
        int[] parentes = this.getParentIndices(v);
        HashSet<Integer> neighbours = new HashSet<Integer>();
        Object object = children;
        int n = 0;
        int n2 = ((int[])object).length;
        while (n < n2) {
            i = object[n];
            neighbours.add(i);
            ++n;
        }
        object = parentes;
        n = 0;
        n2 = ((int[])object).length;
        while (n < n2) {
            i = object[n];
            neighbours.add(i);
            ++n;
        }
        int[] arr = new int[neighbours.size()];
        int i2 = 0;
        object = neighbours.iterator();
        while (object.hasNext()) {
            Integer j = (Integer)object.next();
            arr[i2++] = j;
        }
        return arr;
    }

    private int[] getNeighbourIndicesNoSelf(int v) {
        Integer i;
        int[] children = this.getChildIndices(v);
        int[] parentes = this.getParentIndices(v);
        HashSet<Integer> neighbours = new HashSet<Integer>();
        Object object = children;
        int n = 0;
        int n2 = ((int[])object).length;
        while (n < n2) {
            i = object[n];
            neighbours.add(i);
            ++n;
        }
        object = parentes;
        n = 0;
        n2 = ((int[])object).length;
        while (n < n2) {
            i = object[n];
            neighbours.add(i);
            ++n;
        }
        neighbours.remove(v);
        int[] arr = new int[neighbours.size()];
        int i2 = 0;
        object = neighbours.iterator();
        while (object.hasNext()) {
            Integer j = (Integer)object.next();
            arr[i2++] = j;
        }
        return arr;
    }

    public final double clusteringCoefficient(int v) {
        int L = 0;
        int[] neighbours = this.getNeighbourIndicesNoSelf(v);
        if (neighbours.length == 0 || neighbours.length == 1) {
            return 0.0;
        }
        Arrays.sort(neighbours);
        int i = 0;
        while (i < neighbours.length) {
            int[] next_neighbours = this.getNeighbourIndicesNoSelf(neighbours[i]);
            Arrays.sort(next_neighbours);
            int j = 0;
            while (j < next_neighbours.length) {
                if (Arrays.binarySearch(neighbours, next_neighbours[j]) >= 0) {
                    ++L;
                }
                ++j;
            }
            ++i;
        }
        int k = neighbours.length;
        return 2.0 * (double)(L /= 2) / (double)(k * (k - 1));
    }

    public double clusteringCoefficient() {
        double sum = 0.0;
        int i = 0;
        while (i < this.nVariables) {
            sum += this.clusteringCoefficient(i);
            ++i;
        }
        return sum / (double)this.nVariables;
    }

    public final double clusteringCoefficientWithSelf(int v) {
        int L = 0;
        int[] neighbours = this.getNeighbourIndices(v);
        int k = neighbours.length;
        if (neighbours.length == 0) {
            return 0.0;
        }
        int i = 0;
        while (i < neighbours.length) {
            int j = i;
            while (j < neighbours.length) {
                if (this.isEdge(neighbours[i], neighbours[j]) || this.isEdge(neighbours[j], neighbours[i])) {
                    ++L;
                }
                ++j;
            }
            ++i;
        }
        double max_edges = (double)(k * (k - 1)) / 2.0 + (double)k;
        return (double)L / max_edges;
    }

    public double clusteringCoefficientWithSelf() {
        double sum = 0.0;
        int i = 0;
        while (i < this.nVariables) {
            sum += this.clusteringCoefficientWithSelf(i);
            ++i;
        }
        return sum / (double)this.nVariables;
    }

    public double averageLevelDepth() {
        int[][] W = this.allPairsShortestPaths();
        int sum_level = 0;
        double mean_level = 0.0;
        int top_bottom_pairs_count = 0;
        int i = 0;
        while (i < this.nVariables) {
            if (this.getParentIndices(i).length == 0) {
                int j = 0;
                while (j < this.nVariables) {
                    int l;
                    if (this.getChildIndices(j).length == 0 && (l = W[i][j]) != -1) {
                        sum_level += l;
                        ++top_bottom_pairs_count;
                    }
                    ++j;
                }
            }
            ++i;
        }
        mean_level = (double)sum_level / (double)top_bottom_pairs_count;
        return mean_level;
    }

    public int[][] allPairsShortestPaths() {
        int j;
        int inf = this.nEdges + 1;
        int[][] W = new int[this.nVariables][this.nVariables];
        int i = 0;
        while (i < this.nVariables) {
            j = 0;
            while (j < this.nVariables) {
                W[i][j] = this.isEdge(i, j) ? 1 : inf;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.nVariables) {
            W[i][i] = 0;
            ++i;
        }
        int m = 0;
        while (m < this.nVariables) {
            int x = 0;
            while (x < this.nVariables) {
                int y = 0;
                while (y < this.nVariables) {
                    if (W[x][m] + W[m][y] < W[x][y]) {
                        W[x][y] = W[x][m] + W[m][y];
                    }
                    ++y;
                }
                ++x;
            }
            ++m;
        }
        i = 0;
        while (i < this.nVariables) {
            j = 0;
            while (j < this.nVariables) {
                if (W[i][j] == inf) {
                    W[i][j] = -1;
                }
                ++j;
            }
            ++i;
        }
        return W;
    }

    public int[][] allPairsShortestPathsUndirected() {
        int j;
        int inf = this.nEdges + 1;
        int[][] W = new int[this.nVariables][this.nVariables];
        int i = 0;
        while (i < this.nVariables) {
            j = 0;
            while (j < this.nVariables) {
                W[i][j] = this.isEdge(i, j) || this.isEdge(j, i) ? 1 : inf;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.nVariables) {
            W[i][i] = 0;
            ++i;
        }
        int m = 0;
        while (m < this.nVariables) {
            int x = 0;
            while (x < this.nVariables) {
                int y = 0;
                while (y < this.nVariables) {
                    if (W[x][m] + W[m][y] < W[x][y]) {
                        W[x][y] = W[x][m] + W[m][y];
                    }
                    ++y;
                }
                ++x;
            }
            ++m;
        }
        i = 0;
        while (i < this.nVariables) {
            j = 0;
            while (j < this.nVariables) {
                if (W[i][j] == inf) {
                    W[i][j] = -1;
                }
                ++j;
            }
            ++i;
        }
        return W;
    }

    public double averagePathLength(boolean directed) {
        int sum_distance = 0;
        int count = 0;
        double mean_distance = 0.0;
        int[][] W = directed ? this.allPairsShortestPaths() : this.allPairsShortestPathsUndirected();
        int i = 0;
        while (i < this.nVariables) {
            int j = 0;
            while (j < this.nVariables) {
                int d = W[i][j];
                if (d != -1 && d != 0) {
                    sum_distance += d;
                    ++count;
                }
                ++j;
            }
            ++i;
        }
        mean_distance = (double)sum_distance / (double)count;
        return mean_distance;
    }

    public double getMedianNrOutgoingEdges() {
        DoubleArrayList outgoing = new DoubleArrayList();
        int i = 0;
        while (i < this.getNVariables()) {
            outgoing.add(this.getChildIndices(i).length);
            ++i;
        }
        outgoing.sort();
        return Descriptive.median(outgoing);
    }

    public double getMedianNrIncomingEdges() {
        DoubleArrayList incoming = new DoubleArrayList();
        int i = 0;
        while (i < this.getNVariables()) {
            incoming.add(this.getParentIndices(i).length);
            ++i;
        }
        incoming.sort();
        return Descriptive.median(incoming);
    }

    public double getMaxNrIncomingEdges() {
        DoubleArrayList incoming = new DoubleArrayList();
        int i = 0;
        while (i < this.getNVariables()) {
            incoming.add(this.getParentIndices(i).length);
            ++i;
        }
        incoming.sort();
        return Descriptive.max(incoming);
    }

    public double getAverageNrIncomingEdges() {
        DoubleArrayList incoming = new DoubleArrayList();
        int i = 0;
        while (i < this.getNVariables()) {
            incoming.add(this.getParentIndices(i).length);
            ++i;
        }
        incoming.sort();
        return Descriptive.mean(incoming);
    }

    public double getAverageNrOutgoingEdges() {
        DoubleArrayList outgoing = new DoubleArrayList();
        int i = 0;
        while (i < this.getNVariables()) {
            outgoing.add(this.getChildIndices(i).length);
            ++i;
        }
        outgoing.sort();
        return Descriptive.mean(outgoing);
    }

    public int[][] jointDegreeDistribution() {
        Variable[] nodes = this.getVariables();
        int maxInDegree = 0;
        int maxOutDegree = 0;
        int i = 0;
        while (i < nodes.length) {
            Variable node = nodes[i];
            maxInDegree = Math.max(maxInDegree, node.getNIncoming());
            maxOutDegree = Math.max(maxOutDegree, node.getNOutgoing());
            ++i;
        }
        int[][] degreeDistrib = new int[maxInDegree + 1][maxOutDegree + 1];
        int i2 = 0;
        while (i2 < nodes.length) {
            Variable node = nodes[i2];
            Variable[] parents = node.getIncoming();
            if (parents != null) {
                int j = 0;
                while (j < parents.length) {
                    int degNode = node.getNIncoming();
                    int degParent = parents[j].getNOutgoing();
                    int[] nArray = degreeDistrib[degNode];
                    int n = degParent;
                    nArray[n] = nArray[n] + 1;
                    ++j;
                }
            }
            ++i2;
        }
        return degreeDistrib;
    }

    public String toPajekNet() {
        StringBuffer sb = new StringBuffer();
        sb.append("*Vertices " + this.getNVariables() + "\r\n");
        int i = 0;
        while (i < this.getNVariables()) {
            sb.append(" " + (i + 1) + " \"" + this.getVariable(i).getName() + "\"\r\n");
            ++i;
        }
        int nrArcs = this.getNEdges();
        String[] color = new String[]{"       1 c Red", "       1 c Blue", "       1 c Purple"};
        sb.append("*Arcs " + nrArcs + "\n");
        int i2 = 0;
        while (i2 < this.getNVariables()) {
            int j = 0;
            while (j < this.getNVariables()) {
                if (this.isEdge(i2, j)) {
                    sb.append(" " + (i2 + 1) + " " + (j + 1) + color[2] + "\r\n");
                }
                ++j;
            }
            ++i2;
        }
        return sb.toString();
    }

    public void rewireMaslovSneppen(int steps, RandomElement random) {
        int iteration_limit = steps * 100;
        int iterations = 0;
        int rewirings = 0;
        while (rewirings < steps) {
            int D;
            int B;
            int C;
            int[] Cchildren;
            if (iterations++ > iteration_limit) {
                System.out.println("Warning: MaslovSneppen rewiring did not achieve requested nb of rewirings within iteration limit; aborted");
                System.out.println("Managed " + rewirings + " rewirings.");
                throw new RuntimeException();
            }
            int A = random.choose(0, this.nVariables - 1);
            int[] Achildren = this.getChildIndices(A);
            if (Achildren.length == 0 || (Cchildren = this.getChildIndices(C = random.choose(0, this.nVariables - 1))).length == 0 || this.isEdge(C, B = Achildren[random.choose(0, Achildren.length - 1)]) || this.isEdge(A, D = Cchildren[random.choose(0, Cchildren.length - 1)])) continue;
            this.removeEdge(A, B, new DelInfo());
            this.addEdge(A, D);
            this.removeEdge(C, D, new DelInfo());
            this.addEdge(C, B);
            ++rewirings;
        }
    }
}

