/*
 * Decompiled with CFR 0.152.
 */
package islab.bayesian;

import islab.bayesian.DataSet;
import islab.bayesian.IXMLable;
import islab.lib.RandomElement;

public abstract class ProbabilityModel
implements IXMLable {
    public abstract double probability(double var1, double[] var3, int[] var4);

    public abstract boolean train(DataSet var1, int[] var2, int var3, int[] var4);

    public abstract double sample(RandomElement var1, double[] var2, int[] var3);

    public double nFoldXV(DataSet dataset, int index, int[] indexIncoming, int n, int fold) {
        double ll = 0.0;
        int nObservations = dataset.getNObservations();
        int[] knockouts = dataset.getKnockouts();
        double[][] ddata = dataset.dataset();
        int step = nObservations / n;
        int[] datapoints = new int[nObservations - step];
        int cnt = 0;
        int i = 0;
        while (i < fold * step) {
            datapoints[cnt++] = i++;
        }
        i = (fold + 1) * step;
        while (i < nObservations) {
            datapoints[cnt++] = i++;
        }
        this.train(dataset, datapoints, index, indexIncoming);
        i = 0;
        while (i < step) {
            int d = i + fold * step;
            if (knockouts[d] != index) {
                double x = Math.log(this.probability(ddata[d][index], ddata[d], indexIncoming));
                ll += x;
            }
            ++i;
        }
        return ll;
    }

    public String toXML(String indentString) {
        return this.toXML(1, indentString);
    }

    public abstract String toXML(int var1, String var2);
}

