/*
 * Decompiled with CFR 0.152.
 */
package islab.bayesian;

import cern.jet.random.engine.MersenneTwister;
import islab.lib.RandomElement;
import java.text.NumberFormat;

public class TestGenerator {
    private int nRegressors;
    private int nActive;
    private double[] linear;
    private double a;
    private double c;
    private double d;

    public TestGenerator(int nRegressors, int nActive, RandomElement random) {
        this.nRegressors = nRegressors;
        this.nActive = nActive;
        this.d = random.raw() * 20.0;
        this.c = random.raw() * 100.0;
        System.err.println("c is " + this.c);
        System.err.println("d is " + this.d);
        this.a = 1.0 - 2.0 * random.raw();
        System.err.println("intercept is " + this.a);
        this.linear = new double[nActive];
        int i = 0;
        while (i < nActive) {
            this.linear[i] = 1.0 - 2.0 * random.raw();
            ++i;
        }
    }

    public double objective(double[] regressors) {
        double sum = this.a;
        int i = 0;
        while (i < this.nActive) {
            sum += regressors[i] * this.linear[i];
            ++i;
        }
        return this.d + this.c / (1.0 + Math.exp(-sum));
    }

    public static void main(String[] args) {
        int nRegressors = new Integer(args[0]);
        int nActive = new Integer(args[1]);
        int seed = new Integer(args[2]);
        int datapoints = new Integer(args[3]);
        double stddev = Double.parseDouble(args[4]);
        NumberFormat f = NumberFormat.getInstance();
        f.setMaximumFractionDigits(3);
        f.setMinimumFractionDigits(3);
        System.err.println("nRegressors: " + nRegressors + " active: " + nActive + " seed " + seed + " datapoints " + datapoints + " std of noise: " + stddev);
        MersenneTwister mt = new MersenneTwister(seed);
        TestGenerator tg = new TestGenerator(nRegressors, nActive, new RandomElement(mt));
        double sse = 0.0;
        double[] regressors = new double[nRegressors];
        int i = 0;
        while (i < datapoints) {
            int j = 0;
            while (j < nRegressors) {
                regressors[j] = mt.raw();
                System.out.print(String.valueOf(f.format(regressors[j])) + "\t");
                ++j;
            }
            double target = tg.objective(regressors);
            double noise = new RandomElement(mt).gaussian(stddev);
            System.out.println(f.format(target += noise));
            sse += Math.pow(noise, 2.0);
            ++i;
        }
        System.out.println("SSE=" + sse);
    }
}

