/*
 * Decompiled with CFR 0.152.
 */
package islab.bayesian;

import islab.bayesian.ProbabilityModel;

public class Variable {
    private final int id;
    private int[] idIncoming;
    private Variable[] incoming;
    private double loglikelihood;
    private boolean loglikelihoodValid;
    private String name;
    private int nOutgoing;
    public static final int CONTINUOUS = -1;
    private final int nValues;
    private int[] nValuesIncoming;
    private ProbabilityModel probabilities;
    private int type;
    private char[] valueNames;

    public Variable(int id, int nValues) {
        this(id, "VAR" + id, nValues, null);
    }

    public Variable(int id, String name, int nValues) {
        this(id, name, nValues, null);
    }

    public Variable(int id, String name, int nValues, char[] valueNames) {
        this.nValues = nValues;
        this.id = id;
        this.type = 0;
        this.name = name;
        this.valueNames = valueNames;
        this.probabilities = null;
        this.incoming = null;
        this.nOutgoing = 0;
        this.nValuesIncoming = null;
        this.idIncoming = null;
    }

    public void decNOutgoing() {
        --this.nOutgoing;
    }

    public void decNOutgoing(int n) {
        this.nOutgoing -= n;
    }

    public int getID() {
        return this.id;
    }

    public int[] getIDIncoming() {
        assert (this.isSortedIDIncoming()) : "idincoming not sorted !!";
        return this.idIncoming;
    }

    public int getIDIncoming(int index) {
        return this.idIncoming[index];
    }

    private boolean isSortedIDIncoming() {
        if (this.idIncoming == null) {
            return true;
        }
        int min = -1;
        int i = 0;
        while (i < this.idIncoming.length) {
            if (this.idIncoming[i] < min) {
                return false;
            }
            min = this.idIncoming[i];
            ++i;
        }
        return true;
    }

    public Variable[] getIncoming() {
        return this.incoming;
    }

    public Variable getIncoming(int index) {
        return this.incoming[index];
    }

    public double getLogLikelihood() {
        return this.loglikelihood;
    }

    public String getName() {
        return this.name;
    }

    public int getNIncoming() {
        if (this.incoming == null) {
            return 0;
        }
        return this.incoming.length;
    }

    public int getNOutgoing() {
        return this.nOutgoing;
    }

    public int getNValues() {
        return this.nValues;
    }

    public int[] getNValuesIncoming() {
        return this.nValuesIncoming;
    }

    public ProbabilityModel getProbabilityModel() {
        return this.probabilities;
    }

    public int getType() {
        return this.type;
    }

    public char getValueName(int value) {
        return this.valueNames[value];
    }

    public void incNOutgoing() {
        ++this.nOutgoing;
    }

    public void incNOutgoing(int n) {
        this.nOutgoing += n;
    }

    public boolean isLogLikelihoodValid() {
        return this.loglikelihoodValid;
    }

    public void setIncoming(int index, Variable var) {
        this.incoming[index] = var;
        this.nValuesIncoming[index] = var.getNValues();
        this.idIncoming[index] = var.getID();
    }

    public void setIncoming(Variable[] incoming, int[] nValuesIncoming, int[] idIncoming) {
        this.incoming = incoming;
        this.nValuesIncoming = nValuesIncoming;
        this.idIncoming = idIncoming;
    }

    public void setLogLikelihood(double v) {
        this.loglikelihood = v;
        this.validateLoglikelihood(true);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNIncoming(int nIncoming) {
        if (nIncoming > 0) {
            this.incoming = new Variable[nIncoming];
            this.nValuesIncoming = new int[nIncoming];
            this.idIncoming = new int[nIncoming];
        } else {
            this.incoming = null;
            this.nValuesIncoming = null;
            this.idIncoming = null;
        }
    }

    public void setNOutgoing(int n) {
        this.nOutgoing = n;
    }

    public void setProbabilityModel(ProbabilityModel probabilities) {
        this.probabilities = probabilities;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setValueNames(char[] valueNames) {
        this.valueNames = valueNames;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("variable " + this.name + " (ID " + this.id + ") -- ");
        if (this.nValues == -1) {
            sb.append("continuous, ");
        } else {
            sb.append(String.valueOf(this.nValues) + " values, ");
        }
        if (this.incoming == null) {
            sb.append("no incoming edges");
        } else {
            sb.append(String.valueOf(this.incoming.length) + " incoming edge(s) (");
            int i = 0;
            while (i < this.idIncoming.length) {
                sb.append(" " + this.idIncoming[i]);
                ++i;
            }
            sb.append(")");
        }
        sb.append(" nOut=" + this.getNOutgoing() + " type=" + this.getType());
        return String.valueOf(sb.toString()) + "\n";
    }

    public void validateLoglikelihood(boolean valid) {
        this.loglikelihoodValid = valid;
    }
}

