/*
 * Decompiled with CFR 0.152.
 */
package islab.bayesian;

import cern.jet.random.Uniform;
import islab.bayesian.DataSet;
import islab.bayesian.ProbabilityModel;
import islab.lib.RandomElement;
import islab.lib.XmlHelper;
import islab.lib.XmlXomReader;
import nu.xom.Document;
import nu.xom.Element;
import org.xml.sax.SAXParseException;

public class WhiteNoise
extends ProbabilityModel {
    private RandomElement random;
    private Uniform uniform;
    private double lowerBound;
    private double upperBound;

    public WhiteNoise(double lowerBound, double upperBound, RandomElement randomGen) {
        this.random = randomGen;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.uniform = new Uniform(lowerBound, upperBound, this.random.getRandomEngine());
    }

    public double probability(double value, double[] configuration, int[] indexIncoming) {
        throw new RuntimeException("not implemented");
    }

    public double sample(RandomElement random, double[] configuration, int[] indexIncoming) {
        return this.uniform.nextDouble();
    }

    public boolean train(DataSet dataset, int[] indices, int index, int[] indexIncoming) {
        throw new RuntimeException("WhiteNoise.train() not implemented.");
    }

    public String toString() {
        return " WhiteNoise(lower=" + this.lowerBound + ", upper=" + this.upperBound + ")";
    }

    public String toXML(int indentLevel, String indentString) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < indentLevel) {
            sb.append(indentString);
            ++i;
        }
        String indent = sb.toString();
        sb = new StringBuffer();
        sb.append(String.valueOf(indent) + "<ProbabilityModel type=\"WhiteNoise\">\n");
        sb.append(String.valueOf(indent) + "  <lowerBound>" + this.lowerBound + "</lowerBound>\n");
        sb.append(String.valueOf(indent) + "  <upperBound>" + this.upperBound + "</upperBound>\n");
        sb.append(String.valueOf(indent) + "</ProbabilityModel>");
        return sb.toString();
    }

    public static WhiteNoise fromXML(RandomElement randomGen, String xml) throws SAXParseException {
        try {
            Document dom = XmlXomReader.getDocument(xml);
            Element xmlNode = dom.getRootElement();
            if (!xmlNode.getLocalName().equals("ProbabilityModel") || !xmlNode.getAttribute("type").getValue().toString().equals("WhiteNoise")) {
                throw new SAXParseException("Error parsing xml: expected <ProbabilityModel type=\"WhiteNoise\">, but received <" + xmlNode.getLocalName() + " type=\"" + xmlNode.getAttribute("type").getValue() + "\"", null);
            }
            double lower = XmlHelper.getDouble(xmlNode, "lowerBound");
            double upper = XmlHelper.getDouble(xmlNode, "upperBound");
            WhiteNoise wn = new WhiteNoise(lower, upper, randomGen);
            return wn;
        }
        catch (Exception ex) {
            throw new SAXParseException("Error parsing xml string: " + ex.getMessage(), null);
        }
    }
}

