/*
 * Decompiled with CFR 0.152.
 */
package islab.bayesian;

import cern.jet.random.engine.MersenneTwister;
import islab.bayesian.DataSet;
import islab.bayesian.IProvideMean;
import islab.lib.RandomElement;
import islab.lib.XmlHelper;
import islab.lib.XmlXomReader;
import java.util.GregorianCalendar;
import nu.xom.Document;
import nu.xom.Element;
import org.xml.sax.SAXParseException;

public class WhiteNoiseModel
implements IProvideMean {
    private double lowerBound;
    private double upperBound;
    private RandomElement random;

    public WhiteNoiseModel(double lower, double upper, RandomElement random) {
        this.lowerBound = lower;
        this.upperBound = upper;
        this.random = random;
    }

    public final void setUpper(double upper) {
        this.upperBound = upper;
    }

    public final void setLower(double lower) {
        this.lowerBound = lower;
    }

    public final double getUpper() {
        return this.upperBound;
    }

    public final double getLower() {
        return this.lowerBound;
    }

    public double computeMean(double[] configuration, int[] indexIncoming) {
        return this.random.uniform(this.lowerBound, this.upperBound);
    }

    public boolean train(DataSet dataset, int[] indices, int index, int[] indexIncoming) {
        throw new RuntimeException("train() not implemented for ConstantModel");
    }

    public String toXML(String indentString) {
        StringBuffer sb = new StringBuffer(String.valueOf(indentString) + "<IProvideMean type=\"WhiteNoiseModel\">\n");
        sb.append(String.valueOf(indentString) + "  " + XmlHelper.tag("lowerBound", this.lowerBound) + "\n");
        sb.append(String.valueOf(indentString) + "  " + XmlHelper.tag("upperBound", this.upperBound) + "\n");
        sb.append("</IProvideMean>");
        return sb.toString();
    }

    public static WhiteNoiseModel fromXML(String xml) throws SAXParseException {
        Document dom = XmlXomReader.getDocument(xml);
        Element xmlNode = dom.getRootElement();
        if (!xmlNode.getLocalName().equals("IProvideMean") || !xmlNode.getAttribute("type").getValue().toString().equals("WhiteNoiseModel")) {
            throw new SAXParseException("Error parsing xml: expected <IProvideMean type=\"WhiteNoiseModel\">, but received <" + xmlNode.getLocalName() + " type=\"" + xmlNode.getAttribute("type").getValue() + "\"", null);
        }
        double lowerBound = XmlHelper.getDouble(xmlNode, "lowerBound");
        double upperBound = XmlHelper.getDouble(xmlNode, "upperBound");
        return new WhiteNoiseModel(lowerBound, upperBound, new RandomElement(new MersenneTwister(new GregorianCalendar().getTime())));
    }
}

