/*
 * Decompiled with CFR 0.152.
 */
package islab.bayesian.genenetwork;

public final class EdgeType {
    private String name;
    private String abbrev;
    public static final EdgeType UNKNOWN = new EdgeType("unknown", "U");
    public static final EdgeType ACTIVATOR = new EdgeType("activator", "A");
    public static final EdgeType REPRESSOR = new EdgeType("repressor", "R");
    public static final EdgeType[] edgeType = new EdgeType[]{UNKNOWN, ACTIVATOR, REPRESSOR};

    private EdgeType(String name, String abbrev) {
        this.name = name;
        this.abbrev = abbrev;
    }

    public EdgeType(String name) {
        this.name = name;
        this.abbrev = name.substring(0, 1).toUpperCase();
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public String getAbbreviation() {
        return this.abbrev;
    }

    public boolean equals(Object o) {
        if (o instanceof EdgeType) {
            EdgeType o2 = (EdgeType)o;
            if (this.getName().equals(o2.getName()) && this.getAbbreviation().equals(o2.getAbbreviation())) {
                return true;
            }
        }
        return false;
    }
}

