/*
 * Decompiled with CFR 0.152.
 */
package islab.bayesian.genenetwork;

import cern.jet.random.engine.RandomEngine;
import cern.jet.random.sampling.RandomSampler;
import islab.bayesian.ConstantModel;
import islab.bayesian.IProvideMean;
import islab.bayesian.IProvideMeanFactory;
import islab.bayesian.IXMLable;
import islab.bayesian.IncidenceMatrix;
import islab.bayesian.LognormalNoise;
import islab.bayesian.Network;
import islab.bayesian.Variable;
import islab.bayesian.genenetwork.CreateNetworkException;
import islab.bayesian.genenetwork.Edge;
import islab.bayesian.genenetwork.EdgeType;
import islab.bayesian.genenetwork.InteractionType;
import islab.bayesian.genenetwork.Node;
import islab.bayesian.genenetwork.NodeType;
import islab.bayesian.genenetwork.generation.ExternalNodeNotFoundException;
import islab.lib.RandomElement;
import islab.lib.XmlSerializer;
import islab.lib.XmlXomReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Scanner;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import org.apache.commons.math.random.RandomDataImpl;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneNetwork
implements IXMLable {
    static final int NVAL = -1;
    public static final int UNKNOWN = 0;
    public static final int REG = 1;
    public static final int EXT = 2;
    public static final int OUT = 3;
    protected ArrayList nodes;
    protected ArrayList edges;
    private int[] correlatedWith;
    private double[] slopes;
    private double correlationNoiseSD;

    public GeneNetwork() {
        this.nodes = new ArrayList();
        this.edges = new ArrayList();
        this.correlatedWith = new int[0];
        this.slopes = new double[0];
    }

    public GeneNetwork(ArrayList nodes) {
        this.nodes = nodes;
        this.edges = new ArrayList();
        this.correlatedWith = new int[0];
        this.slopes = new double[0];
    }

    public int getNVariables() {
        return this.nodes.size();
    }

    public int getNExternalConditions() {
        return this.getNodes(NodeType.EXTERNAL_CONDITION).size();
    }

    public int getNNodes() {
        return this.nodes.size();
    }

    public int getNEdges() {
        int cnt = 0;
        int i = 0;
        while (i < this.nodes.size()) {
            Node r = (Node)this.nodes.get(i);
            cnt += r.getChildren().size();
            ++i;
        }
        return cnt;
    }

    public ArrayList getNodes() {
        return this.nodes;
    }

    public void addEdgeInfo(Node from, Node to, EdgeType et) {
        this.edges.add(new Edge(from, to, et));
    }

    public EdgeType getEdgeInfo(Node from, Node to) {
        int i = 0;
        while (i < this.edges.size()) {
            Edge e = (Edge)this.edges.get(i);
            if (e.getFromNode() == from && e.getToNode() == to) {
                return e.getEdgeType();
            }
            ++i;
        }
        return EdgeType.UNKNOWN;
    }

    public void setEdgeInfo(Node from, Node to, EdgeType et) {
        int i = 0;
        while (i < this.edges.size()) {
            Edge e = (Edge)this.edges.get(i);
            if (e.getFromNode() == from && e.getToNode() == to) {
                e.setEdgeType(et);
            }
            ++i;
        }
    }

    public Node getNode(int index) {
        int i = 0;
        while (i < this.nodes.size()) {
            Node r = (Node)this.nodes.get(i);
            if (r.getIndex() == index) {
                return r;
            }
            ++i;
        }
        return null;
    }

    public boolean isDirectedEdge(Node from, Node to) {
        return to.getParents().contains(from);
    }

    public final void addNode(Node node) {
        if (!this.nodes.contains(node)) {
            this.nodes.add(node);
        }
    }

    public void addDirectedEdge(Node parent, Node child) {
        this.addNode(parent);
        this.addNode(child);
        parent.addChild(child);
        child.addParent(parent);
    }

    public void removeDirectedEdge(Node parent, Node child) {
        parent.removeChild(child);
        child.removeParent(parent);
    }

    public void addEdge(String xml) throws SAXParseException {
        Document dom = XmlXomReader.getDocument(xml);
        Element root = dom.getRootElement();
        if (!root.getLocalName().equals("Edge")) {
            throw new SAXParseException("<Edge> node not found", null);
        }
        try {
            int from = Integer.parseInt(root.getFirstChildElement("from").getValue());
            int to = Integer.parseInt(root.getFirstChildElement("to").getValue());
            this.addDirectedEdge(this.getNode(from), this.getNode(to));
        }
        catch (NumberFormatException ex) {
            throw new SAXParseException(ex.getMessage(), null);
        }
    }

    public void renumber(int base) {
        int i = 0;
        while (i < this.nodes.size()) {
            Node r = (Node)this.nodes.get(i);
            r.setIndex(r.getIndex() + base);
            ++i;
        }
    }

    public Network getEmptyNetwork() {
        return this.getEmptyNetwork(-1);
    }

    public Network getEmptyNetwork(int nVariables) {
        if (nVariables == -1) {
            nVariables = this.getNVariables();
        }
        Variable[] variables = new Variable[nVariables];
        int i = 0;
        while (i < this.nodes.size()) {
            Node n = (Node)this.nodes.get(i);
            variables[i] = new Variable(n.getIndex(), n.toString(), -1);
            variables[i].setType(1);
            ++i;
        }
        i = 0;
        while (i < nVariables) {
            if (variables[i] == null) {
                variables[i] = new Variable(i, "I" + i, -1);
                variables[i].setType(0);
            }
            ++i;
        }
        return new Network(variables);
    }

    public Network toNetwork() {
        return this.toNetwork(-1);
    }

    public Network toNetwork(int nVariables) {
        Network bn = this.getEmptyNetwork(nVariables);
        int i = 0;
        while (i < this.nodes.size()) {
            Node r = (Node)this.nodes.get(i);
            int rIndex = r.getIndex();
            Variable v = bn.getVariable(i);
            v.setName(r.getName());
            v.setProbabilityModel(r.getProbabilityModel());
            ArrayList parents = r.getParents();
            int j = 0;
            while (j < parents.size()) {
                Node n = (Node)parents.get(j);
                int indexN = n.getIndex();
                bn.addEdge(indexN, rIndex);
                ++j;
            }
            ++i;
        }
        return bn;
    }

    public void integrityCheck() {
        int i = 0;
        while (i < this.getNNodes()) {
            Node n = this.getNode(i);
            if (n.getIndex() != i) {
                throw new RuntimeException("Integrity check failed at node " + i);
            }
            ++i;
        }
    }

    public void toSIF(PrintWriter out) {
        this.toSIF(out, null);
    }

    public void toSIF(PrintWriter out, Network nw) {
        if (nw == null) {
            nw = this.toNetwork();
        }
        int i = 0;
        while (i < nw.getNVariables()) {
            Variable v = nw.getVariable(nw.getDirectOrder(i));
            if (v.getNIncoming() != 0) {
                Node r = this.getNode(nw.getDirectOrder(i));
                ArrayList parents = r.getParents();
                int j = 0;
                while (j < parents.size()) {
                    EdgeType t = this.getEdgeInfo((Node)parents.get(j), r);
                    String sn = t == EdgeType.ACTIVATOR ? "ac" : (t == EdgeType.REPRESSOR ? "re" : "un");
                    out.println(String.valueOf(((Node)parents.get(j)).getName()) + " " + sn + " " + r.getName());
                    ++j;
                }
                out.flush();
            }
            ++i;
        }
    }

    public String toSIF() {
        Network nw = this.toNetwork();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < nw.getNVariables()) {
            Variable v = nw.getVariable(nw.getDirectOrder(i));
            if (v.getNIncoming() != 0) {
                Node r = this.getNode(nw.getDirectOrder(i));
                ArrayList parents = r.getParents();
                int j = 0;
                while (j < parents.size()) {
                    EdgeType t = this.getEdgeInfo((Node)parents.get(j), r);
                    String sn = t == EdgeType.ACTIVATOR ? "ac" : (t == EdgeType.REPRESSOR ? "re" : "un");
                    sb.append(String.valueOf(((Node)parents.get(j)).getName()) + " " + sn + " " + r.getName() + "\n");
                    ++j;
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public int getNNodes(NodeType type) {
        int cntr = 0;
        int i = 0;
        while (i < this.nodes.size()) {
            if (((Node)this.nodes.get(i)).getNodeType() == type) {
                ++cntr;
            }
            ++i;
        }
        return cntr;
    }

    public ArrayList getNodes(NodeType type) {
        ArrayList<Node> l = new ArrayList<Node>();
        int i = 0;
        while (i < this.nodes.size()) {
            Node n = (Node)this.nodes.get(i);
            if (n.getNodeType().equals(type)) {
                l.add(n);
            }
            ++i;
        }
        return l;
    }

    public ArrayList getTopNodes() {
        ArrayList nodes = this.getNodes();
        ArrayList<Node> topNodes = new ArrayList<Node>();
        int i = 0;
        while (i < nodes.size()) {
            Node n = (Node)nodes.get(i);
            if (n.getParents().size() == 0) {
                topNodes.add(n);
            } else {
                boolean flgSelfLoop = true;
                int k = 0;
                while (k < n.getParents().size()) {
                    if (!n.getParents().get(k).equals(n)) {
                        flgSelfLoop = false;
                        break;
                    }
                    ++k;
                }
                if (flgSelfLoop) {
                    topNodes.add(n);
                }
            }
            ++i;
        }
        return topNodes;
    }

    public int getNRegulators() {
        return this.getNNodes(NodeType.REGULATOR);
    }

    public ArrayList getRegulators() {
        return this.getNodes(NodeType.REGULATOR);
    }

    public int getNOutputs() {
        return this.getNNodes(NodeType.OUTPUT);
    }

    public ArrayList getOutputs() {
        return this.getNodes(NodeType.OUTPUT);
    }

    public Map getCorrelatedExternal() {
        HashMap<Node, Node> m = new HashMap<Node, Node>();
        ArrayList ext = this.getNodes(NodeType.EXTERNAL_CONDITION);
        int i = 0;
        while (i < ext.size()) {
            if (this.correlatedWith[i] >= 0) {
                Node t = (Node)ext.get(this.correlatedWith[i]);
                Node n = (Node)ext.get(i);
                m.put(n, t);
            }
            ++i;
        }
        return m;
    }

    public void setNodeIntervention(int i, double mean, double sdev, RandomElement rndGen) {
        Node node = this.getNode(i);
        node.setInteractionType(new InteractionType("intervention_" + i, new LognormalNoise(rndGen, new ConstantModel(mean), sdev, node)));
    }

    public void sortNodesTopological() {
        if (!this.toNetwork().isDAG()) {
            throw new RuntimeException("sortNodesTopological() can only be applied to DAG for now");
        }
        ArrayList<Node> sortedNodes = new ArrayList<Node>(this.getNNodes());
        int[] inDegree = new int[this.getNNodes()];
        int i = 0;
        while (i < inDegree.length) {
            inDegree[i] = 0;
            ++i;
        }
        i = 0;
        while (i < this.getNNodes()) {
            int n = i;
            inDegree[n] = inDegree[n] + this.getNode(i).getParents().size();
            ++i;
        }
        LinkedList<Node> queue = new LinkedList<Node>();
        int i2 = 0;
        while (i2 < inDegree.length) {
            if (inDegree[i2] == 0) {
                queue.add(this.getNode(i2));
            }
            ++i2;
        }
        while (!queue.isEmpty()) {
            Node n = (Node)queue.removeFirst();
            sortedNodes.add(n);
            int j = 0;
            while (j < n.getChildren().size()) {
                Node to = (Node)n.getChildren().get(j);
                int n2 = to.getIndex();
                inDegree[n2] = inDegree[n2] - 1;
                if (inDegree[n2] == 0) {
                    queue.add(to);
                }
                ++j;
            }
        }
        this.nodes = sortedNodes;
        i = 0;
        while (i < this.nodes.size()) {
            Node r = (Node)this.nodes.get(i);
            r.setIndex(i);
            ++i;
        }
    }

    public String toXML() {
        return this.toXML("");
    }

    @Override
    public String toXML(String indentString) {
        return XmlSerializer.getDefaultSerializer().toXML(this);
    }

    public static GeneNetwork fromXMLFile(RandomElement randomGen, String xmlFile) throws SAXParseException, IOException {
        try {
            FileReader f = new FileReader(xmlFile);
            return (GeneNetwork)XmlSerializer.getDefaultSerializer().fromXML(f);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static GeneNetwork fromXMLFilev1_1_3(RandomElement randomGen, String xmlFile) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(xmlFile));
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            while ((line = br.readLine()) != null) {
                pw.println(line);
            }
            br.close();
            String xml = sw.toString();
            return GeneNetwork.fromXMLv1_1_3(randomGen, xml);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (SAXParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static GeneNetwork fromXML(RandomElement randomGen, String xml) {
        GeneNetwork gn = (GeneNetwork)XmlSerializer.getDefaultSerializer().fromXML(xml);
        gn.integrityCheck();
        gn.renumber(0);
        return gn;
    }

    public static GeneNetwork fromXMLv1_1_3(RandomElement randomGen, String xml) throws SAXParseException {
        Element e;
        Document dom = XmlXomReader.getDocument(xml);
        Element root = dom.getRootElement();
        GeneNetwork gn = new GeneNetwork();
        if (!root.getLocalName().equals("GeneNetwork")) {
            throw new SAXParseException("<GeneNetwork> node not found", null);
        }
        Elements nodes = null;
        Elements edges = null;
        Elements correlations = null;
        try {
            nodes = root.getFirstChildElement("Nodes").getChildElements();
            edges = root.getFirstChildElement("Edges").getChildElements();
            correlations = root.getFirstChildElement("Correlations").getChildElements();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (nodes == null) {
            nodes = root.getChildElements("Node");
        }
        if (nodes != null) {
            int i = 0;
            while (i < nodes.size()) {
                e = nodes.get(i);
                if (!e.getLocalName().equals("Node")) {
                    throw new SAXParseException("<Nodes> has an illegal child node (expected <Node>): " + e.getLocalName(), null);
                }
                gn.addNode(Node.fromXML(gn, randomGen, e.toXML()));
                ++i;
            }
        }
        if (edges != null) {
            int i = 0;
            while (i < edges.size()) {
                e = edges.get(i);
                if (!e.getLocalName().equals("Edge")) {
                    throw new SAXParseException("<Edges> has an illegal child node: " + e.getLocalName(), null);
                }
                gn.addEdge(e.toXML());
                ++i;
            }
        }
        int[] correlatedWith = new int[gn.getNExternalConditions()];
        Arrays.fill(correlatedWith, -1);
        double[] slopes = new double[gn.getNExternalConditions()];
        double correlationNoise = 0.0;
        if (correlations != null) {
            int i = 0;
            while (i < correlations.size()) {
                Element e2 = correlations.get(i);
                if (e2.getLocalName().equals("CorrelationPair")) {
                    int idx = Integer.parseInt(e2.getAttributeValue("target"));
                    int src = Integer.parseInt(e2.getAttributeValue("source"));
                    double slope = Double.parseDouble(e2.getAttributeValue("slope"));
                    correlatedWith[idx] = src;
                    slopes[idx] = slope;
                } else if (e2.getLocalName().equals("CorrelationNoise")) {
                    correlationNoise = Double.parseDouble(e2.getAttributeValue("value"));
                } else {
                    throw new SAXParseException("<Correlations> has an illegal child node: " + e2.getLocalName(), null);
                }
                ++i;
            }
        }
        gn.setCorrExtCond(correlatedWith, slopes, correlationNoise);
        gn.integrityCheck();
        gn.renumber(0);
        return gn;
    }

    public static GeneNetwork fromIncidenceMatrix(IncidenceMatrix im, RandomElement rnd) {
        return GeneNetwork.fromIncidenceMatrix(im, false, 0.0, 0.0, rnd);
    }

    public static GeneNetwork fromIncidenceMatrix(IncidenceMatrix im, boolean randomizeInteractions, double noiseStddev, double higherOrderProbability, RandomElement randomGen) {
        GeneNetwork gn = new GeneNetwork();
        int i = 0;
        while (i < im.getNrNodes()) {
            Node n = new Node(gn, i);
            n.setName(im.getName(i));
            gn.addNode(n);
            ++i;
        }
        i = 0;
        while (i < im.getNrNodes()) {
            int j = 0;
            while (j < im.getNrNodes()) {
                switch (im.get(i, j)) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        gn.addDirectedEdge(gn.getNode(i), gn.getNode(j));
                        gn.addEdgeInfo(gn.getNode(i), gn.getNode(j), EdgeType.ACTIVATOR);
                        break;
                    }
                    case 2: {
                        gn.addDirectedEdge(gn.getNode(i), gn.getNode(j));
                        gn.addEdgeInfo(gn.getNode(i), gn.getNode(j), EdgeType.REPRESSOR);
                        break;
                    }
                    case 3: {
                        gn.addDirectedEdge(gn.getNode(i), gn.getNode(j));
                        if (randomGen.uniform(0.0, 1.0) < 0.5) {
                            gn.addEdgeInfo(gn.getNode(i), gn.getNode(j), EdgeType.ACTIVATOR);
                            break;
                        }
                        gn.addEdgeInfo(gn.getNode(i), gn.getNode(j), EdgeType.REPRESSOR);
                        break;
                    }
                }
                ++j;
            }
            ++i;
        }
        gn.integrityCheck();
        if (randomizeInteractions) {
            i = 0;
            while (i < gn.getNNodes()) {
                Node node = gn.getNode(i);
                IProvideMean ipm = IProvideMeanFactory.createRandomIPM(node, node.getName(), higherOrderProbability, randomGen);
                LognormalNoise pm = new LognormalNoise(randomGen, ipm, noiseStddev, node);
                InteractionType type = new InteractionType("random_" + i, pm);
                node.setInteractionType(type);
                ++i;
            }
        }
        return gn;
    }

    public void randomizeExternalConditions(RandomElement rndGen) {
        ArrayList ext = this.getNodes(NodeType.EXTERNAL_CONDITION);
        int i = 0;
        while (i < ext.size()) {
            if (this.correlatedWith[i] < 0) {
                Node n = (Node)ext.get(i);
                n.setRandomExternal(rndGen);
            }
            ++i;
        }
        i = 0;
        while (i < ext.size()) {
            if (this.correlatedWith[i] >= 0) {
                Node t = (Node)ext.get(this.correlatedWith[i]);
                Node n = (Node)ext.get(i);
                n.setCorrelatedExternal(rndGen, t, this.slopes[i], this.correlationNoiseSD);
            }
            ++i;
        }
    }

    public void setExternalConditions(RandomElement rndGen, double inputNoiseStddev, HashMap<String, Double> values) throws ExternalNodeNotFoundException {
        ArrayList ext = this.getNodes(NodeType.EXTERNAL_CONDITION);
        int i = 0;
        while (i < ext.size()) {
            Node n = (Node)ext.get(i);
            if (!values.containsKey(n.getName())) {
                throw new ExternalNodeNotFoundException("External node " + n.getName() + " from GeneNetwork is not defined in external nodes file");
            }
            double value = values.get(n.getName());
            n.setExternal(rndGen, value, inputNoiseStddev);
            ++i;
        }
        if (ext.size() != values.size()) {
            throw new ExternalNodeNotFoundException("The external nodes file contains nodes not defined as 'external' in GeneNetwork");
        }
    }

    public void randomizeExternalConditions(RandomElement rndGen, double inputNoiseStddev) {
        ArrayList ext = this.getNodes(NodeType.EXTERNAL_CONDITION);
        int i = 0;
        while (i < ext.size()) {
            if (this.correlatedWith[i] < 0) {
                Node n = (Node)ext.get(i);
                n.setRandomExternal(rndGen, inputNoiseStddev);
            }
            ++i;
        }
        i = 0;
        while (i < ext.size()) {
            if (this.correlatedWith[i] >= 0) {
                Node t = (Node)ext.get(this.correlatedWith[i]);
                Node n = (Node)ext.get(i);
                n.setCorrelatedExternal(rndGen, t, this.slopes[i], this.correlationNoiseSD);
            }
            ++i;
        }
    }

    public void setCorrExtCond(RandomElement rndGen, int nCorr, double correlationNoiseStddev) {
        int nExt = this.getNExternalConditions();
        assert (nCorr >= 0 && nCorr <= (nExt > 0 ? nExt - 1 : 0)) : "check nr correlated";
        long[] corr = new long[nCorr];
        RandomSampler.sample(nCorr, nExt, nCorr, 0L, corr, 0, rndGen.getRandomEngine());
        Integer[] correlated = new Integer[nCorr];
        int i = 0;
        while (i < correlated.length) {
            correlated[i] = (int)corr[i];
            ++i;
        }
        int nMaster = nExt - nCorr;
        ArrayList<Integer> e = new ArrayList<Integer>(nExt);
        int i2 = 0;
        while (i2 < nExt) {
            e.add(i2, i2);
            ++i2;
        }
        e.removeAll((Collection)Arrays.asList(correlated));
        Integer[] master = e.toArray(new Integer[nMaster]);
        int[] correlatedWith = new int[nExt];
        Arrays.fill(correlatedWith, -1);
        int j = 0;
        while (j < nCorr) {
            correlatedWith[correlated[j].intValue()] = master[rndGen.choose(nMaster) - 1];
            ++j;
        }
        double[] slope_choices = new double[]{-1.0, 1.0};
        double[] slopes = new double[nExt];
        int j2 = 0;
        while (j2 < nCorr) {
            slopes[correlated[j2].intValue()] = slope_choices[rndGen.choose(2) - 1];
            ++j2;
        }
        this.setCorrExtCond(correlatedWith, slopes, correlationNoiseStddev);
    }

    public void setCorrExtCond(int[] correlatedWith, double[] slopes, double correlationNoiseStddev) {
        if (correlatedWith.length != slopes.length) {
            throw new RuntimeException("assertion error on lengths");
        }
        if (slopes.length != this.getNExternalConditions()) {
            throw new RuntimeException("assertion error on lengths");
        }
        int i = 0;
        while (i < slopes.length) {
            if (correlatedWith[i] >= 0) {
                if (correlatedWith[correlatedWith[i]] < 0) {
                    if (slopes[i] != 1.0 && slopes[i] != -1.0) {
                        throw new RuntimeException("slope can only be 1 or -1");
                    }
                } else {
                    throw new RuntimeException("external input has to be correlated with another one that is not correlated at all");
                }
            }
            ++i;
        }
        this.correlatedWith = correlatedWith;
        this.slopes = slopes;
        this.correlationNoiseSD = correlationNoiseStddev;
    }

    public void setRandomMaxExpressionValues(RandomEngine rnd) {
        this.setRandomMaxExpressionValues(5.0, 1.8, rnd);
    }

    public void setRandomMaxExpressionValues(double mu, double sigma, RandomEngine rnd) {
        RandomDataImpl rndData = new RandomDataImpl();
        for (Object n : this.getNodes()) {
            Node node = (Node)n;
            node.setMaxExpression(rndData.nextExponential(5000.0));
        }
    }

    public ArrayList convertToDAG() {
        ArrayList<int[]> backEdges = new ArrayList<int[]>();
        int[] backEdge = this.getOneBackEdge();
        while (backEdge[0] != -1 && backEdge[1] != -1) {
            backEdges.add(backEdge);
            this.removeDirectedEdge(this.getNode(backEdge[0]), this.getNode(backEdge[1]));
            backEdge = this.getOneBackEdge();
        }
        return backEdges;
    }

    public int[] getOneBackEdge() {
        int u = 0;
        while (u < this.getNNodes()) {
            Node n = this.getNode(u);
            if (this.isDirectedEdge(n, n)) {
                return new int[]{u, u};
            }
            ++u;
        }
        ArrayList<String> color = new ArrayList<String>();
        ArrayList<Object> pred = new ArrayList<Object>();
        int u2 = 0;
        while (u2 < this.getNNodes()) {
            color.add("white");
            pred.add(null);
            ++u2;
        }
        u2 = 0;
        while (u2 < this.getNNodes()) {
            int[] backEdge;
            if (color.get(u2).equals("white") && ((backEdge = this.visit(u2, color, pred))[0] != -1 || backEdge[1] != -1)) {
                return backEdge;
            }
            ++u2;
        }
        return new int[]{-1, -1};
    }

    private int[] visit(int u, ArrayList color, ArrayList pred) {
        color.set(u, "gray");
        ArrayList<Node> adj = new ArrayList<Node>();
        int i = 0;
        while (i < this.getNVariables()) {
            if (this.isDirectedEdge(this.getNode(u), this.getNode(i))) {
                adj.add(this.getNode(i));
            }
            ++i;
        }
        int t = 0;
        while (t < adj.size()) {
            int v = ((Node)adj.get(t)).getIndex();
            if (color.get(v).equals("white")) {
                pred.set(v, new Integer(u));
                int[] tmp = this.visit(v, color, pred);
                if (tmp[0] != -1 || tmp[1] != -1) {
                    return tmp;
                }
            } else if (pred.get(u) != null && v != (Integer)pred.get(u)) {
                return new int[]{u, v};
            }
            ++t;
        }
        return new int[]{-1, -1};
    }

    @Deprecated
    public static Object[] createRandomizedGNfromSIFFile(String sifFile, int nrNodes, int nrBackgroundNodes, int nrExternal, int nrCorr, double noiseStddev, double correlationNoiseStddev, double higherOrderProbability, String subgraphSelection, RandomElement rndGen) throws CreateNetworkException {
        if (nrExternal == -1 && nrCorr != -1) {
            throw new CreateNetworkException("check nr of correlated");
        }
        return GeneNetwork.createRandomizedGNfromSIFFile(sifFile, nrNodes, "", nrBackgroundNodes, nrExternal, nrCorr, noiseStddev, correlationNoiseStddev, higherOrderProbability, subgraphSelection, rndGen);
    }

    @Deprecated
    public static Object[] createRandomizedGNfromSIFFile(String sifFile, int nrNodes, int nrBackgroundNodes, int nrExternal, double noiseStddev, double correlationNoiseStddev, double higherOrderProbability, String subgraphSelection, RandomElement rndGen) throws CreateNetworkException {
        int nrCorr = nrExternal == -1 ? -1 : 0;
        return GeneNetwork.createRandomizedGNfromSIFFile(sifFile, nrNodes, "", nrBackgroundNodes, nrExternal, nrCorr, noiseStddev, correlationNoiseStddev, higherOrderProbability, subgraphSelection, rndGen);
    }

    @Deprecated
    public static Object[] createRandomizedGNfromSIFFile(String sifFile, int nrNodes, String startNode, int nrBackgroundNodes, int nrExternal, double noiseStddev, double correlationNoiseStddev, double higherOrderProbability, String subgraphSelection, RandomElement rndGen) throws CreateNetworkException {
        int nrCorr = nrExternal == -1 ? -1 : 0;
        return GeneNetwork.createRandomizedGNfromSIFFile(sifFile, nrNodes, startNode, nrBackgroundNodes, nrExternal, nrCorr, noiseStddev, correlationNoiseStddev, higherOrderProbability, subgraphSelection, rndGen);
    }

    @Deprecated
    public static Object[] createRandomizedGNfromSIFFile(String sifFile, int nrNodes, String startNode, int nrBackgroundNodes, int nrExternal, int nrCorr, double noiseStddev, double correlationNoiseStddev, double higherOrderProbability, String subgraphSelection, RandomElement rndGen) throws CreateNetworkException {
        ArrayList bgrTopNodes;
        IncidenceMatrix subIM;
        assert (nrExternal < nrNodes) : "nr of external nodes must be smaller than nr of nodes!";
        assert (subgraphSelection.equals("with children") || subgraphSelection.equals("without children")) : "string subgraphSelection is incorrect";
        IncidenceMatrix completeSubIM = null;
        IncidenceMatrix im = IncidenceMatrix.fromSIF(sifFile);
        int MAX_ITER = 5000;
        int cntr = 0;
        do {
            boolean withStartNode;
            int startNodeIdx;
            block31: {
                if (++cntr > 1) {
                    System.out.println("insufficient top nodes, attempt " + cntr);
                }
                startNodeIdx = -1;
                if (startNode == "") {
                    withStartNode = false;
                } else {
                    startNodeIdx = im.getNameIndex(startNode);
                    if (startNodeIdx == -1) {
                        System.out.println("WARNING: startNode " + startNode + " not found!");
                        System.out.println("Continue with random? (y/n)");
                        Scanner in = new Scanner(System.in);
                        while (true) {
                            String answer;
                            if ((answer = in.nextLine()).equals("y")) {
                                withStartNode = false;
                                System.out.println("Continuing with random.");
                                break block31;
                            }
                            if (answer.equals("n")) {
                                System.out.println("Terminating program.");
                                System.exit(0);
                                continue;
                            }
                            System.out.println("Please type y or n");
                        }
                    }
                    withStartNode = true;
                }
            }
            if (withStartNode) {
                if (subgraphSelection.equals("with children")) {
                    subIM = im.randomSubgraphWithChildren(rndGen, nrNodes, startNodeIdx);
                    continue;
                }
                subIM = im.randomSubgraph(rndGen, nrNodes, startNodeIdx);
                continue;
            }
            subIM = subgraphSelection.equals("with children") ? im.randomSubgraphWithChildren(rndGen, nrNodes) : im.randomSubgraph(rndGen, nrNodes);
        } while (nrExternal != -1 && subIM.getNrTopNodes() < nrExternal && cntr < MAX_ITER);
        if (cntr >= MAX_ITER) {
            throw new CreateNetworkException("Cannot create a network with " + nrExternal + " external nodes in " + MAX_ITER + " steps");
        }
        if (nrBackgroundNodes > 0) {
            IncidenceMatrix backgroundSubIM = subgraphSelection.equals("with children") ? im.randomSubgraphWithChildren(rndGen, nrBackgroundNodes) : im.randomSubgraph(rndGen, nrBackgroundNodes);
            int i = 0;
            while (i < backgroundSubIM.size()) {
                backgroundSubIM.set(i, "bgr_" + backgroundSubIM.getName(i));
                ++i;
            }
            GeneNetwork bgrGn = GeneNetwork.fromIncidenceMatrix(backgroundSubIM, rndGen);
            bgrGn.convertToDAG();
            bgrGn.integrityCheck();
            if (!bgrGn.toNetwork().isDAG()) {
                System.out.println("ERROR: background network is not converted to a DAG!");
                bgrGn.convertToDAG();
                Network n = bgrGn.toNetwork();
                n.convertToDAG();
                if (n.isDAG()) {
                    System.out.println(" and same routine in Network returns DAG!");
                }
                System.exit(-1);
            }
            try {
                PrintWriter tmpFile = new PrintWriter("./tmp.tmp");
                bgrGn.toSIF(tmpFile);
                tmpFile.close();
                backgroundSubIM = IncidenceMatrix.fromSIF("./tmp.tmp");
                if (!new File("./tmp.tmp").delete()) {
                    System.out.println("could't delete tmp.tmp, please delete manually...");
                }
            }
            catch (FileNotFoundException e) {
                System.out.println(e.getMessage());
                System.exit(-1);
            }
            bgrTopNodes = bgrGn.getTopNodes();
            completeSubIM = IncidenceMatrix.mergeAndDisconnect(subIM, backgroundSubIM);
        } else {
            completeSubIM = subIM;
            bgrTopNodes = null;
        }
        if (completeSubIM == null) {
            throw new CreateNetworkException("Cannot create a random subnetwork for unknown reason, resulting completeSubIM is null.");
        }
        GeneNetwork gn = GeneNetwork.fromIncidenceMatrix(completeSubIM, true, noiseStddev, higherOrderProbability, rndGen);
        ArrayList topNodes = gn.getTopNodes();
        if (nrBackgroundNodes > 0) {
            int i = 0;
            while (i < bgrTopNodes.size()) {
                int j = 0;
                while (j < topNodes.size()) {
                    if (((Node)topNodes.get(j)).getName().equals(((Node)bgrTopNodes.get(i)).getName())) {
                        topNodes.remove((Node)topNodes.get(j));
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (nrExternal == -1) {
            int i = 0;
            while (i < topNodes.size()) {
                Node ext = (Node)topNodes.get(i);
                ext.setRandomExternal(rndGen);
                ++i;
            }
        } else {
            int cntr2 = 0;
            while (cntr2 < nrExternal) {
                int rnd = rndGen.choose(0, topNodes.size() - 1);
                Node ext = (Node)topNodes.get(rnd);
                topNodes.remove(rnd);
                ext.setRandomExternal(rndGen);
                ++cntr2;
            }
        }
        if (nrCorr == -1) {
            nrCorr = (int)Math.floor(gn.getNExternalConditions() / 2);
        }
        gn.setCorrExtCond(rndGen, nrCorr, correlationNoiseStddev);
        return new Object[]{gn, completeSubIM};
    }
}

