/*
 * Decompiled with CFR 0.152.
 */
package islab.bayesian.genenetwork;

import cern.jet.random.engine.MersenneTwister;
import islab.bayesian.genenetwork.GeneNetwork;
import islab.bayesian.genenetwork.Node;
import islab.lib.RandomElement;
import islab.lib.XmlXomReader;
import java.io.File;
import java.util.ArrayList;

public class GroupOfNetworks {
    private String[] action;
    private int[] baseIndex;
    private int[] belongsTo;
    private GeneNetwork bigGn;
    private int bigGnNVariables;
    private GeneNetwork[] gn;
    private int nNw;
    private String selection;

    public static void main(String[] args) {
        GroupOfNetworks gn = new GroupOfNetworks(args);
        System.out.print(gn.toXML(""));
    }

    public GeneNetwork getNetwork(int i) {
        return this.gn[i];
    }

    public GroupOfNetworks(GeneNetwork[] geneNetworks) {
        this.nNw = geneNetworks.length;
        this.gn = geneNetworks;
        ArrayList nodes = new ArrayList();
        this.baseIndex = new int[this.nNw + 1];
        try {
            int base = 0;
            int i = 0;
            while (i < this.nNw) {
                this.gn[i].renumber(base);
                this.baseIndex[i] = base;
                base += this.gn[i].getNVariables();
                nodes.addAll(this.gn[i].getNodes());
                ++i;
            }
            this.baseIndex[this.nNw] = base;
            this.bigGn = new GeneNetwork(nodes);
            this.bigGnNVariables = base;
            this.belongsTo = new int[this.bigGnNVariables];
            int cnt = 0;
            int i2 = 0;
            while (i2 < this.bigGnNVariables) {
                if (i2 == this.baseIndex[cnt + 1]) {
                    // empty if block
                }
                this.belongsTo[i2] = ++cnt;
                ++i2;
            }
        }
        catch (Exception e) {
            System.err.println("Exception: " + e);
            e.printStackTrace();
            System.exit(1);
        }
    }

    public GroupOfNetworks(String[] filenames) {
        this.nNw = filenames.length;
        this.gn = new GeneNetwork[this.nNw];
        ArrayList nodes = new ArrayList();
        this.baseIndex = new int[this.nNw + 1];
        try {
            int base = 0;
            int i = 0;
            while (i < this.nNw) {
                String xmlString = XmlXomReader.getDocument(new File(filenames[i])).toXML();
                this.gn[i] = GeneNetwork.fromXML(new RandomElement(new MersenneTwister(17)), xmlString);
                this.gn[i].renumber(base);
                this.baseIndex[i] = base;
                base += this.gn[i].getNVariables();
                nodes.addAll(this.gn[i].getNodes());
                ++i;
            }
            this.baseIndex[this.nNw] = base;
            this.bigGn = new GeneNetwork(nodes);
            this.bigGnNVariables = base;
            this.belongsTo = new int[this.bigGnNVariables];
            int cnt = 0;
            int i2 = 0;
            while (i2 < this.bigGnNVariables) {
                if (i2 == this.baseIndex[cnt + 1]) {
                    // empty if block
                }
                this.belongsTo[i2] = ++cnt;
                ++i2;
            }
        }
        catch (Exception e) {
            System.err.println("Exception: " + e);
            e.printStackTrace();
            System.exit(1);
        }
    }

    public GeneNetwork bigGN() {
        return this.bigGn;
    }

    public int getNNetworks() {
        return this.nNw;
    }

    public int getNRegulators() {
        int cnt = 0;
        ArrayList reg = this.bigGn.getRegulators();
        int i = 0;
        while (i < reg.size()) {
            Node r = (Node)reg.get(i);
            if (this.isActiveVariable(r.getIndex())) {
                ++cnt;
            }
            ++i;
        }
        return cnt;
    }

    public ArrayList getRegulators(int index) {
        return this.gn[index].getRegulators();
    }

    public int getNNodes() {
        int cnt = 0;
        ArrayList nodes = this.bigGn.getNodes();
        int i = 0;
        while (i < nodes.size()) {
            Node n = (Node)nodes.get(i);
            if (this.isActiveVariable(n.getIndex())) {
                ++cnt;
            }
            ++i;
        }
        return cnt;
    }

    public ArrayList getNodes(int index) {
        return this.gn[index].getNodes();
    }

    public boolean isActive(int index) {
        if (this.selection == null) {
            return true;
        }
        return this.action[index].equals("A");
    }

    public boolean isActiveVariable(int index) {
        if (this.selection == null) {
            return true;
        }
        return this.isActive(this.belongsTo[index]);
    }

    public boolean isRandom(int index) {
        if (this.selection == null) {
            return false;
        }
        return this.action[index].equals("R");
    }

    public boolean isRandomVariable(int index) {
        if (this.selection == null) {
            return false;
        }
        return this.isRandom(this.belongsTo[index]);
    }

    public void setSelection(String selection) {
        this.selection = selection;
        if (this.selection == null) {
            return;
        }
        this.action = new String[this.nNw];
        int index = 0;
        int i = 0;
        while (i < this.nNw) {
            if (this.selection.charAt(index) != '[') {
                this.action[i] = "" + this.selection.charAt(index);
                ++index;
            } else {
                int closepos = this.selection.indexOf(93, index);
                this.action[i] = this.selection.substring(index + 1, closepos);
                index = closepos + 1;
            }
            ++i;
        }
    }

    public String toXML(String indent) {
        return this.bigGn.toXML(indent);
    }

    public String valueSetUnselected(int index) {
        if (this.selection == null) {
            return null;
        }
        char c = this.action[index].charAt(0);
        if (c >= '0' && c <= '9') {
            return this.action[index];
        }
        return null;
    }

    public String valueSetUnselectedVariable(int index) {
        if (this.selection == null) {
            return null;
        }
        return this.valueSetUnselected(this.belongsTo[index]);
    }
}

