/*
 * Decompiled with CFR 0.152.
 */
package islab.bayesian.genenetwork;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ITParser
extends DefaultHandler {
    private static Writer out;
    private Flag inTest = new Flag();
    private Flag inInteractionType = new Flag();
    private Flag inProbabilityModel = new Flag();
    private Flag inProbModelParameter = new Flag();
    private Flag inFunction = new Flag();
    private Flag inFnctParameter = new Flag();
    private String qName;
    private ArrayList fnctAttrs = new ArrayList();
    private ArrayList probModelAttrs = new ArrayList();
    private ArrayList probModelParams = new ArrayList();
    private ArrayList fnctParams = new ArrayList();
    private String[] valueStrings = new String[20];
    private int valueIndex = 0;

    public static void main(String[] argv) {
        if (argv.length != 1) {
            System.err.println("Usage: cmd filename");
            System.exit(1);
        }
        ITParser handler = new ITParser();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            out = new OutputStreamWriter((OutputStream)System.out, "UTF8");
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(new File(argv[0]), (DefaultHandler)handler);
        }
        catch (SAXParseException spe) {
            System.out.println("\n** Parsing error, line " + spe.getLineNumber() + ", uri " + spe.getSystemId());
            System.out.println("   " + spe.getMessage());
            Exception x = spe;
            if (spe.getException() != null) {
                x = spe.getException();
            }
            x.printStackTrace();
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            x.printStackTrace();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        System.exit(0);
    }

    public void setDocumentLocator(Locator l) {
        try {
            out.write("LOCATOR");
            out.write("\n SYS ID: " + l.getSystemId());
            out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void startDocument() throws SAXException {
        int i = 0;
        while (i < 20) {
            this.valueStrings[i] = "";
            ++i;
        }
        this.nl();
        this.nl();
        this.emit("START DOCUMENT");
        this.nl();
        this.emit("<?xml version='1.0' encoding='UTF-8'?>");
    }

    public void endDocument() throws SAXException {
        this.nl();
        this.emit("END DOCUMENT");
        try {
            this.nl();
            out.flush();
        }
        catch (IOException e) {
            throw new SAXException("I/O error", e);
        }
    }

    public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
        this.qName = qName;
        this.nl();
        this.emit("ELEMENT: ");
        this.emit("<" + qName);
        this.emit(">");
        if (this.inTest.isFalse()) {
            this.expectTag("test", this.inTest);
            return;
        }
        if (this.inTest.isTrue() && this.inInteractionType.isFalse()) {
            this.expectTag("interactionType", this.inInteractionType);
            return;
        }
        if (this.inInteractionType.isTrue() && this.inProbabilityModel.isFalse()) {
            this.expectTag("probabilityModel", this.inProbabilityModel);
            this.storeAttributes(attrs, this.probModelAttrs);
            return;
        }
        if (this.inProbabilityModel.isTrue() && this.inFunction.isFalse() && this.inProbModelParameter.isFalse()) {
            try {
                this.expectTag("parameter", this.inProbModelParameter);
                this.probModelParams.add(new Parameter(this.getStringAttr(qName, "name", attrs)));
                return;
            }
            catch (SAXException e) {
                this.expectTag("function", this.inFunction);
                this.storeAttributes(attrs, this.fnctAttrs);
                return;
            }
        }
        if (this.inFunction.isTrue() && this.inFnctParameter.isFalse()) {
            this.expectTag("parameter", this.inFnctParameter);
            this.fnctParams.add(new Parameter(this.getStringAttr(qName, "name", attrs)));
            return;
        }
    }

    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        this.nl();
        this.emit("END_ELM: ");
        this.emit("</" + qName + ">");
        String s = this.valueStrings[--this.valueIndex];
        this.valueStrings[this.valueIndex--] = "";
        if (qName.equalsIgnoreCase("parameter")) {
            if (this.inProbModelParameter.isTrue()) {
                ((Parameter)this.probModelParams.get((int)(this.probModelParams.size() - 1))).value = s;
                this.inProbModelParameter.unset();
            }
            if (this.inFnctParameter.isTrue()) {
                ((Parameter)this.fnctParams.get((int)(this.fnctParams.size() - 1))).value = s;
                this.inFnctParameter.unset();
            }
        }
        if (qName.equalsIgnoreCase("function")) {
            this.nl();
            this.emit("fnctAttrs");
            this.emit(this.fnctAttrs.toString());
            this.nl();
            this.emit("fnctParams");
            this.emit(this.fnctParams.toString());
            this.fnctAttrs.clear();
            this.fnctParams.clear();
            this.inFunction.unset();
        }
        if (qName.equalsIgnoreCase("probabilityModel")) {
            this.nl();
            this.emit("probModelAttrs");
            this.emit(this.probModelAttrs.toString());
            this.nl();
            this.emit("probModelParams");
            this.emit(this.probModelParams.toString());
            this.probModelAttrs.clear();
            this.probModelParams.clear();
            this.inProbabilityModel.unset();
        }
        if (qName.equalsIgnoreCase("interactionType")) {
            this.inInteractionType.unset();
        }
        if (qName.equalsIgnoreCase("test")) {
            this.inTest.unset();
        }
    }

    public void characters(char[] buf, int offset, int len) throws SAXException {
        String s = new String(buf, offset, len);
        int n = this.valueIndex++;
        this.valueStrings[n] = String.valueOf(this.valueStrings[n]) + s.trim();
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.nl();
        this.emit("PROCESS: ");
        this.emit("<?" + target + " " + data + "?>");
    }

    public void error(SAXParseException e) throws SAXParseException {
        throw e;
    }

    public void warning(SAXParseException err) throws SAXParseException {
        System.out.println("** Warning, line " + err.getLineNumber() + ", uri " + err.getSystemId());
        System.out.println("   " + err.getMessage());
    }

    private void expectTag(String expectedTagName, Flag flagToSet) throws SAXException {
        if (flagToSet.isFalse()) {
            if (this.qName.equalsIgnoreCase(expectedTagName)) {
                flagToSet.set();
                return;
            }
            throw new SAXException("Bad XML definition; <" + expectedTagName + "> expected ");
        }
        throw new RuntimeException("already in tag <" + expectedTagName + ">");
    }

    private void storeAttributes(Attributes attrs, ArrayList attrList) throws SAXException {
        if (attrs != null) {
            int i = 0;
            while (i < attrs.getLength()) {
                String aName = attrs.getQName(i);
                String aValue = attrs.getValue(i);
                attrList.add(new Attribute(aName, aValue));
                ++i;
            }
        }
    }

    private String getStringAttr(String qname, String attrname, Attributes attrs) throws SAXException {
        if (attrs == null) {
            throw new SAXException("expected attributes for <" + qname + "> ");
        }
        String s = attrs.getValue(attrname);
        if (s == null) {
            throw new SAXException("expected string attribute " + attrname + " for <" + qname + "> ");
        }
        return s;
    }

    private void emit(String s) throws SAXException {
        try {
            out.write(s);
            out.flush();
        }
        catch (IOException e) {
            throw new SAXException("I/O error", e);
        }
    }

    private void nl() throws SAXException {
        String lineEnd = System.getProperty("line.separator");
        try {
            out.write(lineEnd);
        }
        catch (IOException e) {
            throw new SAXException("I/O error", e);
        }
    }

    private class Flag {
        private boolean value = false;

        private Flag() {
        }

        public boolean isTrue() {
            return this.value;
        }

        public boolean isFalse() {
            return !this.value;
        }

        public void set() {
            this.value = true;
        }

        public void unset() {
            this.value = false;
        }
    }

    private class Parameter {
        public String name;
        public String value;

        public Parameter(String name) {
            this.name = name;
            this.value = "Value not set";
        }

        public String toString() {
            return String.valueOf(this.name) + ":" + this.value;
        }
    }

    private class Attribute {
        public String name;
        public String value;

        public Attribute(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.name) + ":" + this.value;
        }
    }
}

