/*
 * Decompiled with CFR 0.152.
 */
package islab.bayesian.genenetwork;

import cern.jet.random.engine.MersenneTwister;
import islab.bayesian.IProvideMean;
import islab.bayesian.LognormalNoise;
import islab.bayesian.ProbabilityModel;
import islab.bayesian.ProbabilityModelFactory;
import islab.bayesian.genenetwork.NActivatorsMM;
import islab.bayesian.genenetwork.NRegulatorsMM;
import islab.bayesian.genenetwork.NRepressorsMM;
import islab.bayesian.genenetwork.Node;
import islab.bayesian.genenetwork.OneActivatorCoop;
import islab.bayesian.genenetwork.OneActivatorOneRepressorComp;
import islab.bayesian.genenetwork.OneActivatorOneRepressorNoComp;
import islab.bayesian.genenetwork.OneRepressorCoop;
import islab.bayesian.genenetwork.TwoActivatorsSynergism;
import islab.lib.RandomElement;
import islab.lib.XmlXomReader;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import org.xml.sax.SAXParseException;

public class InteractionType {
    private ProbabilityModel pm;
    private String name;
    private String shortName;

    public ProbabilityModel getProbabilityModel() {
        return this.pm;
    }

    public String getName() {
        return this.name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public InteractionType(String name, ProbabilityModel pm) {
        this.name = name;
        this.shortName = name;
        this.pm = pm;
    }

    public static InteractionType create(int nReg, int nCoact, int nExt, String name) {
        return null;
    }

    public static InteractionType create2(int nReg, int nCoact, int nExt, String name) {
        return null;
    }

    public String toString() {
        return this.shortName;
    }

    public String toXML() {
        return this.toXML(1, "\t");
    }

    public String toXML(String indentString) {
        return this.toXML(1, indentString);
    }

    public String toXML(int indentLevel, String indentString) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < indentLevel) {
            sb.append(indentString);
            ++i;
        }
        String indent = sb.toString();
        sb = new StringBuffer();
        sb.append(String.valueOf(indent) + "<InteractionType name=\"" + this.name + "\">\n");
        sb.append(this.pm.toXML(indentLevel + 1, indentString));
        sb.append(String.valueOf(indent) + "</InteractionType>");
        return sb.toString();
    }

    public static InteractionType fromXML(RandomElement randomGen, String xml) throws SAXParseException {
        try {
            Document dom = XmlXomReader.getDocument(xml);
            Element xmlNode = dom.getRootElement();
            if (!xmlNode.getLocalName().equals("InteractionType")) {
                throw new SAXParseException("Error parsing xml string: a node must be of type InteractionType", null);
            }
            String name = xmlNode.getAttribute("name").getValue().toString();
            Elements pmods = xmlNode.getChildElements("ProbabilityModel");
            ProbabilityModel pm = ProbabilityModelFactory.fromXML(randomGen, pmods.get(0).toXML());
            InteractionType it = new InteractionType(name, pm);
            return it;
        }
        catch (Exception ex) {
            throw new SAXParseException(ex.getMessage(), null);
        }
    }

    public static void main(String[] args) {
        Node n = new Node(0);
        RandomElement random = new RandomElement(new MersenneTwister(234));
        IProvideMean provider = new OneActivatorCoop(0.0, 1.0, 0.05, 0.16);
        LognormalNoise pm = new LognormalNoise(random, provider, 0.03, n);
        InteractionType it = new InteractionType("TestInteraction", pm);
        System.out.println(it.toXML(0, "\t"));
        provider = new OneRepressorCoop(1.0, 0.5, 0.34);
        it.pm = new LognormalNoise(random, provider, 0.03, n);
        System.out.println(it.toXML(0, "\t"));
        provider = new OneActivatorOneRepressorComp(0.0, 1.0, 0.05, 0.16, true);
        it.pm = new LognormalNoise(random, provider, 0.03, n);
        System.out.println(it.toXML(0, "\t"));
        provider = new OneActivatorOneRepressorNoComp(0.0, 1.0, 0.05, 0.16, true);
        it.pm = new LognormalNoise(random, provider, 0.03, n);
        System.out.println(it.toXML(0, "\t"));
        provider = new TwoActivatorsSynergism(0.0, 0.25, 0.334, 0.08, 0.016, 3.2);
        it.pm = new LognormalNoise(random, provider, 0.03, n);
        System.out.println(it.toXML(0, "\t"));
        provider = new NActivatorsMM(0.1, new double[]{1.3, 1.4, 0.8}, new double[]{0.08, 0.16, 0.32}, 3);
        it.pm = new LognormalNoise(random, provider, 0.03, n);
        System.out.println(it.toXML(0, "\t"));
        provider = new NRepressorsMM(3.4, new double[]{0.08, 0.16, 0.32}, 3);
        it.pm = new LognormalNoise(random, provider, 0.03, n);
        System.out.println(it.toXML(0, "\t"));
        int[] nArray = new int[3];
        nArray[1] = 1;
        provider = new NRegulatorsMM(0.1, new double[]{1.3, 1.4, 0.8}, new double[]{0.08, 0.16, 0.32}, nArray, 3);
        it.pm = new LognormalNoise(random, provider, 0.5, n);
        System.out.println(it.toXML(0, "\t"));
    }
}

