/*
 * Decompiled with CFR 0.152.
 */
package islab.bayesian.genenetwork;

import islab.bayesian.DataSet;
import islab.bayesian.IProvideMean;
import islab.lib.XmlXomReader;
import java.util.Hashtable;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import org.xml.sax.SAXParseException;

public class NActivatorsMM
implements IProvideMean {
    double V0max;
    double[] Vmax;
    double[] Ka;
    int numReg;

    public NActivatorsMM(double V0max, double[] Vmax, double[] Ka, int numReg) {
        assert (Vmax.length == numReg) : "expected " + numReg + " Vmax values";
        assert (Ka.length == numReg) : "expected " + numReg + " Ka values";
        int i = 0;
        while (i < Vmax.length) {
            assert (Vmax[i] > V0max) : "For an activator Vmax has to be larger than V0max";
            ++i;
        }
        this.V0max = V0max;
        this.Vmax = Vmax;
        this.Ka = Ka;
        this.numReg = numReg;
    }

    public double computeMean(double[] configuration, int[] indexIncoming) {
        assert (indexIncoming.length == this.numReg) : "expected " + this.numReg + " activators";
        double[] A = new double[this.numReg];
        int i = 0;
        while (i < this.numReg) {
            A[i] = configuration[indexIncoming[i]];
            ++i;
        }
        double numerator = this.V0max;
        int i2 = 0;
        while (i2 < this.numReg) {
            double T = A[i2] / this.Ka[i2] * this.Vmax[i2];
            int j = 0;
            while (j < this.numReg) {
                T = j != i2 ? (T *= 1.0 + A[j] / this.Ka[j]) : (T *= 1.0);
                ++j;
            }
            numerator += T;
            ++i2;
        }
        double denominator = 1.0;
        int i3 = 0;
        while (i3 < this.numReg) {
            denominator *= 1.0 + A[i3] / this.Ka[i3];
            ++i3;
        }
        double v = numerator / denominator;
        double numerator_Kd = this.V0max;
        int i4 = 0;
        while (i4 < this.numReg) {
            double T = 1.0 / this.Ka[i4] * this.Vmax[i4];
            int j = 0;
            while (j < this.numReg) {
                if (j != i4) {
                    T *= 1.0 + 1.0 / this.Ka[j];
                }
                ++j;
            }
            numerator_Kd += T;
            ++i4;
        }
        double denominator_Kd = 1.0;
        int i5 = 0;
        while (i5 < this.numReg) {
            denominator_Kd *= 1.0 + 1.0 / this.Ka[i5];
            ++i5;
        }
        double Kd = numerator_Kd / denominator_Kd;
        double vMin = this.V0max;
        return (v - vMin) / (Kd - vMin);
    }

    public boolean train(DataSet dataset, int[] indices, int index, int[] indexIncoming) {
        throw new RuntimeException("Not implemented!");
    }

    public String toXML(String is) {
        return this.toXML(0, is);
    }

    public String toXML(int indentLevel, String indentString) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < indentLevel) {
            sb.append(indentString);
            ++i;
        }
        String indent = sb.toString();
        sb = new StringBuffer();
        sb.append(String.valueOf(indent) + "<IProvideMean>\n");
        sb.append(String.valueOf(indent) + "  <function name=\"NActivatorsMM\">\n");
        sb.append(String.valueOf(indent) + "    <parameter name=\"numReg\">" + this.numReg + "</parameter>\n");
        sb.append(String.valueOf(indent) + "    <parameter name=\"V0max\">" + this.V0max + "</parameter>\n");
        int n = 0;
        while (n < this.numReg) {
            sb.append(String.valueOf(indent) + "    <parameter name=\"Vmax\">" + this.Vmax[n] + "</parameter>\n");
            sb.append(String.valueOf(indent) + "    <parameter name=\"Ka\">" + this.Ka[n] + "</parameter>\n");
            ++n;
        }
        sb.append(String.valueOf(indent) + "  </function>\n");
        sb.append(String.valueOf(indent) + "</IProvideMean>\n");
        return sb.toString();
    }

    public static NActivatorsMM fromXML(String xml) throws SAXParseException {
        try {
            Document dom = XmlXomReader.getDocument(xml);
            Element xmlNode = dom.getRootElement();
            if (!xmlNode.getLocalName().equals("IProvideMean")) {
                throw new SAXParseException("Error parsing xml string: node must be of type IProvideMean", null);
            }
            Element function = xmlNode.getChildElements("function").get(0);
            if (!function.getAttribute("name").getValue().toString().equals("NActivatorsMM")) {
                throw new SAXParseException("Error parsing xml string: function must be NActivatorsMM", null);
            }
            Hashtable<String, Integer> initialized = new Hashtable<String, Integer>();
            Integer dummy = new Integer(1);
            int numReg = -1;
            double V0max = 0.0;
            double[] Vmax = null;
            double[] Ka = null;
            Elements params = function.getChildElements("parameter");
            int cnt1 = 0;
            int cnt2 = 0;
            int i = 0;
            while (i < params.size()) {
                Element par = params.get(i);
                String name = par.getAttribute("name").getValue();
                if (name.equals("numReg")) {
                    initialized.put("numReg", dummy);
                    numReg = Integer.parseInt(par.getValue());
                    Vmax = new double[numReg];
                    Ka = new double[numReg];
                } else if (name.equals("V0max")) {
                    initialized.put("V0max", dummy);
                    V0max = Double.parseDouble(par.getValue());
                } else if (name.equals("Vmax")) {
                    if (cnt1 != cnt2) {
                        throw new SAXParseException("error parsing <IProvideMean>, function NActivatorsMM: incomplete tuple (Vmax, Ka): " + cnt1, null);
                    }
                    initialized.put("Vmax" + cnt1, dummy);
                    Vmax[cnt1++] = Double.parseDouble(par.getValue());
                } else if (name.equals("Ka")) {
                    initialized.put("Ka" + cnt2, dummy);
                    Ka[cnt2++] = Double.parseDouble(par.getValue());
                } else {
                    System.err.println("WARNING: unknown parameter " + name + " in function " + function.getAttribute("name").getValue());
                }
                ++i;
            }
            if (!initialized.containsKey("numReg") || !initialized.containsKey("V0max")) {
                throw new SAXParseException("error parsing <IProvideMean>, function NActivatorsMM: parameter 'numReg' or 'V0max' not found.", null);
            }
            i = 0;
            while (i < numReg) {
                if (!initialized.containsKey("Vmax" + i) || !initialized.containsKey("Ka" + i)) {
                    throw new SAXParseException("error parsing <IProvideMean>, function NActivatorsMM: parameter 'Vmax" + i + "' or 'Ka" + i + "' not found.", null);
                }
                ++i;
            }
            if (cnt1 != cnt2) {
                throw new SAXParseException("error parsing <IProvideMean>, function NActivatorsMM: number of Vmax and Ka are different", null);
            }
            return new NActivatorsMM(V0max, Vmax, Ka, numReg);
        }
        catch (Exception ex) {
            throw new SAXParseException(ex.getMessage(), null);
        }
    }
}

