/*
 * Decompiled with CFR 0.152.
 */
package islab.bayesian.genenetwork;

import islab.bayesian.DataSet;
import islab.bayesian.IProvideMean;
import islab.lib.XmlXomReader;
import java.util.Hashtable;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import org.xml.sax.SAXParseException;

public class NRegulatorsMM
implements IProvideMean {
    public static final int REPRESSOR = 0;
    public static final int ACTIVATOR = 1;
    public static final int UNKNOWN = 2;
    double V0max;
    double[] FoldActivation;
    private double[] Vmax;
    double[] Keq;
    int[] type;
    int numReg;

    public NRegulatorsMM(double V0max, double[] FoldActivation, double[] Keq, int[] type, int numReg) {
        assert (FoldActivation.length == numReg) : "expected " + numReg + " FoldActivation values";
        assert (Keq.length == numReg) : "expected " + numReg + " Keq values";
        assert (type.length == numReg) : "expected " + numReg + " type values";
        int i = 0;
        while (i < numReg) {
            assert (type[i] == 0 || type[i] == 1) : "type code has to be either 0 or 1";
            ++i;
        }
        i = 0;
        while (i < FoldActivation.length) {
            if (type[i] == 1) assert (FoldActivation[i] > 1.0) : "For activators FoldActivation has to be > 1";
            ++i;
        }
        this.V0max = V0max;
        this.FoldActivation = FoldActivation;
        this.Keq = Keq;
        this.type = type;
        this.numReg = numReg;
        this.Vmax = new double[numReg];
        i = 0;
        while (i < this.Vmax.length) {
            this.Vmax[i] = this.V0max * this.FoldActivation[i];
            ++i;
        }
    }

    public double computeMean(double[] configuration, int[] indexIncoming) {
        assert (indexIncoming.length == this.numReg) : "expected " + this.numReg + " regulators";
        int i = 0;
        while (i < this.numReg) {
            if (this.type[i] == 2) {
                throw new RuntimeException("type for NRegulatorsMM should not be unknown!");
            }
            ++i;
        }
        double[] R = new double[this.numReg];
        int i2 = 0;
        while (i2 < this.numReg) {
            R[i2] = configuration[indexIncoming[i2]];
            ++i2;
        }
        double numerator = this.V0max;
        int i3 = 0;
        while (i3 < this.numReg) {
            if (this.type[i3] == 1) {
                double T = R[i3] / this.Keq[i3] * this.Vmax[i3];
                int j = 0;
                while (j < this.numReg) {
                    if (this.type[j] == 1 && j != i3) {
                        T *= 1.0 + R[j] / this.Keq[j];
                    }
                    ++j;
                }
                numerator += T;
            }
            ++i3;
        }
        double denominator = 1.0;
        int i4 = 0;
        while (i4 < this.numReg) {
            denominator *= 1.0 + R[i4] / this.Keq[i4];
            ++i4;
        }
        double v = numerator / denominator;
        double numerator_Kd = this.V0max;
        int i5 = 0;
        while (i5 < this.numReg) {
            if (this.type[i5] == 1) {
                double T = 1.0 / this.Keq[i5] * this.Vmax[i5];
                int j = 0;
                while (j < this.numReg) {
                    if (this.type[j] == 1 && j != i5) {
                        T *= 1.0 + 1.0 / this.Keq[j];
                    }
                    ++j;
                }
                numerator_Kd += T;
            }
            ++i5;
        }
        double denominator_Kd = 1.0;
        int i6 = 0;
        while (i6 < this.numReg) {
            if (this.type[i6] == 1) {
                denominator_Kd *= 1.0 + 1.0 / this.Keq[i6];
            }
            ++i6;
        }
        double Kd = numerator_Kd / denominator_Kd;
        double denomVMin = 1.0;
        int i7 = 0;
        while (i7 < this.numReg) {
            if (this.type[i7] == 0) {
                denomVMin *= 1.0 + 1.0 / this.Keq[i7];
            }
            ++i7;
        }
        double vMin = this.V0max / denomVMin;
        return (v - vMin) / (Kd - vMin);
    }

    public boolean train(DataSet dataset, int[] indices, int index, int[] indexIncoming) {
        throw new RuntimeException("Not implemented!");
    }

    public String toXML(String indentString) {
        return this.toXML(1, indentString);
    }

    public String toXML(int indentLevel, String indentString) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < indentLevel) {
            sb.append(indentString);
            ++i;
        }
        String indent = sb.toString();
        sb = new StringBuffer();
        sb.append(String.valueOf(indent) + "<IProvideMean>\n");
        sb.append(String.valueOf(indent) + "  <function name=\"NRegulatorsMM\">\n");
        sb.append(String.valueOf(indent) + "    <parameter name=\"numReg\">" + this.numReg + "</parameter>\n");
        sb.append(String.valueOf(indent) + "    <parameter name=\"V0max\">" + this.V0max + "</parameter>\n");
        int n = 0;
        while (n < this.numReg) {
            sb.append(String.valueOf(indent) + "    <parameter name=\"type\">" + (this.type[n] == 1 ? "ACTIVATOR" : (this.type[n] == 0 ? "REPRESSOR" : "UNKNOWN TYPE")) + "</parameter>\n");
            sb.append(String.valueOf(indent) + "    <parameter name=\"Vmax\">" + this.Vmax[n] + "</parameter>\n");
            sb.append(String.valueOf(indent) + "    <parameter name=\"Keq\">" + this.Keq[n] + "</parameter>\n");
            ++n;
        }
        sb.append(String.valueOf(indent) + "  </function>\n");
        sb.append(String.valueOf(indent) + "</IProvideMean>\n");
        return sb.toString();
    }

    public static NRegulatorsMM fromXML(String xml) throws SAXParseException {
        try {
            Document dom = XmlXomReader.getDocument(xml);
            Element xmlNode = dom.getRootElement();
            if (!xmlNode.getLocalName().equals("IProvideMean")) {
                throw new SAXParseException("Error parsing xml string: node must be of type IProvideMean", null);
            }
            Element function = xmlNode.getChildElements("function").get(0);
            if (!function.getAttribute("name").getValue().toString().equals("NRegulatorsMM")) {
                throw new SAXParseException("Error parsing xml string: function must be NRegulatorsMM", null);
            }
            Hashtable<String, Integer> initialized = new Hashtable<String, Integer>();
            Integer dummy = new Integer(1);
            int numReg = -1;
            double V0max = 0.0;
            double[] Vmax = null;
            double[] FoldActivation = null;
            double[] Keq = null;
            int[] type = null;
            Elements params = function.getChildElements("parameter");
            int cnt1 = 0;
            int cnt2 = 0;
            int cnt3 = 0;
            int i = 0;
            while (i < params.size()) {
                Element par = params.get(i);
                String name = par.getAttribute("name").getValue();
                if (name.equals("numReg")) {
                    initialized.put("numReg", dummy);
                    numReg = Integer.parseInt(par.getValue());
                    Vmax = new double[numReg];
                    FoldActivation = new double[numReg];
                    Keq = new double[numReg];
                    type = new int[numReg];
                } else if (name.equals("V0max")) {
                    initialized.put("V0max", dummy);
                    V0max = Double.parseDouble(par.getValue());
                } else if (name.equals("type")) {
                    if (cnt1 != cnt2 || cnt1 != cnt3) {
                        throw new SAXParseException("error parsing <IProvideMean>, function NRegulatorsMM:  incomplete (Vmax, Keq, type) tuple " + cnt1, null);
                    }
                    initialized.put("type" + cnt1, dummy);
                    type[cnt1++] = par.getValue().equals("ACTIVATOR") ? 1 : (par.getValue().equals("REPRESSOR") ? 0 : 2);
                } else if (name.equals("Vmax")) {
                    initialized.put("Vmax" + cnt2, dummy);
                    Vmax[cnt2++] = Double.parseDouble(par.getValue());
                } else if (name.equals("Keq")) {
                    initialized.put("Keq" + cnt3, dummy);
                    Keq[cnt3++] = Double.parseDouble(par.getValue());
                } else {
                    System.err.println("WARNING: unknown parameter " + name + " in function " + function.getAttribute("name").getValue());
                }
                ++i;
            }
            if (!initialized.containsKey("numReg") || !initialized.containsKey("V0max")) {
                throw new SAXParseException("error parsing <IProvideMean>, function NRegulatorsMM: parameter 'numReg' or 'V0max' not found.", null);
            }
            i = 0;
            while (i < numReg) {
                if (!(initialized.containsKey("Vmax" + i) && initialized.containsKey("Keq" + i) && initialized.containsKey("type" + i))) {
                    throw new SAXParseException("error parsing <IProvideMean>, function NRegulatorsMM: parameter 'Vmax" + i + "' or 'Keq" + i + "' or 'type" + i + "' not found.", null);
                }
                ++i;
            }
            if (cnt1 != cnt2 || cnt1 != cnt3) {
                throw new SAXParseException("error parsing <IProvideMean>, function NRegulatorsMM: incomplete last tuple (Vmax, Keq, type).", null);
            }
            i = 0;
            while (i < FoldActivation.length) {
                if (type[i] == 1) {
                    FoldActivation[i] = Vmax[i] / V0max;
                }
                ++i;
            }
            return new NRegulatorsMM(V0max, FoldActivation, Keq, type, numReg);
        }
        catch (Exception ex) {
            throw new SAXParseException(ex.getMessage(), null);
        }
    }
}

