/*
 * Decompiled with CFR 0.152.
 */
package islab.bayesian.genenetwork;

import islab.bayesian.DataSet;
import islab.bayesian.IProvideMean;
import islab.lib.XmlXomReader;
import java.util.Hashtable;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import org.xml.sax.SAXParseException;

public class NRepressorsMM
implements IProvideMean {
    double V0max;
    double[] Ki;
    int numReg;

    public NRepressorsMM(double V0max, double[] Ki, int numReg) {
        assert (Ki.length == numReg) : "expected " + numReg + " Ki values";
        this.V0max = V0max;
        this.Ki = Ki;
        this.numReg = numReg;
    }

    public double computeMean(double[] configuration, int[] indexIncoming) {
        assert (indexIncoming.length == this.numReg) : "expected " + this.numReg + " repressors";
        double[] I = new double[this.numReg];
        int i = 0;
        while (i < this.numReg) {
            I[i] = configuration[indexIncoming[i]];
            ++i;
        }
        double numerator = this.V0max;
        double denominator = 1.0;
        int i2 = 0;
        while (i2 < this.numReg) {
            denominator *= 1.0 + I[i2] / this.Ki[i2];
            ++i2;
        }
        double v = numerator / denominator;
        double Kd = this.V0max;
        double denomVMin = 1.0;
        int i3 = 0;
        while (i3 < this.numReg) {
            denomVMin *= 1.0 + 1.0 / this.Ki[i3];
            ++i3;
        }
        double vMin = this.V0max / denomVMin;
        return (v - vMin) / (Kd - vMin);
    }

    public boolean train(DataSet dataset, int[] indices, int index, int[] indexIncoming) {
        throw new RuntimeException("Not implemented!");
    }

    public String toXML(String indentString) {
        return this.toXML(1, indentString);
    }

    public String toXML(int indentLevel, String indentString) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < indentLevel) {
            sb.append(indentString);
            ++i;
        }
        String indent = sb.toString();
        sb = new StringBuffer();
        sb.append(String.valueOf(indent) + "<IProvideMean>\n");
        sb.append(String.valueOf(indent) + "  <function name=\"NRepressorsMM\">\n");
        sb.append(String.valueOf(indent) + "    <parameter name=\"numReg\">" + this.numReg + "</parameter>\n");
        sb.append(String.valueOf(indent) + "    <parameter name=\"V0max\">" + this.V0max + "</parameter>\n");
        int n = 0;
        while (n < this.numReg) {
            sb.append(String.valueOf(indent) + "    <parameter name=\"Ki\">" + this.Ki[n] + "</parameter>\n");
            ++n;
        }
        sb.append(String.valueOf(indent) + "  </function>");
        sb.append(String.valueOf(indent) + "</IProvideMean>\n");
        return sb.toString();
    }

    public static NRepressorsMM fromXML(String xml) throws SAXParseException {
        Document dom = XmlXomReader.getDocument(xml);
        Element xmlNode = dom.getRootElement();
        if (!xmlNode.getLocalName().equals("IProvideMean")) {
            throw new SAXParseException("Error parsing xml string: node must be of type IProvideMean", null);
        }
        Element function = xmlNode.getChildElements("function").get(0);
        if (!function.getAttribute("name").getValue().equals("NRepressorsMM")) {
            throw new SAXParseException("Error parsing xml string: function must be NRepressorsMM", null);
        }
        Hashtable<String, Integer> initialized = new Hashtable<String, Integer>();
        Integer dummy = new Integer(1);
        int numReg = -1;
        double V0max = 0.0;
        double[] Ki = null;
        Elements params = function.getChildElements("parameter");
        int cnt1 = 0;
        int i = 0;
        while (i < params.size()) {
            Element par = params.get(i);
            String name = par.getAttribute("name").getValue();
            if (name.equals("numReg")) {
                initialized.put("numReg", dummy);
                numReg = Integer.parseInt(par.getValue());
                Ki = new double[numReg];
            } else if (name.equals("V0max")) {
                initialized.put("V0max", dummy);
                V0max = Double.parseDouble(par.getValue());
            } else if (name.equals("Ki")) {
                initialized.put("Ki" + cnt1, dummy);
                Ki[cnt1++] = Double.parseDouble(par.getValue());
            } else {
                System.err.println("WARNING: unknown parameter " + name + " in function " + function.getAttribute("name").getValue());
            }
            ++i;
        }
        if (!initialized.containsKey("numReg") || !initialized.containsKey("V0max")) {
            throw new SAXParseException("error parsing <IProvideMean>, function NRepressorsMM: parameter not found.", null);
        }
        i = 0;
        while (i < numReg) {
            if (!initialized.containsKey("Ki" + i)) {
                throw new SAXParseException("error parsing <IProvideMean>, function NRegulatorsMM: parameter 'Ki" + i + "' not found.", null);
            }
            ++i;
        }
        return new NRepressorsMM(V0max, Ki, numReg);
    }
}

