/*
 * Decompiled with CFR 0.152.
 */
package islab.bayesian.genenetwork;

import islab.bayesian.ConstantModel;
import islab.bayesian.IXMLable;
import islab.bayesian.LognormalNoise;
import islab.bayesian.ProbabilityModel;
import islab.bayesian.genenetwork.GeneNetwork;
import islab.bayesian.genenetwork.InteractionType;
import islab.bayesian.genenetwork.NodeType;
import islab.lib.RandomElement;
import islab.lib.XmlXomReader;
import java.util.ArrayList;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import org.xml.sax.SAXParseException;

public class Node
implements IXMLable {
    private GeneNetwork geneNetwork;
    private int index;
    private ArrayList children;
    public ArrayList parents;
    private InteractionType type;
    private NodeType nodeType;
    private String name;
    private double maxExpression = 1.0;
    int xpos;
    int ypos;

    public GeneNetwork getGeneNetwork() {
        return this.geneNetwork;
    }

    public final ArrayList getChildren() {
        return this.children;
    }

    protected void addChild(Node child) {
        this.children.add(child);
    }

    protected void removeChild(Node child) {
        this.children.remove(child);
    }

    public final ArrayList getParents() {
        return this.parents;
    }

    protected void addParent(Node child) {
        this.parents.add(child);
    }

    protected void removeParent(Node child) {
        this.parents.remove(child);
    }

    public final InteractionType getInteractionType() {
        return this.type;
    }

    public final void setInteractionType(InteractionType type) {
        this.type = type;
    }

    public final NodeType getNodeType() {
        return this.nodeType;
    }

    public final void setNodeType(NodeType nt) {
        this.nodeType = nt;
    }

    public String getName() {
        if (this.name == null) {
            return "node_" + this.getIndex();
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public final double getMaxExpression() {
        return this.maxExpression;
    }

    public final void setMaxExpression(double maxExpression) {
        this.maxExpression = maxExpression;
    }

    public Node(int index) {
        this.index = index;
        this.parents = new ArrayList();
        this.children = new ArrayList();
        this.setInteractionType(null);
        this.xpos = -1;
        this.ypos = -1;
        this.nodeType = NodeType.UNKNOWN;
    }

    public Node(int index, NodeType type) {
        this(index);
        this.nodeType = type;
    }

    public Node(GeneNetwork gn, int index) {
        this(index);
        this.geneNetwork = gn;
    }

    public Node(GeneNetwork gn, int index, NodeType type) {
        this(index, type);
        this.geneNetwork = gn;
        this.nodeType = type;
    }

    public Node(GeneNetwork gn, int index, NodeType type, double maxExpression) {
        this(gn, index, type);
        this.setMaxExpression(maxExpression);
    }

    public final int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public final ProbabilityModel getProbabilityModel() {
        if (this.getInteractionType() == null) {
            return null;
        }
        return this.getInteractionType().getProbabilityModel();
    }

    public void setpos(int x, int y) {
        this.xpos = x;
        this.ypos = y;
    }

    public void setRandomExternal(RandomElement rndGen) {
        this.setInteractionType(new InteractionType("external_" + this.getIndex(), new LognormalNoise(rndGen, new ConstantModel(rndGen.uniform(0.0, 1.0)), 0.0, this)));
        this.setNodeType(NodeType.EXTERNAL_CONDITION);
    }

    public void setRandomExternal(RandomElement rndGen, double noiseStddev) {
        this.setInteractionType(new InteractionType("external_" + this.getIndex(), new LognormalNoise(rndGen, new ConstantModel(rndGen.uniform(0.0, 1.0)), noiseStddev, this)));
        this.setNodeType(NodeType.EXTERNAL_CONDITION);
    }

    public void setExternal(RandomElement rndGen, double value, double noiseStddev) {
        this.setInteractionType(new InteractionType("external_" + this.getIndex(), new LognormalNoise(rndGen, new ConstantModel(value), noiseStddev, this)));
        this.setNodeType(NodeType.EXTERNAL_CONDITION);
    }

    public void setCorrelatedExternal(RandomElement rndGen, Node t, double slope, double correlationNoise) {
        double intercept = slope < 0.0 ? 1 : 0;
        double x = t.getProbabilityModel().sample(rndGen, new double[0], new int[0]);
        double y = slope * x + intercept;
        if (y < 0.0) {
            y = 0.0;
        }
        if (y > 1.0) {
            y = 1.0;
        }
        this.setInteractionType(new InteractionType("external_" + this.getIndex(), new LognormalNoise(rndGen, new ConstantModel(y), correlationNoise, this)));
        this.setNodeType(NodeType.EXTERNAL_CONDITION);
    }

    public final String getStringOfType() {
        if (this.getInteractionType() == null) {
            return "?";
        }
        return this.getInteractionType().toString();
    }

    public final String toString() {
        return "node_" + this.getIndex();
    }

    public String toXML(String indentString) {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(indentString) + "<Node id=\"" + this.index + "\" name=\"" + this.getName() + "\" type=\"" + this.getNodeType().getName() + "\"  maxExpression=\"" + this.getMaxExpression() + "\" >\n");
        if (this.getInteractionType() != null) {
            sb.append(String.valueOf(indentString) + this.getInteractionType().toXML(String.valueOf(indentString) + "  ") + "\n");
        }
        sb.append(String.valueOf(indentString) + "</Node>\n");
        return sb.toString();
    }

    public static Node fromXML(GeneNetwork gn, RandomElement randomGen, String xml) throws SAXParseException {
        Node n = null;
        try {
            InteractionType type = null;
            Document dom = XmlXomReader.getDocument(xml);
            Element xmlNode = dom.getRootElement();
            if (!xmlNode.getLocalName().equals("Node")) {
                throw new SAXParseException("Error parsing xml string: a node must be of type regulator, output or external-condition", null);
            }
            int index = Integer.parseInt(xmlNode.getAttribute("id").getValue().toString());
            NodeType nodeType = NodeType.UNKNOWN;
            try {
                nodeType = new NodeType(xmlNode.getAttribute("type").getValue().toString());
            }
            catch (Exception e) {
                System.out.println("ERROR: unknown nodetype: " + nodeType);
                nodeType = NodeType.UNKNOWN;
            }
            String name = null;
            try {
                name = xmlNode.getAttribute("name").getValue().toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ArrayList<Node> children = new ArrayList<Node>();
            Elements list = xmlNode.getChildElements();
            int i = 0;
            while (i < list.size()) {
                Element el = list.get(i);
                if (el.getLocalName().equals("InteractionType")) {
                    if (type != null) {
                        throw new SAXParseException("Error parsing xml: multiple <InteractionType>-nodes found in <node>", null);
                    }
                    type = InteractionType.fromXML(randomGen, el.toXML());
                } else if (el.getLocalName().equals("childof")) {
                    int parentIndex = Integer.parseInt(el.getAttribute("id").getValue().toString());
                    Node parent = gn.getNode(parentIndex);
                    if (parent == null) {
                        throw new SAXParseException("Error parsing xml: parent node (id=" + parentIndex + ") does not exist for node id=" + index, null);
                    }
                    children.add(parent);
                }
                ++i;
            }
            Attribute maxExprAttrib = xmlNode.getAttribute("maxExpression");
            n = new Node(gn, index, nodeType);
            n.setInteractionType(type);
            n.setName(name);
            if (maxExprAttrib != null) {
                n.setMaxExpression(Double.parseDouble(maxExprAttrib.getValue().toString()));
            }
            int i2 = 0;
            while (i2 < children.size()) {
                gn.addDirectedEdge((Node)children.get(i2), n);
                ++i2;
            }
        }
        catch (Exception ex) {
            throw new SAXParseException(ex.getMessage(), null);
        }
        return n;
    }

    public int getX() {
        return this.xpos;
    }

    public int getY() {
        return this.ypos;
    }
}

