/*
 * Decompiled with CFR 0.152.
 */
package islab.bayesian.genenetwork;

public final class NodeType {
    private String name;
    private String abbrev;
    public static final NodeType UNKNOWN = new NodeType("unknown", "U");
    public static final NodeType EXTERNAL_CONDITION = new NodeType("external-condition", "E");
    public static final NodeType OUTPUT = new NodeType("output", "O");
    public static final NodeType REGULATOR = new NodeType("regulator", "R");
    public static final NodeType KNOCKOUT = new NodeType("knockout", "K");
    public static final NodeType TOP_NODE = new NodeType("topnode", "T");
    public static final NodeType[] nodeType = new NodeType[]{UNKNOWN, EXTERNAL_CONDITION, OUTPUT, REGULATOR};

    private NodeType(String name, String abbrev) {
        this.name = name;
        this.abbrev = abbrev;
    }

    public NodeType(String name) {
        this.name = name;
        this.abbrev = name.substring(0, 1).toUpperCase();
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public String getAbbreviation() {
        return this.abbrev;
    }

    public boolean equals(Object o) {
        return o != null && this.getClass() == o.getClass() && this.name.equals(((NodeType)o).name) && this.abbrev.equals(((NodeType)o).abbrev);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.name.hashCode();
        result = 37 * result + this.abbrev.hashCode();
        return result;
    }
}

