/*
 * Decompiled with CFR 0.152.
 */
package islab.bayesian.genenetwork;

import islab.bayesian.DataSet;
import islab.bayesian.IProvideMean;
import islab.lib.XmlXomReader;
import java.util.Hashtable;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import org.xml.sax.SAXParseException;

public class OneActivatorCoop
implements IProvideMean {
    double V0max;
    double V1max;
    double n;
    double Kh;

    public OneActivatorCoop(double V0max, double V1max, double n, double Kh) {
        assert (V1max > V0max) : "For an activator Vmax has to be larger than V0max";
        assert (n >= 1.0) : "For cooperativity Hill factor n should be > 1; n == 1 means no cooperativity";
        this.V0max = V0max;
        this.V1max = V1max;
        this.n = n;
        this.Kh = Kh;
    }

    public double computeMean(double[] configuration, int[] indexIncoming) {
        assert (indexIncoming.length == 1) : "expected 1 activator";
        double A = configuration[indexIncoming[0]];
        double v = (this.V0max + this.V1max * (Math.pow(A, this.n) / Math.pow(this.Kh, this.n))) / (1.0 + Math.pow(A, this.n) / Math.pow(this.Kh, this.n));
        double Kd = (this.V0max + this.V1max / Math.pow(this.Kh, this.n)) / (1.0 + 1.0 / Math.pow(this.Kh, this.n));
        double vMin = this.V0max;
        return (v - vMin) / (Kd - vMin);
    }

    public boolean train(DataSet dataset, int[] indices, int index, int[] indexIncoming) {
        throw new RuntimeException("Not implemented!");
    }

    public String toXML(String indentString) {
        return this.toXML(1, indentString);
    }

    public String toXML(int indentLevel, String indentString) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < indentLevel) {
            sb.append(indentString);
            ++i;
        }
        String indent = sb.toString();
        sb = new StringBuffer();
        sb.append(String.valueOf(indent) + "<IProvideMean>\n");
        sb.append(String.valueOf(indent) + "  <function name=\"OneActivatorCoop\">\n");
        sb.append(String.valueOf(indent) + "    <parameter name=\"V0max\">" + this.V0max + "</parameter>\n");
        sb.append(String.valueOf(indent) + "    <parameter name=\"V1max\">" + this.V1max + "</parameter>\n");
        sb.append(String.valueOf(indent) + "    <parameter name=\"Hillconstant\">" + this.n + "</parameter>\n");
        sb.append(String.valueOf(indent) + "    <parameter name=\"Kh\">" + this.Kh + "</parameter>\n");
        sb.append(String.valueOf(indent) + "  </function>\n");
        sb.append(String.valueOf(indent) + "</IProvideMean>\n");
        return sb.toString();
    }

    public static OneActivatorCoop fromXML(String xml) throws SAXParseException {
        Document dom = XmlXomReader.getDocument(xml);
        Element xmlNode = dom.getRootElement();
        if (!xmlNode.getLocalName().equals("IProvideMean")) {
            throw new SAXParseException("Error parsing xml string: node must be of type IProvideMean", null);
        }
        Element function = xmlNode.getChildElements("function").get(0);
        if (!function.getAttribute("name").getValue().equals("OneActivatorCoop")) {
            throw new SAXParseException("Error parsing xml string: function must be OneActivatorCoop", null);
        }
        Hashtable<String, Integer> initialized = new Hashtable<String, Integer>();
        Integer dummy = new Integer(1);
        double V0max = 0.0;
        double V1max = 0.0;
        double Hillconstant = 0.0;
        double Kh = 0.0;
        Elements params = function.getChildElements("parameter");
        int i = 0;
        while (i < params.size()) {
            Element par = params.get(i);
            String name = par.getAttribute("name").getValue();
            if (name.equals("V0max")) {
                initialized.put("V0max", dummy);
                V0max = Double.parseDouble(par.getValue());
            } else if (name.equals("V1max")) {
                initialized.put("V1max", dummy);
                V1max = Double.parseDouble(par.getValue());
            } else if (name.equals("Hillconstant")) {
                initialized.put("Hillconstant", dummy);
                Hillconstant = Double.parseDouble(par.getValue());
            } else if (name.equals("Kh")) {
                initialized.put("Kh", dummy);
                Kh = Double.parseDouble(par.getValue());
            } else {
                System.err.println("WARNING: unknown parameter " + name + " in function " + function.getAttribute("name").getValue());
            }
            ++i;
        }
        if (!(initialized.containsKey("V0max") && initialized.containsKey("V1max") && initialized.containsKey("Hillconstant") && initialized.containsKey("Kh"))) {
            throw new SAXParseException("error parsing <IProvideMean>, function OneActivatorCoop: one or more parameters not found.", null);
        }
        return new OneActivatorCoop(V0max, V1max, Hillconstant, Kh);
    }
}

