/*
 * Decompiled with CFR 0.152.
 */
package islab.bayesian.genenetwork;

import islab.bayesian.DataSet;
import islab.bayesian.IProvideMean;
import islab.lib.XmlXomReader;
import java.util.Hashtable;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import org.xml.sax.SAXParseException;

public class OneActivatorOneRepressorComp
implements IProvideMean {
    double V0max;
    double V1max;
    double Ka;
    double Ki;
    boolean firstIsActivator;

    public OneActivatorOneRepressorComp(double V0max, double V1max, double Ka, double Ki, boolean firstIsActivator) {
        assert (V1max > V0max) : "For an activator Vmax has to be larger than V0max";
        this.V0max = V0max;
        this.V1max = V1max;
        this.Ka = Ka;
        this.Ki = Ki;
        this.firstIsActivator = firstIsActivator;
    }

    public double computeMean(double[] configuration, int[] indexIncoming) {
        assert (indexIncoming.length == 2) : "expected 1 activator and 1 repressor";
        double A = configuration[indexIncoming[this.firstIsActivator ? 0 : 1]];
        double I = configuration[indexIncoming[this.firstIsActivator ? 1 : 0]];
        double numerator = this.V0max + this.V1max * A / this.Ka;
        double denominator = 1.0 + I / this.Ki + A / this.Ka;
        double v = numerator / denominator;
        double Kd = (this.V0max + this.V1max / this.Ka) / (1.0 + 1.0 / this.Ka);
        double vMin = this.V0max / (1.0 + 1.0 / this.Ki);
        return (v - vMin) / (Kd - vMin);
    }

    public boolean train(DataSet dataset, int[] indices, int index, int[] indexIncoming) {
        throw new RuntimeException("Not implemented!");
    }

    public String toXML(String indentString) {
        return this.toXML(1, indentString);
    }

    public String toXML(int indentLevel, String indentString) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < indentLevel) {
            sb.append(indentString);
            ++i;
        }
        String indent = sb.toString();
        sb = new StringBuffer();
        sb.append(String.valueOf(indent) + "<IProvideMean>\n");
        sb.append(String.valueOf(indent) + "  <function name=\"OneActivatorOneRepressorComp\">\n");
        sb.append(String.valueOf(indent) + "    <parameter name=\"V0max\">" + this.V0max + "</parameter>\n");
        sb.append(String.valueOf(indent) + "    <parameter name=\"V1max\">" + this.V1max + "</parameter>\n");
        sb.append(String.valueOf(indent) + "    <parameter name=\"Ka\">" + this.Ka + "</parameter>\n");
        sb.append(String.valueOf(indent) + "    <parameter name=\"Ki\">" + this.Ki + "</parameter>\n");
        sb.append(String.valueOf(indent) + "    <parameter name=\"firstIsActivator\">" + this.firstIsActivator + "</parameter>\n");
        sb.append(String.valueOf(indent) + "  </function>\n");
        sb.append(String.valueOf(indent) + "</IProvideMean>\n");
        return sb.toString();
    }

    public static OneActivatorOneRepressorComp fromXML(String xml) throws SAXParseException {
        try {
            Document dom = XmlXomReader.getDocument(xml);
            Element xmlNode = dom.getRootElement();
            if (!xmlNode.getLocalName().equals("IProvideMean")) {
                throw new SAXParseException("Error parsing xml string: node must be of type IProvideMean", null);
            }
            Element function = xmlNode.getChildElements("function").get(0);
            if (!function.getAttribute("name").getValue().equals("OneActivatorOneRepressorComp")) {
                throw new SAXParseException("Error parsing xml string: function must be OneActivatorOneRepressorComp", null);
            }
            Hashtable<String, Integer> initialized = new Hashtable<String, Integer>();
            Integer dummy = new Integer(1);
            double V0max = 0.0;
            double V1max = 0.0;
            double Ka = 0.0;
            double Ki = 0.0;
            boolean firstIsActivator = false;
            Elements params = function.getChildElements("parameter");
            int i = 0;
            while (i < params.size()) {
                Element par = params.get(i);
                String name = par.getAttribute("name").getValue();
                if (name.equals("V0max")) {
                    initialized.put("V0max", dummy);
                    V0max = Double.parseDouble(par.getValue());
                } else if (name.equals("V1max")) {
                    initialized.put("V1max", dummy);
                    V1max = Double.parseDouble(par.getValue());
                } else if (name.equals("Ka")) {
                    initialized.put("Ka", dummy);
                    Ka = Double.parseDouble(par.getValue());
                } else if (name.equals("Ki")) {
                    initialized.put("Ki", dummy);
                    Ki = Double.parseDouble(par.getValue());
                } else if (name.equals("firstIsActivator")) {
                    initialized.put("firstIsActivator", dummy);
                    firstIsActivator = Boolean.parseBoolean(par.getValue());
                } else {
                    System.err.println("WARNING: unknown parameter " + name + " in function " + function.getAttribute("name").getValue());
                }
                ++i;
            }
            if (!(initialized.containsKey("V0max") && initialized.containsKey("V1max") && initialized.containsKey("Ka") && initialized.containsKey("Ki") && initialized.containsKey("firstIsActivator"))) {
                throw new SAXParseException("error parsing <IProvideMean>, function OneActivatorOneRepressorComp: one or more parameters not found.", null);
            }
            return new OneActivatorOneRepressorComp(V0max, V1max, Ka, Ki, firstIsActivator);
        }
        catch (Exception ex) {
            throw new SAXParseException(ex.getMessage(), null);
        }
    }
}

