/*
 * Decompiled with CFR 0.152.
 */
package islab.bayesian.genenetwork;

import islab.bayesian.DataSet;
import islab.bayesian.IProvideMean;
import islab.lib.XmlXomReader;
import java.util.Hashtable;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import org.xml.sax.SAXParseException;

public class OneRepressorCoop
implements IProvideMean {
    double V0max;
    double n;
    double Kh;

    public OneRepressorCoop(double V0max, double n, double Kh) {
        this.V0max = V0max;
        this.n = n;
        this.Kh = Kh;
    }

    public double computeMean(double[] configuration, int[] indexIncoming) {
        assert (indexIncoming.length == 1) : "expected 1 repressor";
        double R = configuration[indexIncoming[0]];
        double v = this.V0max * (Math.pow(this.Kh, this.n) / (Math.pow(this.Kh, this.n) + Math.pow(R, this.n)));
        double Kd = this.V0max;
        double vMin = this.V0max * (Math.pow(this.Kh, this.n) / (Math.pow(this.Kh, this.n) + 1.0));
        return (v - vMin) / (Kd - vMin);
    }

    public boolean train(DataSet dataset, int[] indices, int index, int[] indexIncoming) {
        throw new RuntimeException("Not implemented!");
    }

    public String toXML(String indentString) {
        return this.toXML(1, indentString);
    }

    public String toXML(int indentLevel, String indentString) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < indentLevel) {
            sb.append(indentString);
            ++i;
        }
        String indent = sb.toString();
        sb = new StringBuffer();
        sb.append(String.valueOf(indent) + "<IProvideMean>\n");
        sb.append(String.valueOf(indent) + "  <function name=\"OneRepressorCoop\">\n");
        sb.append(String.valueOf(indent) + "    <parameter name=\"V0max\">" + this.V0max + "</parameter>\n");
        sb.append(String.valueOf(indent) + "    <parameter name=\"Hillconstant\">" + this.n + "</parameter>\n");
        sb.append(String.valueOf(indent) + "    <parameter name=\"Kh\">" + this.Kh + "</parameter>\n");
        sb.append(String.valueOf(indent) + "  </function>\n");
        sb.append(String.valueOf(indent) + "</IProvideMean>\n");
        return sb.toString();
    }

    public static OneRepressorCoop fromXML(String xml) throws SAXParseException {
        try {
            Document dom = XmlXomReader.getDocument(xml);
            Element xmlNode = dom.getRootElement();
            if (!xmlNode.getLocalName().equals("IProvideMean")) {
                throw new SAXParseException("Error parsing xml string: node must be of type IProvideMean", null);
            }
            Element function = xmlNode.getChildElements("function").get(0);
            if (!function.getAttribute("name").getValue().equals("OneRepressorCoop")) {
                throw new SAXParseException("Error parsing xml string: function must be OneRepressorCoop", null);
            }
            Hashtable<String, Integer> initialized = new Hashtable<String, Integer>();
            Integer dummy = new Integer(1);
            double Vmax = 0.0;
            double Hillconstant = 0.0;
            double Kh = 0.0;
            Elements params = function.getChildElements("parameter");
            int i = 0;
            while (i < params.size()) {
                Element par = params.get(i);
                String name = par.getAttribute("name").getValue();
                if (name.equals("V0max")) {
                    initialized.put("V0max", dummy);
                    Vmax = Double.parseDouble(par.getValue());
                } else if (name.equals("Hillconstant")) {
                    initialized.put("Hillconstant", dummy);
                    Hillconstant = Double.parseDouble(par.getValue());
                } else if (name.equals("Kh")) {
                    initialized.put("Kh", dummy);
                    Kh = Double.parseDouble(par.getValue());
                } else {
                    System.err.println("WARNING: unknown parameter " + name + " in function " + function.getAttribute("name").getValue());
                }
                ++i;
            }
            if (!(initialized.containsKey("V0max") && initialized.containsKey("Hillconstant") && initialized.containsKey("Kh"))) {
                throw new SAXParseException("error parsing <IProvideMean>, function OneRepressorCoop: one or more parameters not found.", null);
            }
            return new OneRepressorCoop(Vmax, Hillconstant, Kh);
        }
        catch (Exception ex) {
            throw new SAXParseException(ex.getMessage(), null);
        }
    }
}

