/*
 * Decompiled with CFR 0.152.
 */
package islab.bayesian.genenetwork;

import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.RandomEngine;
import islab.bayesian.DataSet;
import islab.bayesian.IProvideMean;
import islab.lib.XmlXomReader;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import org.xml.sax.SAXParseException;

public class RandomModel
implements IProvideMean {
    private RandomEngine rnd;
    private int seed;

    public RandomModel(int seed) {
        this.seed = seed;
        this.rnd = new MersenneTwister(seed);
    }

    public double computeMean(double[] configuration, int[] indexIncoming) {
        return this.rnd.nextDouble();
    }

    public String toXML(String indentString) {
        return this.toXML(1, indentString);
    }

    public String toXML(int indentLevel, String indentString) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < indentLevel) {
            sb.append(indentString);
            ++i;
        }
        String indent = sb.toString();
        sb = new StringBuffer();
        sb.append(String.valueOf(indent) + "<IProvideMean>\n");
        sb.append(String.valueOf(indent) + "  <function name=\"RandomModel\">\n");
        sb.append(String.valueOf(indent) + "    <parameter name=\"seed\">" + this.seed + "</parameter>\n");
        sb.append(String.valueOf(indent) + "  </function>\n");
        sb.append(String.valueOf(indent) + "</IProvideMean>\n");
        return sb.toString();
    }

    public static RandomModel fromXML(String xml) throws SAXParseException {
        Document dom = XmlXomReader.getDocument(xml);
        Element xmlNode = dom.getRootElement();
        if (!xmlNode.getLocalName().equals("IProvideMean")) {
            throw new SAXParseException("Error parsing xml string: node must be of type IProvideMean", null);
        }
        Element function = xmlNode.getChildElements("function").get(0);
        if (!function.getAttribute("name").getValue().toString().equals("RandomModel")) {
            throw new SAXParseException("Error parsing xml string: function must be RandomModel", null);
        }
        Elements params = function.getChildElements("parameter");
        if (params.size() != 1) {
            throw new SAXParseException("Error parsing xml string: expected only one parameter: 'seed' ", null);
        }
        Element param = params.get(0);
        if (!param.getAttribute("name").getValue().toString().equals("seed")) {
            throw new SAXParseException("Error parsing xml string: parameter must be seed", null);
        }
        int seed = Integer.parseInt(param.getValue());
        RandomModel rm = new RandomModel(seed);
        return rm;
    }

    public boolean train(DataSet dataset, int[] indices, int index, int[] indexIncoming) {
        throw new RuntimeException("Not implemented!");
    }
}

