/*
 * Decompiled with CFR 0.152.
 */
package islab.bayesian.genenetwork;

import cern.jet.random.engine.MersenneTwister;
import islab.bayesian.ConstantModel;
import islab.bayesian.DataSet;
import islab.bayesian.LognormalNoise;
import islab.bayesian.Network;
import islab.bayesian.ProbabilityModel;
import islab.bayesian.genenetwork.GeneNetwork;
import islab.bayesian.genenetwork.GroupOfNetworks;
import islab.bayesian.genenetwork.Node;
import islab.lib.RandomElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;

public class Sample {
    private boolean binary;
    private ProbabilityModel[] pm;
    private boolean[] fixed;
    private boolean[] fixedByUser;
    private double[] fixedTo;
    private GroupOfNetworks gn;
    private int nVariables;
    private Network nw;
    private RandomElement random;

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Syntax: <n> <network 1> ... <network n> <selection> <seed> <nr of samples> <outputfile>");
            System.err.println("The selection can be used to fix externals of certain networks");
            System.err.println("true|false: decide whether only the extrema are used for sampling the external conditions");
            System.exit(1);
        }
        int numberOfNetworks = new Integer(args[0]);
        String[] subset = new String[numberOfNetworks];
        int i = 0;
        while (i < numberOfNetworks) {
            subset[i] = args[i + 1];
            ++i;
        }
        GroupOfNetworks gn = new GroupOfNetworks(subset);
        String selection = args[numberOfNetworks + 1];
        gn.setSelection(selection);
        int seed = new Integer(args[numberOfNetworks + 2]);
        MersenneTwister mt = new MersenneTwister(seed);
        int size = new Integer(args[numberOfNetworks + 3]);
        Sample sampler = new Sample(new RandomElement(mt), gn);
        try {
            DataSet ds = sampler.sampleAndSave(size);
            ds.saveToFile(args[numberOfNetworks + 4]);
        }
        catch (IOException ioe) {
            System.err.println("Error writing file: " + ioe.getMessage());
        }
    }

    public GroupOfNetworks getGroupOfNetworks() {
        return this.gn;
    }

    public Sample(RandomElement random, GroupOfNetworks gn) {
        this.random = random;
        this.gn = gn;
        this.nw = gn.bigGN().toNetwork();
        this.nVariables = this.nw.getNVariables();
        this.fixedTo = new double[this.nVariables];
        this.fixed = new boolean[this.nVariables];
        this.fixedByUser = new boolean[this.nVariables];
        this.pm = new LognormalNoise[this.nVariables];
    }

    public void nextSample(double[] sample) {
        this.nw.sample(this.random, sample, this.fixed);
    }

    public void nextSample(double[] sample, int knockout) {
        boolean prev = this.fixed[knockout];
        this.fixed[knockout] = true;
        sample[knockout] = 0.0;
        this.nw.sample(this.random, sample, this.fixed);
        this.fixed[knockout] = prev;
    }

    public DataSet sampleAndSave(int nrSamples) {
        double[] sample = new double[this.gn.bigGN().getNVariables()];
        DataSet data = new DataSet(this.gn.bigGN().getNVariables(), nrSamples);
        ArrayList nodes = this.gn.bigGN().getNodes();
        int j = 0;
        while (j < nodes.size()) {
            data.setHeader(j, ((Node)nodes.get(j)).getName());
            ++j;
        }
        int i = 0;
        while (i < nrSamples) {
            this.nextSample(sample);
            int j2 = 0;
            while (j2 < sample.length) {
                data.set(i, j2, sample[j2]);
                ++j2;
            }
            data.experimentIds[i] = "sample_" + i;
            ++i;
        }
        return data;
    }

    public DataSet[] sampleAndSaveWithFeedback(int nrBurninIterations, int nrSamples, double[] initialValues, double expNoise, RandomElement rnd) {
        GeneNetwork bigGN = this.gn.bigGN();
        DataSet data = new DataSet(bigGN.getNVariables(), nrSamples);
        DataSet dataUnnorm = new DataSet(bigGN.getNVariables(), nrSamples);
        ArrayList nodes = this.gn.bigGN().getNodes();
        int j = 0;
        while (j < nodes.size()) {
            data.setHeader(j, ((Node)nodes.get(j)).getName());
            dataUnnorm.setHeader(j, ((Node)nodes.get(j)).getName());
            ++j;
        }
        double[] sample = initialValues;
        int i = 0;
        while (i < nrBurninIterations) {
            this.nextSample(sample);
            ++i;
        }
        ConstantModel value = new ConstantModel(0.0);
        Node dummyNode = new Node(0);
        int i2 = 0;
        while (i2 < nrSamples) {
            this.nextSample(sample);
            int j2 = 0;
            while (j2 < sample.length) {
                value.setConstant(sample[j2]);
                LognormalNoise lnn = new LognormalNoise(rnd, value, expNoise, dummyNode);
                double sampleValue = lnn.sample(rnd, new double[]{sample[j2]}, new int[1]);
                data.set(i2, j2, sampleValue);
                dataUnnorm.set(i2, j2, sampleValue * ((Node)nodes.get(j2)).getMaxExpression());
                ++j2;
            }
            data.experimentIds[i2] = "sample_" + i2;
            dataUnnorm.experimentIds[i2] = "sample_" + i2;
            ++i2;
        }
        return new DataSet[]{data, dataUnnorm};
    }

    public DataSet[] sampleAndSaveWithFeedback(int nrBurninIterations, int nrSamples, double[] initialValues) {
        return this.sampleAndSaveWithFeedback(nrBurninIterations, nrSamples, initialValues, 0.0, new RandomElement(new MersenneTwister(3)));
    }

    public DataSet[] sampleAndSaveWithFeedback(int nrBurninIterations, int nrSamples) {
        double[] initValues = new double[this.gn.bigGN().getNVariables()];
        return this.sampleAndSaveWithFeedback(nrBurninIterations, nrSamples, initValues, 0.0, new RandomElement(new MersenneTwister(3)));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SampleNormalizationType {
        NORMALIZED,
        UNNORMALIZED;

    }

    public static class Examples {
        public static void example1() {
            int numberOfNetworks = 2;
            String[] subset = new String[numberOfNetworks];
            subset[0] = "./data/SimpleGeneNetwork_1.xml";
            subset[1] = "./data/SimpleGeneNetwork_2.xml";
            GroupOfNetworks gn = new GroupOfNetworks(subset);
            System.out.println("Reading networks " + subset[0] + " " + subset[1]);
            String selection = "RR";
            gn.setSelection(selection);
            GregorianCalendar cal = new GregorianCalendar();
            Date now = cal.getTime();
            MersenneTwister mt = new MersenneTwister(now);
            Sample sampler = new Sample(new RandomElement(mt), gn);
            try {
                int[] sampleSize = new int[]{100, 500, 1000, 5000, 10000};
                int i = 0;
                while (i < sampleSize.length) {
                    String fileName = "C:/Documents and Settings/vdbulcke/My Documents/Eclipse Projects/GeneNetwork/data/samples/sample" + sampleSize[i] + "GN_1_2.txt";
                    System.out.println("saving to " + fileName);
                    DataSet ds = sampler.sampleAndSave(sampleSize[i]);
                    ds.saveToFile(fileName);
                    ++i;
                }
            }
            catch (IOException ioe) {
                System.err.println("error writing file: " + ioe.getMessage());
            }
        }

        public static void example2() {
            int numberOfNetworks = 2;
            String[] subset = new String[numberOfNetworks];
            subset[0] = "./data/SimpleGeneNetwork_1.xml";
            subset[1] = "./data/SimpleGeneNetwork_2.xml";
            GroupOfNetworks gn = new GroupOfNetworks(subset);
            System.out.println("Reading networks " + subset[0] + " " + subset[1]);
            String selection = "RR";
            gn.setSelection(selection);
            GregorianCalendar cal = new GregorianCalendar();
            Date now = cal.getTime();
            MersenneTwister mt = new MersenneTwister(now);
            Sample sampler = new Sample(new RandomElement(mt), gn);
            try {
                int[] sampleSize = new int[]{100, 500, 1000, 5000, 10000};
                int i = 0;
                while (i < sampleSize.length) {
                    String fileName = "C:/Documents and Settings/vdbulcke/My Documents/Eclipse Projects/GeneNetwork/data/samples/sample" + sampleSize[i] + "GN_1_2.txt";
                    System.out.println("saving to " + fileName);
                    DataSet ds = sampler.sampleAndSave(sampleSize[i]);
                    ds.saveToFile(fileName);
                    ++i;
                }
            }
            catch (IOException ioe) {
                System.err.println("error writing file: " + ioe.getMessage());
            }
        }

        public static void examples_2004_08_26() {
            int numberOfNetworks = 1;
            String[] subset = new String[numberOfNetworks];
            subset[0] = "./data/experiments/2004-08-26 K2 whitenoise/network_all.xml";
            GroupOfNetworks gn = new GroupOfNetworks(subset);
            String selection = "R";
            gn.setSelection(selection);
            GregorianCalendar cal = new GregorianCalendar();
            Date now = cal.getTime();
            MersenneTwister mt = new MersenneTwister(now);
            Sample sampler = new Sample(new RandomElement(mt), gn);
            try {
                int[] sampleSize = new int[]{100, 500, 1000, 5000, 10000};
                int i = 0;
                while (i < sampleSize.length) {
                    String fileName = "C:/Documents and Settings/vdbulcke/My Documents/Eclipse Projects/GeneNetwork/data/experiments/2004-08-26 K2 whitenoise/sample_" + sampleSize[i] + ".txt";
                    System.out.println("saving to " + fileName);
                    DataSet ds = sampler.sampleAndSave(sampleSize[i]);
                    ds.saveToFile(fileName);
                    ++i;
                }
            }
            catch (IOException ioe) {
                System.err.println("error writing file: " + ioe.getMessage());
            }
        }

        public static void main(String[] args) {
        }
    }
}

