/*
 * Decompiled with CFR 0.152.
 */
package islab.bayesian.genenetwork;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import islab.bayesian.DataSet;
import islab.bayesian.IProvideMean;
import islab.lib.XmlHelper;
import islab.lib.XmlXomReader;
import nu.xom.Document;
import nu.xom.Element;
import org.xml.sax.SAXParseException;

public class SimpleLinearModel
implements IProvideMean {
    private DoubleMatrix1D b;
    private DoubleMatrix1D x;
    private int nParents;

    public SimpleLinearModel(int nParents) {
        this.nParents = nParents;
        this.b = null;
        this.x = new DenseDoubleMatrix1D(nParents + 1);
        this.x.set(0, 1.0);
    }

    public void setB(DoubleMatrix1D b) {
        this.b = b;
        if (b.size() != this.nParents + 1) {
            throw new RuntimeException("b's size doesn't match");
        }
    }

    public DoubleMatrix1D getB() {
        return this.b;
    }

    public double computeMean(double[] configuration, int[] indexIncoming) {
        if (indexIncoming == null && this.nParents == 0) {
            return this.b.get(0);
        }
        if (indexIncoming != null && this.nParents != indexIncoming.length) {
            throw new RuntimeException("expected nParents == indexIncoming");
        }
        if (this.b == null) {
            throw new RuntimeException("model not yet trained");
        }
        int i = 0;
        while (i < this.nParents) {
            this.x.set(i + 1, configuration[indexIncoming[i]]);
            ++i;
        }
        double result = this.b.zDotProduct(this.x);
        int i2 = 0;
        while (i2 < this.nParents) {
            if (this.b.get(i2 + 1) < 0.0) {
                this.x.set(i2 + 1, 0.0);
            } else {
                this.x.set(i2 + 1, 1.0);
            }
            ++i2;
        }
        double max = this.b.zDotProduct(this.x);
        int i3 = 0;
        while (i3 < this.nParents) {
            if (this.b.get(i3 + 1) < 0.0) {
                this.x.set(i3 + 1, 1.0);
            } else {
                this.x.set(i3 + 1, 0.0);
            }
            ++i3;
        }
        double min = this.b.zDotProduct(this.x);
        return (result - min) / (max - min);
    }

    public String toXML(String indentString) {
        return this.toXML(1, indentString);
    }

    public String toXML(int indentLevel, String indentString) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < indentLevel) {
            sb.append(indentString);
            ++i;
        }
        String indent = sb.toString();
        sb = new StringBuffer();
        sb.append(String.valueOf(indent) + "<IProvideMean>\n");
        sb.append(String.valueOf(indent) + "  <function name=\"SimpleLinearModel\">\n");
        sb.append(String.valueOf(indent) + "    <parameter name=\"b-vector\">\n");
        int i2 = 0;
        while (i2 < this.b.size()) {
            sb.append(String.valueOf(indent) + "      " + XmlHelper.tag("double", this.b.get(i2)) + "\n");
            ++i2;
        }
        sb.append(String.valueOf(indent) + "    </parameter>\n");
        sb.append(String.valueOf(indent) + "  </function>\n");
        sb.append(String.valueOf(indent) + "</IProvideMean>\n");
        return sb.toString();
    }

    public static SimpleLinearModel fromXML(String xml) throws SAXParseException {
        Document dom = XmlXomReader.getDocument(xml);
        Element xmlNode = dom.getRootElement();
        if (!xmlNode.getLocalName().equals("IProvideMean")) {
            throw new SAXParseException("Error parsing xml string: node must be of type IProvideMean", null);
        }
        Element function = xmlNode.getChildElements("function").get(0);
        if (!function.getAttribute("name").getValue().toString().equals("SimpleLinearModel")) {
            throw new SAXParseException("Error parsing xml string: function must be SimpleLinearModel", null);
        }
        Element bXml = function.getChildElements("parameter").get(0);
        if (!bXml.getAttribute("name").getValue().toString().equals("b-vector")) {
            throw new SAXParseException("Error parsing xml string: parameter must be b-vector", null);
        }
        int bSize = bXml.getChildElements("double").size();
        DenseDoubleMatrix1D b = new DenseDoubleMatrix1D(bSize);
        int i = 0;
        while (i < bSize) {
            b.set(i, XmlHelper.getDouble(bXml, "double", i));
            ++i;
        }
        SimpleLinearModel lm = new SimpleLinearModel(bSize - 1);
        lm.setB(b);
        return lm;
    }

    public boolean train(DataSet dataset, int[] indices, int index, int[] indexIncoming) {
        throw new RuntimeException("Not implemented!");
    }
}

