/*
 * Decompiled with CFR 0.152.
 */
package islab.bayesian.genenetwork;

import islab.bayesian.DataSet;
import islab.bayesian.IProvideMean;
import islab.lib.XmlXomReader;
import java.util.Hashtable;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import org.xml.sax.SAXParseException;

public class TwoActivatorsSynergism
implements IProvideMean {
    double V0max;
    double V1max;
    double V2max;
    double K1a;
    double K2a;
    double beta;

    public TwoActivatorsSynergism(double V0max, double V1max, double V2max, double K1a, double K2a, double beta) {
        this.V0max = V0max;
        this.V1max = V1max;
        this.V2max = V2max;
        this.K1a = K1a;
        this.K2a = K2a;
        this.beta = beta;
    }

    public double computeMean(double[] configuration, int[] indexIncoming) {
        assert (indexIncoming.length == 2) : "expected 2 activators";
        double A1 = configuration[indexIncoming[0]];
        double A2 = configuration[indexIncoming[1]];
        double V3max = this.beta * (this.V1max + this.V2max);
        double numerator = this.V0max + this.V1max * A1 / this.K1a + this.V2max * A2 / this.K2a + V3max * A1 * A2 / (this.K1a * this.K2a);
        double denominator = 1.0 + A1 / this.K1a + A2 / this.K2a + A1 * A2 / (this.K1a * this.K2a);
        double v = numerator / denominator;
        double Kd = (this.V0max + this.V1max / this.K1a + this.V2max / this.K2a + V3max / (this.K1a * this.K2a)) / (1.0 + 1.0 / this.K1a + 1.0 / this.K2a + 1.0 / (this.K1a * this.K2a));
        double vMin = this.V0max;
        return (v - vMin) / (Kd - vMin);
    }

    public boolean train(DataSet dataset, int[] indices, int index, int[] indexIncoming) {
        throw new RuntimeException("Not implemented!");
    }

    public String toXML(String indentString) {
        return this.toXML(1, indentString);
    }

    public String toXML(int indentLevel, String indentString) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < indentLevel) {
            sb.append(indentString);
            ++i;
        }
        String indent = sb.toString();
        sb = new StringBuffer();
        sb.append(String.valueOf(indent) + "<IProvideMean>\n");
        sb.append(String.valueOf(indent) + "  <function name=\"TwoActivatorsSynergism\">\n");
        sb.append(String.valueOf(indent) + "    <parameter name=\"V0max\">" + this.V0max + "</parameter>\n");
        sb.append(String.valueOf(indent) + "    <parameter name=\"V1max\">" + this.V1max + "</parameter>\n");
        sb.append(String.valueOf(indent) + "    <parameter name=\"V2max\">" + this.V2max + "</parameter>\n");
        sb.append(String.valueOf(indent) + "    <parameter name=\"K1a\">" + this.K1a + "</parameter>\n");
        sb.append(String.valueOf(indent) + "    <parameter name=\"K2a\">" + this.K2a + "</parameter>\n");
        sb.append(String.valueOf(indent) + "    <parameter name=\"beta\">" + this.beta + "</parameter>\n");
        sb.append(String.valueOf(indent) + "  </function>\n");
        sb.append(String.valueOf(indent) + "</IProvideMean>\n");
        return sb.toString();
    }

    public static TwoActivatorsSynergism fromXML(String xml) throws SAXParseException {
        try {
            Document dom = XmlXomReader.getDocument(xml);
            Element xmlNode = dom.getRootElement();
            if (!xmlNode.getLocalName().equals("IProvideMean")) {
                throw new SAXParseException("Error parsing xml string: node must be of type IProvideMean", null);
            }
            Element function = xmlNode.getChildElements("function").get(0);
            if (!function.getAttribute("name").getValue().equals("TwoActivatorsSynergism")) {
                throw new SAXParseException("Error parsing xml string: function must be TwoActivatorsSynergism", null);
            }
            Hashtable<String, Integer> initialized = new Hashtable<String, Integer>();
            Integer dummy = new Integer(1);
            double V0max = 0.0;
            double V1max = 0.0;
            double V2max = 0.0;
            double K1a = 0.0;
            double K2a = 0.0;
            double beta = 0.0;
            Elements params = function.getChildElements("parameter");
            int i = 0;
            while (i < params.size()) {
                Element par = params.get(i);
                String name = par.getAttribute("name").getValue();
                if (name.equals("V0max")) {
                    initialized.put("V0max", dummy);
                    V0max = Double.parseDouble(par.getValue());
                } else if (name.equals("V1max")) {
                    initialized.put("V1max", dummy);
                    V1max = Double.parseDouble(par.getValue());
                } else if (name.equals("V2max")) {
                    initialized.put("V2max", dummy);
                    V2max = Double.parseDouble(par.getValue());
                } else if (name.equals("K1a")) {
                    initialized.put("K1a", dummy);
                    K1a = Double.parseDouble(par.getValue());
                } else if (name.equals("K2a")) {
                    initialized.put("K2a", dummy);
                    K2a = Double.parseDouble(par.getValue());
                } else if (name.equals("beta")) {
                    initialized.put("beta", dummy);
                    beta = Double.parseDouble(par.getValue());
                } else {
                    System.err.println("WARNING: unknown parameter " + name + " in function " + function.getAttribute("name").getValue());
                }
                ++i;
            }
            if (!(initialized.containsKey("V0max") && initialized.containsKey("V1max") && initialized.containsKey("V2max") && initialized.containsKey("K1a") && initialized.containsKey("K2a") && initialized.containsKey("beta"))) {
                throw new SAXParseException("error parsing <IProvideMean>, function TwoActivatorsSynergism: one or more parameters not found.", null);
            }
            return new TwoActivatorsSynergism(V0max, V1max, V2max, K1a, K2a, beta);
        }
        catch (Exception ex) {
            throw new SAXParseException(ex.getMessage(), null);
        }
    }
}

