/*
 * Decompiled with CFR 0.152.
 */
package islab.bayesian.genenetwork.generation;

import islab.bayesian.DataSet;
import islab.bayesian.LognormalNoise;
import islab.bayesian.genenetwork.GeneNetwork;
import islab.bayesian.genenetwork.GroupOfNetworks;
import islab.bayesian.genenetwork.Node;
import islab.bayesian.genenetwork.NodeType;
import islab.bayesian.genenetwork.Sample;
import islab.bayesian.genenetwork.generation.ExternalNodeNotFoundException;
import islab.lib.DelimitedFileReader;
import islab.lib.Print;
import islab.lib.RandomElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataGenerator {
    public static DataSet[] generateDataSetsRandomizedExternals(GeneNetwork gn, int burnIn, int nrSamplesPerExtCon, int nrExperiments, double inputNoise, double bioNoise, double expNoise, RandomElement rndGen) {
        List<Double> oldNoise = DataGenerator.setBioNoise(gn, bioNoise);
        Print.println("sampling...");
        double[] initialValues = new double[gn.getNNodes()];
        Arrays.fill(initialValues, 0.5);
        gn.randomizeExternalConditions(rndGen, inputNoise);
        Sample sample = new Sample(rndGen, new GroupOfNetworks(new GeneNetwork[]{gn}));
        DataSet[] ds = sample.sampleAndSaveWithFeedback(burnIn, nrSamplesPerExtCon, initialValues, expNoise, rndGen);
        int ii = 1;
        while (ii < nrExperiments) {
            gn.randomizeExternalConditions(rndGen, inputNoise);
            sample = new Sample(rndGen, new GroupOfNetworks(new GeneNetwork[]{gn}));
            Arrays.fill(initialValues, 0.5);
            DataSet[] ds2 = sample.sampleAndSaveWithFeedback(burnIn, nrSamplesPerExtCon, initialValues, expNoise, rndGen);
            ds[0].append(ds2[0]);
            ds[1].append(ds2[1]);
            ++ii;
        }
        int i = 0;
        while (i < nrExperiments) {
            int j = 0;
            while (j < nrSamplesPerExtCon) {
                ds[0].experimentIds[i] = "exp_" + i + "_smpl_" + j;
                ds[1].experimentIds[i] = "exp_" + i + "_smpl_" + j;
                ++j;
            }
            ++i;
        }
        DataGenerator.restoreBioNoise(gn, oldNoise);
        return ds;
    }

    public static DataSet[] generateDataSetsPredefinedExternals(GeneNetwork gn, int burnIn, int nrSamplesPerExtCon, DelimitedFileReader externalConditions, double inputNoise, double bioNoise, double expNoise, RandomElement rndGen) throws ExternalNodeNotFoundException {
        ArrayList externalConditionsList = new ArrayList();
        int nrExperiments = externalConditions.getNrColumns() - 1;
        int nrExternals = externalConditions.getNrRows();
        int col = 0;
        while (col < nrExperiments) {
            HashMap<String, Double> values = new HashMap<String, Double>();
            int row = 0;
            while (row < nrExternals) {
                values.put(externalConditions.getString(row, 0), externalConditions.getDouble(row, col + 1));
                ++row;
            }
            externalConditionsList.add(values);
            ++col;
        }
        List<Double> oldNoise = DataGenerator.setBioNoise(gn, bioNoise);
        Print.println("sampling...");
        double[] initialValues = new double[gn.getNNodes()];
        Arrays.fill(initialValues, 0.5);
        gn.setExternalConditions(rndGen, inputNoise, (HashMap)externalConditionsList.get(0));
        Sample sample = new Sample(rndGen, new GroupOfNetworks(new GeneNetwork[]{gn}));
        DataSet[] ds = sample.sampleAndSaveWithFeedback(burnIn, nrSamplesPerExtCon, initialValues, expNoise, rndGen);
        int ii = 1;
        while (ii < nrExperiments) {
            gn.setExternalConditions(rndGen, inputNoise, (HashMap)externalConditionsList.get(ii));
            sample = new Sample(rndGen, new GroupOfNetworks(new GeneNetwork[]{gn}));
            Arrays.fill(initialValues, 0.5);
            DataSet[] ds2 = sample.sampleAndSaveWithFeedback(burnIn, nrSamplesPerExtCon, initialValues, expNoise, rndGen);
            ds[0].append(ds2[0]);
            ds[1].append(ds2[1]);
            ++ii;
        }
        DataGenerator.restoreBioNoise(gn, oldNoise);
        int col2 = 1;
        while (col2 < externalConditions.getNrColumns()) {
            ds[0].experimentIds[col2 - 1] = externalConditions.getHeader(col2);
            ds[1].experimentIds[col2 - 1] = externalConditions.getHeader(col2);
            ++col2;
        }
        return ds;
    }

    public static DataSet[] generateDataSetsWithoutRandomizingExternals(GeneNetwork gn, int burnIn, int nrSamples, double inputNoise, double bioNoise, double expNoise, RandomElement rndGen) {
        List<Double> oldNoise = DataGenerator.setBioNoise(gn, bioNoise);
        List<Double> oldInputNoise = DataGenerator.setInputNoise(gn, inputNoise);
        Print.println("sampling...");
        double[] initialValues = new double[gn.getNNodes()];
        Arrays.fill(initialValues, 0.5);
        Sample sample = new Sample(rndGen, new GroupOfNetworks(new GeneNetwork[]{gn}));
        DataSet[] ds = sample.sampleAndSaveWithFeedback(burnIn, nrSamples, initialValues, expNoise, rndGen);
        DataGenerator.restoreInputNoise(gn, oldInputNoise);
        DataGenerator.restoreBioNoise(gn, oldNoise);
        int j = 0;
        while (j < nrSamples) {
            ds[0].experimentIds[j] = "sample_" + j;
            ds[1].experimentIds[j] = "sample_" + j;
            ++j;
        }
        return ds;
    }

    public static List<Double> setBioNoise(GeneNetwork gn, double bioNoise) {
        System.out.println("setting BioNoise");
        ArrayList<Double> oldNoise = new ArrayList<Double>(gn.getNNodes());
        for (Node n : gn.getNodes()) {
            LognormalNoise pm = (LognormalNoise)n.getProbabilityModel();
            oldNoise.add(pm.getStddev());
            if (n.getNodeType() == NodeType.EXTERNAL_CONDITION) continue;
            pm.setStddev(bioNoise);
        }
        return oldNoise;
    }

    public static void restoreBioNoise(GeneNetwork gn, List<Double> oldNoise) {
        System.out.println("restoring BioNoise");
        int i = 0;
        while (i < oldNoise.size()) {
            Node n = gn.getNode(i);
            if (n.getNodeType() != NodeType.EXTERNAL_CONDITION) {
                LognormalNoise pm = (LognormalNoise)n.getProbabilityModel();
                pm.setStddev(oldNoise.get(i));
            }
            ++i;
        }
    }

    public static List<Double> setInputNoise(GeneNetwork gn, double inputNoise) {
        System.out.println("setting inputNoise");
        ArrayList<Double> oldNoise = new ArrayList<Double>(gn.getNNodes());
        for (Node n : gn.getNodes(NodeType.EXTERNAL_CONDITION)) {
            LognormalNoise pm = (LognormalNoise)n.getProbabilityModel();
            oldNoise.add(pm.getStddev());
            pm.setStddev(inputNoise);
        }
        return oldNoise;
    }

    public static void restoreInputNoise(GeneNetwork gn, List<Double> oldInputNoise) {
        System.out.println("restoring inputNoise");
        int i = 0;
        for (Node n : gn.getNodes(NodeType.EXTERNAL_CONDITION)) {
            LognormalNoise pm = (LognormalNoise)n.getProbabilityModel();
            pm.setStddev(oldInputNoise.get(i++));
        }
    }
}

