/*
 * Decompiled with CFR 0.152.
 */
package islab.bayesian.genenetwork.generation;

import islab.bayesian.DataSet;
import islab.bayesian.IncidenceMatrix;
import islab.bayesian.genenetwork.CreateNetworkException;
import islab.bayesian.genenetwork.GeneNetwork;
import islab.bayesian.genenetwork.GroupOfNetworks;
import islab.bayesian.genenetwork.Node;
import islab.bayesian.genenetwork.NodeType;
import islab.bayesian.genenetwork.Sample;
import islab.bayesian.genenetwork.generation.GeneNetworkGenerator;
import islab.bayesian.genenetwork.generation.InteractionGenerator;
import islab.lib.Print;
import islab.lib.RandomElement;
import islab.lib.XmlHelper;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class ExpressionDataGeneration {
    public static void generateDataSets(int burnIn, int nrSamplesPerExtCon, int nrExperiments, int[] nrNodes, int[] nrBgrNodes, double[] higherOrderProb, double[] bioNoise, double[] expNoise, double correlationNoise, int nrExternal, int nrCorr, boolean selectionWithChildren, String sourceSifFile, String savePath, RandomElement rndGen) {
        String path = savePath;
        String withChildren = selectionWithChildren ? "with children" : "without children";
        String withChildrenShort = selectionWithChildren ? "clustAdd" : "neighAdd";
        String subNetworkSelection = selectionWithChildren ? "clusterAddition" : "neighborAddition";
        new File(savePath).mkdirs();
        int i = 0;
        while (i < nrNodes.length) {
            int j = 0;
            while (j < nrBgrNodes.length) {
                int k = 0;
                while (k < higherOrderProb.length) {
                    int n = 0;
                    while (n < bioNoise.length) {
                        int x = 0;
                        while (x < expNoise.length) {
                            Print.println("gene network creation ...");
                            try {
                                GeneNetwork gn = GeneNetworkGenerator.createRandomizedGNFromSIFFileSubnetwork(subNetworkSelection, sourceSifFile, nrNodes[i], nrBgrNodes[j], nrExternal, nrCorr, bioNoise[n], 0.0, correlationNoise, higherOrderProb[k], 0.5, true, InteractionGenerator.InteractionCategory.DEFAULT, rndGen);
                                IncidenceMatrix outIM = GeneNetworkGenerator.subnetIM;
                                XmlHelper.saveToFile(String.valueOf(path) + "nn" + nrNodes[i] + "_nbgr" + nrBgrNodes[j] + "_hop" + higherOrderProb[k] + "_bionoise" + bioNoise[n] + "_expnoise" + expNoise[x] + "_corrnoise" + correlationNoise + "_" + withChildrenShort + "_network.sif", outIM.toSIF());
                                XmlHelper.saveToFile(String.valueOf(path) + "nn" + nrNodes[i] + "_nbgr" + nrBgrNodes[j] + "_hop" + higherOrderProb[k] + "_bionoise" + bioNoise[n] + "_expnoise" + expNoise[x] + "_corrnoise" + correlationNoise + "_" + withChildrenShort + "_network.xml", gn.toXML(""));
                                ArrayList ext = gn.getNodes(NodeType.EXTERNAL_CONDITION);
                                String str = "Regulator\n";
                                int index = 0;
                                while (index < ext.size()) {
                                    Node node = (Node)ext.get(index);
                                    str = String.valueOf(str) + node.getName() + "\n";
                                    ++index;
                                }
                                XmlHelper.saveToFile(String.valueOf(path) + "nn" + nrNodes[i] + "_nbgr" + nrBgrNodes[j] + "_hop" + higherOrderProb[k] + "_bionoise" + bioNoise[n] + "_expnoise" + expNoise[x] + "_corrnoise" + correlationNoise + "_" + withChildrenShort + "_external.txt", str);
                                StringWriter sw = new StringWriter();
                                PrintWriter pw = new PrintWriter(sw);
                                Map m = gn.getCorrelatedExternal();
                                for (Node key : m.keySet()) {
                                    pw.printf("node %s correlated with node %s\n", key.getName(), ((Node)m.get(key)).getName());
                                }
                                XmlHelper.saveToFile(String.valueOf(path) + "nn" + nrNodes[i] + "_nbgr" + nrBgrNodes[j] + "_hop" + higherOrderProb[k] + "_bionoise" + bioNoise[n] + "_expnoise" + expNoise[x] + "_corrnoise" + correlationNoise + "_" + withChildrenShort + "_correlatedExternal.txt", sw.toString());
                                double[] initialValues = new double[gn.getNNodes()];
                                Arrays.fill(initialValues, 0.5);
                                Print.println("sampling...");
                                Sample sample = new Sample(rndGen, new GroupOfNetworks(new GeneNetwork[]{gn}));
                                DataSet[] ds = sample.sampleAndSaveWithFeedback(burnIn, nrSamplesPerExtCon, initialValues, expNoise[x], rndGen);
                                int ii = 0;
                                while (ii < nrExperiments - 1) {
                                    gn.randomizeExternalConditions(rndGen);
                                    sample = new Sample(rndGen, new GroupOfNetworks(new GeneNetwork[]{gn}));
                                    Arrays.fill(initialValues, 0.5);
                                    DataSet[] ds2 = sample.sampleAndSaveWithFeedback(burnIn, nrSamplesPerExtCon, initialValues, expNoise[x], rndGen);
                                    ds[0].append(ds2[0]);
                                    ds[1].append(ds2[1]);
                                    ++ii;
                                }
                                int e = 0;
                                while (e < nrExperiments) {
                                    ds[0].experimentIds[e] = "sample_" + e;
                                    ds[1].experimentIds[e] = "sample_" + e;
                                    ++e;
                                }
                                String fname = String.valueOf(path) + "nn" + nrNodes[i] + "_nbgr" + nrBgrNodes[j] + "_hop" + higherOrderProb[k] + "_bionoise" + bioNoise[n] + "_expnoise" + expNoise[x] + "_corrnoise" + correlationNoise + "_" + withChildrenShort;
                                Print.println("saving datasets " + ds[0].getNObservations() + " to files " + fname + "_(maxExpr1|unnormalized)_dataset.txt");
                                ds[0].saveToFile(String.valueOf(fname) + "_maxExpr1_dataset.txt", true);
                                ds[1].saveToFile(String.valueOf(fname) + "_unnormalized_dataset.txt", true);
                                Print.println("saved");
                            }
                            catch (CreateNetworkException e) {
                                System.err.println("ERROR: Could not create gene network: \n" + e.getMessage());
                            }
                            catch (IOException e) {
                                System.err.println("Could not save file:\n" + e.getMessage());
                            }
                            ++x;
                        }
                        ++n;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }
}

