/*
 * Decompiled with CFR 0.152.
 */
package islab.bayesian.genenetwork.generation;

import islab.bayesian.ConstantModel;
import islab.bayesian.IncidenceMatrix;
import islab.bayesian.LognormalNoise;
import islab.bayesian.Network;
import islab.bayesian.genenetwork.CreateNetworkException;
import islab.bayesian.genenetwork.GeneNetwork;
import islab.bayesian.genenetwork.InteractionType;
import islab.bayesian.genenetwork.Node;
import islab.bayesian.genenetwork.NodeType;
import islab.bayesian.genenetwork.generation.InteractionGenerator;
import islab.lib.RandomElement;
import islab.util.DiscreteUniform;
import islab.util.SeqUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;

public class GeneNetworkGenerator {
    public static IncidenceMatrix subnetIM;

    public static GeneNetwork createRandomizedGNFromCompleteSIFFile(String sifFile, int nrExternal, int nrCorr, double bioNoiseStddev, double inputNoiseStddev, double correlationNoiseStddev, double higherOrderProbability, double percentActivators, boolean useEdgeTypesFromSIF, InteractionGenerator.InteractionCategory interactionCategory, RandomElement rndGen) throws CreateNetworkException {
        IncidenceMatrix im = IncidenceMatrix.fromSIF(sifFile);
        if (im.getNrTopNodes() == 0) {
            throw new CreateNetworkException("Cannot create this network with " + nrExternal + " external nodes. It has no topnodes");
        }
        if (im.getNrTopNodes() < nrExternal) {
            throw new CreateNetworkException("Cannot create a network with " + nrExternal + " external nodes");
        }
        if (nrCorr != -1) {
            int nrExt;
            int n = nrExt = nrExternal == -1 ? im.getNrTopNodes() : nrExternal;
            if (nrCorr < 0 || nrCorr >= nrExt) {
                throw new CreateNetworkException("Invalid value for nr of Correlated External Inputs");
            }
        }
        GeneNetwork gn = GeneNetwork.fromIncidenceMatrix(im, false, bioNoiseStddev, higherOrderProbability, rndGen);
        gn.setRandomMaxExpressionValues(rndGen.getRandomEngine());
        InteractionGenerator.setEdgeTypes(gn, percentActivators, useEdgeTypesFromSIF, rndGen.getRandomEngine());
        InteractionGenerator.setRandomInteractions(interactionCategory, gn, higherOrderProbability, bioNoiseStddev, rndGen);
        ArrayList topNodes = gn.getTopNodes();
        if (nrExternal == -1) {
            int i = 0;
            while (i < topNodes.size()) {
                Node ext = (Node)topNodes.get(i);
                ext.setRandomExternal(rndGen, inputNoiseStddev);
                ++i;
            }
        } else {
            int cntr = 0;
            while (cntr < nrExternal) {
                Node ext = (Node)DiscreteUniform.pickOne(topNodes, rndGen.getRandomEngine());
                topNodes.remove(ext);
                ext.setRandomExternal(rndGen, inputNoiseStddev);
                ++cntr;
            }
            for (Node node : topNodes) {
                node.setInteractionType(new InteractionType("topnode_" + node.getIndex(), new LognormalNoise(rndGen, new ConstantModel(rndGen.uniform(0.0, 1.0)), inputNoiseStddev, node)));
                node.setNodeType(NodeType.TOP_NODE);
            }
        }
        if (nrCorr == -1) {
            nrCorr = (int)Math.floor(gn.getNExternalConditions() / 2);
        }
        gn.setCorrExtCond(rndGen, nrCorr, correlationNoiseStddev);
        return gn;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GeneNetwork createRandomizedGNFromCompleteSIFFileExternalsFixed(String sifFile, String externalsFile, int nrCorr, double bioNoiseStddev, double inputNoiseStddev, double correlationNoiseStddev, double higherOrderProbability, double percentActivators, boolean useEdgeTypesFromSIF, InteractionGenerator.InteractionCategory interactionCategory, RandomElement rndGen) throws CreateNetworkException {
        IncidenceMatrix im = IncidenceMatrix.fromSIF(sifFile);
        GeneNetwork gn = GeneNetwork.fromIncidenceMatrix(im, false, bioNoiseStddev, higherOrderProbability, rndGen);
        gn.setRandomMaxExpressionValues(rndGen.getRandomEngine());
        InteractionGenerator.setEdgeTypes(gn, percentActivators, useEdgeTypesFromSIF, rndGen.getRandomEngine());
        InteractionGenerator.setRandomInteractions(interactionCategory, gn, higherOrderProbability, bioNoiseStddev, rndGen);
        HashSet<String> externals = null;
        try {
            externals = new HashSet<String>();
            BufferedReader extreader = new BufferedReader(new FileReader(externalsFile));
            String header = extreader.readLine().split("\t")[0];
            if (!header.equals("Regulators")) {
                throw new RuntimeException("Not a valid regulators file: first line must be a header line starting with 'Regulators'\nfound: " + header);
            }
            while (true) {
                String line;
                if ((line = extreader.readLine()) == null) {
                    extreader.close();
                    break;
                }
                externals.add(line.split("\t")[0]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ArrayList topNodes = gn.getTopNodes();
        ArrayList topNodesNames = SeqUtil.mapMethod("getName", topNodes, new Object[0]);
        for (String s : externals) {
            if (topNodesNames.contains(s)) continue;
            throw new RuntimeException("Error: We have a problem: this is not an external node (should not have any parents): " + s + "\n should be in list: " + ((Object)topNodesNames).toString());
        }
        int nrExternal = externals.size();
        if (nrCorr != -1 && (nrCorr < 0 || nrCorr >= nrExternal)) {
            throw new CreateNetworkException("Invalid value for nr of Correlated External Inputs");
        }
        int i = 0;
        while (i < topNodes.size()) {
            Node node = (Node)topNodes.get(i);
            if (externals.contains(node.getName())) {
                node.setRandomExternal(rndGen, inputNoiseStddev);
            } else {
                node.setInteractionType(new InteractionType("topnode_" + node.getIndex(), new LognormalNoise(rndGen, new ConstantModel(rndGen.uniform(0.0, 1.0)), inputNoiseStddev, node)));
                node.setNodeType(NodeType.TOP_NODE);
            }
            ++i;
        }
        if (nrCorr == -1) {
            nrCorr = (int)Math.floor(gn.getNExternalConditions() / 2);
        }
        gn.setCorrExtCond(rndGen, nrCorr, correlationNoiseStddev);
        return gn;
    }

    public static GeneNetwork createRandomizedGNFromSIFFileSubnetwork(String subNetworkSelection, String sifFile, int nrNodes, int nrBackgroundNodes, int nrExternal, int nrCorr, double bioNoiseStddev, double inputNoiseStddev, double correlationNoiseStddev, double higherOrderProbability, double percentActivators, boolean useEdgeTypesFromSIF, InteractionGenerator.InteractionCategory interactionCategory, RandomElement rndGen) throws CreateNetworkException {
        ArrayList bgrTopNodes;
        IncidenceMatrix subIM;
        IncidenceMatrix completeSubIM = null;
        IncidenceMatrix im = IncidenceMatrix.fromSIF(sifFile);
        if (im.getNrTopNodes() == 0) {
            throw new CreateNetworkException("Cannot create this network with " + nrExternal + " external nodes. It has no topnodes");
        }
        if (im.getNrTopNodes() < nrExternal) {
            throw new CreateNetworkException("Cannot create a network with " + nrExternal + " external nodes, not enough topnodes in source network");
        }
        if (nrCorr != -1) {
            int nrExt;
            int n = nrExt = nrExternal == -1 ? im.getNrTopNodes() : nrExternal;
            if (nrCorr < 0 || nrCorr >= nrExt) {
                throw new CreateNetworkException("Invalid value for nr of Correlated External Inputs");
            }
        }
        int MAX_ITER = 5000;
        int cntr = 0;
        do {
            if (++cntr > 1) {
                System.out.println("insufficient top nodes, attempt " + cntr);
            }
            if (subNetworkSelection.equals("clusterAddition")) {
                subIM = im.randomSubgraphWithChildren(rndGen, nrNodes);
                continue;
            }
            if (subNetworkSelection.equals("neighborAddition")) {
                subIM = im.randomSubgraph(rndGen, nrNodes);
                continue;
            }
            throw new CreateNetworkException("Do not know subnetwork selection method: " + subNetworkSelection + ". Only know 'neighborAddition' and 'clusterAddition'.");
        } while (nrExternal != -1 && subIM.getNrTopNodes() < nrExternal && cntr < MAX_ITER);
        if (cntr >= MAX_ITER) {
            throw new CreateNetworkException("Cannot create a network with " + nrExternal + " external nodes in " + MAX_ITER + " steps");
        }
        if (nrBackgroundNodes > 0) {
            IncidenceMatrix backgroundSubIM;
            if (subNetworkSelection.equals("clusterAddition")) {
                backgroundSubIM = im.randomSubgraphWithChildren(rndGen, nrBackgroundNodes);
            } else if (subNetworkSelection.equals("neighborAddition")) {
                backgroundSubIM = im.randomSubgraph(rndGen, nrBackgroundNodes);
            } else {
                throw new CreateNetworkException("Do not know subnetwork selection method: " + subNetworkSelection + ". Only know 'neighborAddition' and 'clusterAddition'.");
            }
            int i = 0;
            while (i < backgroundSubIM.size()) {
                backgroundSubIM.set(i, "bgr_" + backgroundSubIM.getName(i));
                ++i;
            }
            GeneNetwork bgrGn = GeneNetwork.fromIncidenceMatrix(backgroundSubIM, rndGen);
            bgrGn.convertToDAG();
            bgrGn.integrityCheck();
            if (!bgrGn.toNetwork().isDAG()) {
                System.out.println("ERROR: background network is not converted to a DAG!");
                bgrGn.convertToDAG();
                Network n = bgrGn.toNetwork();
                n.convertToDAG();
                if (n.isDAG()) {
                    System.out.println(" and same routine in Network returns DAG!");
                }
                System.exit(-1);
            }
            try {
                PrintWriter tmpFile = new PrintWriter("./tmp.tmp");
                bgrGn.toSIF(tmpFile);
                tmpFile.close();
                backgroundSubIM = IncidenceMatrix.fromSIF("./tmp.tmp");
                if (!new File("./tmp.tmp").delete()) {
                    System.out.println("could't delete tmp.tmp, please delete manually...");
                }
            }
            catch (FileNotFoundException e) {
                System.out.println(e.getMessage());
                System.exit(-1);
            }
            bgrTopNodes = bgrGn.getTopNodes();
            completeSubIM = IncidenceMatrix.mergeAndDisconnect(subIM, backgroundSubIM);
        } else {
            completeSubIM = subIM;
            bgrTopNodes = null;
        }
        if (completeSubIM == null) {
            throw new CreateNetworkException("Cannot create a random subnetwork for unknown reason, resulting completeSubIM is null.");
        }
        GeneNetwork gn = GeneNetwork.fromIncidenceMatrix(completeSubIM, false, bioNoiseStddev, higherOrderProbability, rndGen);
        gn.setRandomMaxExpressionValues(rndGen.getRandomEngine());
        ArrayList topNodes = gn.getTopNodes();
        ArrayList<Node> backgroundTopNodes = new ArrayList<Node>();
        if (nrBackgroundNodes > 0) {
            int i = 0;
            while (i < bgrTopNodes.size()) {
                int j = 0;
                while (j < topNodes.size()) {
                    if (((Node)topNodes.get(j)).getName().equals(((Node)bgrTopNodes.get(i)).getName())) {
                        Node x = (Node)topNodes.get(j);
                        topNodes.remove(x);
                        backgroundTopNodes.add(x);
                    }
                    ++j;
                }
                ++i;
            }
        }
        InteractionGenerator.setEdgeTypes(gn, percentActivators, useEdgeTypesFromSIF, rndGen.getRandomEngine());
        InteractionGenerator.setRandomInteractions(interactionCategory, gn, higherOrderProbability, bioNoiseStddev, rndGen);
        if (nrExternal == -1) {
            int i = 0;
            while (i < topNodes.size()) {
                Node ext = (Node)topNodes.get(i);
                ext.setRandomExternal(rndGen, inputNoiseStddev);
                ++i;
            }
        } else {
            int cntr2 = 0;
            while (cntr2 < nrExternal) {
                Node ext = (Node)DiscreteUniform.pickOne(topNodes, rndGen.getRandomEngine());
                topNodes.remove(ext);
                ext.setRandomExternal(rndGen, inputNoiseStddev);
                ++cntr2;
            }
            for (Node node : topNodes) {
                node.setInteractionType(new InteractionType("topnode_" + node.getIndex(), new LognormalNoise(rndGen, new ConstantModel(rndGen.uniform(0.0, 1.0)), inputNoiseStddev, node)));
                node.setNodeType(NodeType.TOP_NODE);
            }
        }
        for (Node node : backgroundTopNodes) {
            node.setInteractionType(new InteractionType("bgr_topnode_" + node.getIndex(), new LognormalNoise(rndGen, new ConstantModel(rndGen.uniform(0.0, 1.0)), inputNoiseStddev, node)));
            node.setNodeType(NodeType.TOP_NODE);
        }
        if (nrCorr == -1) {
            nrCorr = (int)Math.floor(gn.getNExternalConditions() / 2);
        }
        gn.setCorrExtCond(rndGen, nrCorr, correlationNoiseStddev);
        subnetIM = completeSubIM;
        return gn;
    }
}

