/*
 * Decompiled with CFR 0.152.
 */
package islab.bayesian.genenetwork.generation;

import islab.bayesian.genenetwork.generation.InteractionGenerator;
import islab.util.IniFileParser;
import java.io.IOException;

public class IniSettings {
    public boolean selectSubnetwork;
    public boolean fixedExternals;
    public boolean createGeneNetwork;
    public ExternalInputValues externalInputValues;
    public boolean generateExpressionData;
    public int randomSeed;
    public String subnetworkSelection;
    public int nrNodes;
    public int nrBackgroundNodes;
    public double percentActivators;
    public InteractionGenerator.InteractionCategory interactionCategory;
    public int nrExternals;
    public int nrCorrelatedExternals;
    public boolean useEdgeTypesFromSIF;
    public double bioNoise;
    public double inputNoise;
    public double expNoise;
    public double correlationNoise;
    public double higherOrderProbability;
    public int burnIn;
    public int nrExperiments;
    public int nrSamplesPerExp;
    public String sifFile;
    public String xmlFile;
    public String externalsFile;
    public String outputdir;

    public IniSettings() {
    }

    public IniSettings(String fileName) {
        IniFileParser ip = null;
        try {
            ip = new IniFileParser(fileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.selectSubnetwork = ip.parseBooleanValue("selectSubnetwork");
        this.fixedExternals = ip.parseBooleanValue("fixedExternals");
        this.createGeneNetwork = ip.parseBooleanValue("createGeneNetwork");
        this.generateExpressionData = ip.parseBooleanValue("generateExpressionData");
        this.randomSeed = ip.parseIntValue("randomSeed");
        this.xmlFile = ip.parseStringValue("GeneNetworkXMLFile");
        if (this.createGeneNetwork) {
            this.sifFile = ip.parseStringValue("NetworkSIFFile");
            if (this.selectSubnetwork) {
                this.subnetworkSelection = ip.parseStringValue("subnetworkSelection");
                if (this.fixedExternals) {
                    System.out.println("Cannot have fixed externals when selecting a subnetwork");
                    System.exit(2);
                }
                this.nrNodes = ip.parseIntValue("nrNodes");
                this.nrBackgroundNodes = ip.parseIntValue("nrBackgroundNodes");
                this.nrCorrelatedExternals = ip.parseIntValue("nrCorrelatedExternals");
                this.correlationNoise = ip.parseDoubleValue("correlationNoise");
            }
            if (this.fixedExternals) {
                this.externalsFile = ip.parseStringValue("externalsFile");
            } else {
                this.nrExternals = ip.parseIntValue("nrExternals");
            }
            this.percentActivators = ip.parseDoubleValue("percentActivators");
            this.interactionCategory = ip.parseEnumValue(InteractionGenerator.InteractionCategory.class, "interactionCategory");
            this.useEdgeTypesFromSIF = ip.parseBooleanValue("useEdgeTypesFromSIF");
            this.higherOrderProbability = ip.parseDoubleValue("higherOrderProbability");
        }
        if (this.generateExpressionData) {
            this.externalInputValues = ExternalInputValues.valueOf(ip.parseStringValue("externalInputValues"));
            this.bioNoise = ip.parseDoubleValue("bioNoise");
            this.inputNoise = ip.parseDoubleValue("inputNoise");
            this.expNoise = ip.parseDoubleValue("expNoise");
            if (this.externalInputValues.equals((Object)ExternalInputValues.RANDOMIZED)) {
                this.nrExperiments = ip.parseIntValue("nrExperiments");
            }
            this.burnIn = ip.parseIntValue("burnIn");
            this.nrSamplesPerExp = ip.parseIntValue("nrSamplesPerExp");
            this.outputdir = ip.parseStringValue("outputdir");
            if (this.outputdir.endsWith("/")) {
                this.outputdir = this.outputdir.substring(0, this.outputdir.length() - 1);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExternalInputValues {
        FIXED,
        RANDOMIZED,
        FROM_EXTERNALS_FILE;

    }
}

